/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.greenhopper.jira.permission.GHProjectPermissions;
import com.atlassian.greenhopper.upgrade.AbstractGhUpgradeTask;
import com.atlassian.greenhopper.upgrade.GhUpgradeTask049;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class GhUpgradeTask050
extends AbstractGhUpgradeTask {
    @Autowired
    private GhUpgradeTask049 upgradeTask049;
    @Autowired
    private PermissionSchemeManager permissionSchemeManager;

    public String getShortDescription() {
        return "Re-performs the migration for Manage Sprints permission due to the rollback as the consequence of HOT-35978";
    }

    public int getBuildNumber() {
        return 50;
    }

    @Override
    protected void performUpgrade() {
        this.log.info("Finding all schemes which currently have Manage Sprint entities", new Object[0]);
        this.permissionSchemeManager.getSchemeObjects().forEach(scheme -> {
            List allManageSprintEntitiesOfScheme = scheme.getEntitiesByType((Object)GHProjectPermissions.MANAGE_SPRINTS);
            if (!allManageSprintEntitiesOfScheme.isEmpty()) {
                this.log.info("Deleting %d Manage Sprint entity(ies) from %s", allManageSprintEntitiesOfScheme.size(), scheme.getName());
                this.permissionSchemeManager.deleteEntities(GhUpgradeTask050.extractIdOfSchemeEntities(allManageSprintEntitiesOfScheme));
            }
        });
        this.log.info("Start copying all current ADMINISTER_PROJECT entities to MANAGE_SPRINT!", new Object[0]);
        this.upgradeTask049.performUpgrade();
    }

    private static List<Long> extractIdOfSchemeEntities(List<SchemeEntity> schemeEntities) {
        return schemeEntities.stream().mapToLong(schemeEntity -> schemeEntity.getId()).boxed().collect(Collectors.toList());
    }
}

