/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.greenhopper.jira.permission.GHProjectPermissions;
import com.atlassian.greenhopper.upgrade.AbstractGhUpgradeTask;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import java.util.List;
import java.util.Objects;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;

public class GhUpgradeTask049
extends AbstractGhUpgradeTask {
    @Autowired
    protected PermissionSchemeManager permissionSchemeManager;

    public int getBuildNumber() {
        return 49;
    }

    public String getShortDescription() {
        return "Migrate existing Project Administer permission holders to also have Manage Sprints permission";
    }

    @Override
    protected void performUpgrade() {
        List allPermissionScheme = this.permissionSchemeManager.getSchemeObjects();
        for (Scheme scheme : allPermissionScheme) {
            try {
                GenericValue schemeAsGenericValue = this.permissionSchemeManager.getScheme(scheme.getId());
                for (SchemeEntity entity : scheme.getEntitiesByType((Object)ProjectPermissions.ADMINISTER_PROJECTS)) {
                    if (this.isPermissionExistedInScheme(scheme, GHProjectPermissions.MANAGE_SPRINTS, entity.getType(), entity.getParameter())) continue;
                    this.permissionSchemeManager.createSchemeEntity(schemeAsGenericValue, new SchemeEntity(entity.getType(), entity.getParameter(), (Object)GHProjectPermissions.MANAGE_SPRINTS));
                }
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    private boolean isPermissionExistedInScheme(Scheme scheme, ProjectPermissionKey permissionKey, String type, String parameter) {
        for (SchemeEntity entity : scheme.getEntitiesByType((Object)permissionKey)) {
            if (!Objects.equals(entity.getType(), type) || !Objects.equals(entity.getParameter(), parameter)) continue;
            return true;
        }
        return false;
    }
}

