/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.upgrade.AbstractGhUpgradeTask;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.springframework.beans.factory.annotation.Autowired;

public class GhUpgradeTask048
extends AbstractGhUpgradeTask {
    private static final LoggerWrapper LOG = LoggerWrapper.with(GhUpgradeTask048.class);
    private static final String ISSUE_ENTITY_NAME = "Issue";
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private OfBizDelegator ofBizDelegator;
    @Autowired
    private ReindexMessageManager reindexMessageManager;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    private IssueType epicIssueType;

    public int getBuildNumber() {
        return 48;
    }

    public String getShortDescription() {
        return "Add reindex required message for Epic Label field searching";
    }

    @Override
    protected void performUpgrade() {
        if (!this.issueTypeService.hasIssueTypeId(IssueTypePrototype.EPIC)) {
            LOG.info("Epic issue type id is not defined", new Object[0]);
            return;
        }
        this.epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        if (this.hasAnyEpic()) {
            this.reindexMessageManager.pushMessage(this.jiraAuthenticationContext.getUser(), "Epic Name searching");
        }
    }

    private boolean hasAnyEpic() {
        EntityExpr epicCondition = new EntityExpr("type", EntityOperator.EQUALS, (Object)this.epicIssueType.getId());
        long numberOfEpic = Select.from((String)ISSUE_ENTITY_NAME).whereCondition((EntityCondition)epicCondition).runWith(this.ofBizDelegator).count();
        return numberOfEpic > 0L;
    }
}

