/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.greenhopper.upgrade.AbstractGhUpgradeTask;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.portal.CachingPortletConfigurationStore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GhUpgradeTask047
extends AbstractGhUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(GhUpgradeTask047.class);
    private static final List<String> classicGadgets = Lists.newArrayList((Object[])new String[]{"rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-project-dashboard/gadgets/greenhopper-project-dashboard.xml", "rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-card-view-gadget/gadgets/greenhopper-card-view.xml", "rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-cumulative-flow-chart/gadgets/greenhopper-cumulative-flow-chart.xml", "rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-hour-burndown-chart/gadgets/greenhopper-hour-burndown-chart.xml", "rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-days-remaining-gadget/gadgets/days-remaining.xml", "rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-project-progress/gadgets/greenhopper-project-progress.xml", "rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-custom-field-burndown-chart/gadgets/greenhopper-custom-field-burndown-chart.xml", "rest/gadgets/1.0/g/com.pyxis.greenhopper.jira:greenhopper-gadget-task-board/gadgets/greenhopper-task-board.xml"});
    private static final String GADGET_TABLE = "PortletConfiguration";
    private static final String GADGET_URI_COLUMN = "gadgetXml";
    @Autowired
    private OfBizDelegator ofBizDelegator;
    private CachingPortletConfigurationStore cachingPortletConfigurationStore = (CachingPortletConfigurationStore)ComponentAccessor.getComponent(CachingPortletConfigurationStore.class);

    @Override
    protected void performUpgrade() throws Exception {
        try {
            DateTime startedAt = DateTime.now();
            int deletedGadgets = Delete.from((String)GADGET_TABLE).whereCondition(this.getConditionRemoveClassicGadget()).execute(this.ofBizDelegator);
            log.debug(String.format("Upgrade task took %d seconds to remove %d classic gadgets.", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds(), deletedGadgets));
        }
        finally {
            this.cachingPortletConfigurationStore.flush();
        }
    }

    private EntityCondition getConditionRemoveClassicGadget() {
        ArrayList entityExprList = Lists.newArrayList();
        for (String classicGadget : classicGadgets) {
            entityExprList.add(new EntityExpr(GADGET_URI_COLUMN, EntityOperator.LIKE, (Object)classicGadget));
        }
        return new EntityConditionList((List)entityExprList, EntityOperator.OR);
    }

    public int getBuildNumber() {
        return 47;
    }

    public String getShortDescription() {
        return "Removing classic gadgets from dashboards";
    }
}

