/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.greenhopper.upgrade.AbstractGhUpgradeTask;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;

public class GhUpgradeTask046
extends AbstractGhUpgradeTask {
    @Autowired
    private StatusCategoryManager statusCategoryManager;
    @Autowired
    private ConstantsManager constantsManager;
    private static final String BACKLOG = "Backlog";
    private static final String SELECTED_FOR_DEVELOPMENT = "Selected for Development";
    private static final String TO_DO = "To Do";
    private static final String IN_PROGRESS = "In Progress";
    private static final String DONE = "Done";
    private static final String ENTITY_STATUS = "Status";
    private static final String STATUS_CATEGORY_COLUMN = "statuscategory";

    public int getBuildNumber() {
        return 46;
    }

    public String getShortDescription() {
        return "Sets status categories for (what is assumed to be) JIRA Agile's simple workflow's statuses.";
    }

    @Override
    public void performUpgrade() throws Exception {
        StatusCategory defaultStatusCategory = this.statusCategoryManager.getDefaultStatusCategory();
        StatusCategory newCategory = this.statusCategoryManager.getStatusCategoryByKey("new");
        StatusCategory completedCategory = this.statusCategoryManager.getStatusCategoryByKey("done");
        StatusCategory inProgressCategory = this.statusCategoryManager.getStatusCategoryByKey("indeterminate");
        this.log.info("Finding statuses with no assigned status category semantics...", new Object[0]);
        ArrayList statusesWithUndefinedSemantics = Lists.newArrayList();
        statusesWithUndefinedSemantics.addAll(GhUpgradeTask046.getEntityEngine().run((SelectQuery)Select.from((String)ENTITY_STATUS).whereNull(STATUS_CATEGORY_COLUMN)).asList());
        statusesWithUndefinedSemantics.addAll(GhUpgradeTask046.getEntityEngine().run((SelectQuery)Select.from((String)ENTITY_STATUS).whereEqual(STATUS_CATEGORY_COLUMN, defaultStatusCategory.getId())).asList());
        this.log.info("Found %d statuses with no status category", statusesWithUndefinedSemantics.size());
        for (GenericValue status : statusesWithUndefinedSemantics) {
            if (status == null) continue;
            String statusName = status.getString("name");
            String statusId = status.getString("id");
            if (statusName == null || statusId == null) continue;
            if (TO_DO.equals(statusName) || BACKLOG.equals(statusName)) {
                this.setStatusToCategory(statusId, newCategory.getId());
                continue;
            }
            if (SELECTED_FOR_DEVELOPMENT.equals(statusName) || IN_PROGRESS.equals(statusName)) {
                this.setStatusToCategory(statusId, inProgressCategory.getId());
                continue;
            }
            if (!DONE.equals(statusName)) continue;
            this.setStatusToCategory(statusId, completedCategory.getId());
        }
        this.constantsManager.invalidateAll();
    }

    public void setStatusToCategory(String statusId, Long newCategoryId) {
        this.log.info("Updating status %s to use status category %s", statusId, newCategoryId);
        Update.into((String)ENTITY_STATUS).set(STATUS_CATEGORY_COLUMN, newCategoryId).whereEqual("id", statusId).execute(GhUpgradeTask046.getEntityEngine());
    }

    protected static EntityEngine getEntityEngine() {
        return (EntityEngine)ComponentAccessor.getComponent(EntityEngine.class);
    }
}

