/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.upgrade.UpgradeVersionService;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGhUpgradeTask
implements PluginUpgradeTask {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private Logger upgradeLog = Logger.getLogger((String)"com.atlassian.greenhopper.upgrade");
    @Autowired
    private UpgradeVersionService upgradeVersionService;
    @Autowired
    private CustomFieldManager customFieldManager;
    public static final String REINDEX_ALLOWED_PROPERTY = "upgrade.reindex.allowed";

    private void logUpgradeTaskStart() {
        this.upgradeLog.info((Object)"=========================================");
        this.upgradeLog.info((Object)("Starting upgrade task (buildNumber=" + this.getBuildNumber() + ") : " + this.getShortDescription()));
    }

    private void logUpgradeTaskEnd() {
        this.upgradeLog.info((Object)("Upgrade task finished (buildNumber=" + this.getBuildNumber() + ") : " + this.getShortDescription()));
        this.upgradeLog.info((Object)"=========================================");
    }

    public final Collection<Message> doUpgrade() throws Exception {
        this.checkMinimumDataRequirement();
        this.upgradeVersionService.recordUpgradeTaskStarted(this.getBuildNumber());
        this.logUpgradeTaskStart();
        long then = System.currentTimeMillis();
        this.customFieldManager.refresh();
        this.performUpgrade();
        this.upgradeVersionService.recordUpgradeTaskEnded(this.getBuildNumber(), System.currentTimeMillis() - then);
        this.logUpgradeTaskEnd();
        this.upgradeVersionService.setLatestUpgradedVersion(this.getBuildNumber());
        return null;
    }

    private void checkMinimumDataRequirement() {
        if (!this.upgradeVersionService.hasAnyUpgradeTaskRunBefore()) {
            return;
        }
        Long latestUpgradeTaskRun = this.upgradeVersionService.getLatestUpgradeTaskRun();
        Long minimumRequiredBuildNumber = this.upgradeVersionService.getMinimumDataVersionRequiredForUpgrade();
        if (latestUpgradeTaskRun < minimumRequiredBuildNumber) {
            throw new IllegalStateException(String.format("This version of JIRA Agile requires a minimum build number of #%d in order to proceed. The latest upgrade task to have been successfully completed is #%d. You must uninstall this version of JIRA Agile and attempt an upgrade via an intermediary version.", minimumRequiredBuildNumber, latestUpgradeTaskRun));
        }
    }

    public String getPluginKey() {
        return "com.pyxis.greenhopper.jira";
    }

    protected boolean isReindexAllowed() {
        return Boolean.valueOf(JiraSystemProperties.getInstance().getProperty(REINDEX_ALLOWED_PROPERTY, "true"));
    }

    protected abstract void performUpgrade() throws Exception;
}

