/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.greenhopper.manager.lexorank.LexoRankAO;
import com.atlassian.greenhopper.manager.lexorank.LexoRankEntityDetails;
import com.atlassian.greenhopper.manager.lexorank.SqlUpdateStatement;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.jira.exception.DataAccessException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.schema.ddl.DDLAction;
import net.java.ao.schema.ddl.DDLActionType;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.types.TypeInfo;
import org.apache.log4j.Logger;

public class AOUpgradeTask001
implements ActiveObjectsUpgradeTask {
    private final Logger logger = Logger.getLogger(AOUpgradeTask001.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        this.logger.info((Object)"Starting upgrade task.");
        if (!activeObjects.moduleMetaData().isTablePresent(LexoRankAO.class)) {
            this.logger.info((Object)"No need to run upgrade task. Lexo rank table not found.");
            return;
        }
        LexoRankAO[] lexoRankAOs = (LexoRankAO[])activeObjects.find(LexoRankAO.class, Query.select().limit(1));
        if (lexoRankAOs.length == 0) {
            this.logger.info((Object)"No need to run upgrade task. No Lexo rank rows found.");
            return;
        }
        EntityManager entityManager = lexoRankAOs[0].getEntityManager();
        LexoRankEntityDetails entityDetails = LexoRankEntityDetails.get(entityManager, LexoRankAO.ColumnDetails.list(), false);
        this.addColumn(entityManager);
        this.updateBucketFieldFromRankField(entityDetails);
    }

    private void addColumn(EntityManager entityManager) {
        this.logger.info((Object)"Adding bucket column.");
        DatabaseProvider databaseProvider = entityManager.getProvider();
        DDLAction addColumnAction = this.createAddColumnAction(databaseProvider);
        Iterable renderColumnActions = databaseProvider.renderAction(entityManager.getNameConverters(), addColumnAction);
        HashSet completedStatements = new HashSet();
        try (Connection conn = databaseProvider.getConnection();
             Statement stmt = conn.createStatement();){
            databaseProvider.executeUpdatesForActions(stmt, renderColumnActions, completedStatements);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.logger.info((Object)String.format("Adding column completed successfully with %s statement executed.", completedStatements.size()));
    }

    private DDLAction createAddColumnAction(DatabaseProvider databaseProvider) {
        String bucketColumnName = "BUCKET";
        TypeInfo integerType = databaseProvider.getTypeManager().getType(Integer.class);
        DDLTable lexoRankTable = new DDLTable();
        lexoRankTable.setName("AO_60DB71_LEXORANK");
        DDLField bucketField = new DDLField();
        bucketField.setName("BUCKET");
        bucketField.setType(integerType);
        bucketField.setJdbcType(4);
        bucketField.setDefaultValue((Object)0);
        return DDLAction.builder((DDLActionType)DDLActionType.ALTER_ADD_COLUMN).setTable(lexoRankTable).setField(bucketField).build();
    }

    private void updateBucketFieldFromRankField(LexoRankEntityDetails entityDetails) {
        this.logger.info((Object)"Performing update query.");
        String bucketColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.BUCKET);
        String rankColumnName = entityDetails.getColumnName(LexoRankAO.ColumnDetails.RANK);
        long numUpdatedRows = 0L;
        for (LexoRankBucket bucket : LexoRankBucket.values()) {
            SqlUpdateStatement updateStatement = SqlUpdateStatement.builder(entityDetails).set(bucketColumnName + " = ?").withParam(bucket.intValue()).where("( " + bucketColumnName + " <> ? OR " + bucketColumnName + " IS NULL ) AND " + rankColumnName + " LIKE ?", bucket.intValue(), bucket.intValue() + "|%").build();
            try {
                numUpdatedRows += (long)updateStatement.execute();
            }
            catch (SQLException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
        this.logger.info((Object)String.format("Updated %s Lexorank rows with bucket column data.", numUpdatedRows));
    }
}

