/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sidebar.navigation;

import com.atlassian.greenhopper.sidebar.navigation.NavigationItemServiceAdapter;
import com.atlassian.greenhopper.sidebar.navigation.NavigationItemServiceAdapterImpl;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.LazyReference;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NavigationItemServiceAccessor {
    private static final String CLASS_NAME = "com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService";
    private LazyReference<Option<NavigationItemServiceAdapter>> adapter = new LazyReference<Option<NavigationItemServiceAdapter>>(){

        @Override
        protected Option<NavigationItemServiceAdapter> create() {
            return Option.option((Object)NavigationItemServiceAccessor.this.createAdapter());
        }
    };
    @Autowired
    private BundleContext bundleContext;

    public Option<NavigationItemServiceAdapter> get() {
        return this.adapter.get();
    }

    private NavigationItemServiceAdapter createAdapter() {
        Class<?> clazz = this.getNavigationItemServiceClass();
        if (clazz == null) {
            return null;
        }
        Object service = this.createServiceTracker(clazz).getService();
        if (service == null) {
            return null;
        }
        return new NavigationItemServiceAdapterImpl((NavigationItemService)service);
    }

    @VisibleForTesting
    protected ServiceTracker createServiceTracker(Class<?> clazz) {
        ServiceTracker serviceTracker = new ServiceTracker(this.bundleContext, clazz.getName(), null);
        serviceTracker.open();
        return serviceTracker;
    }

    private Class<?> getNavigationItemServiceClass() {
        try {
            return this.loadClass(CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @VisibleForTesting
    protected Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }
}

