/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sidebar.navigation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;

public class NavigationItem {
    private final List<NavigationItem> children;
    private final String href;
    private final Option<String> iconClass;
    private final String id;
    private final String label;
    private final Option<String> styleClass;

    public NavigationItem(String href, String iconClass, String id, String label, Iterable<NavigationItem> children) {
        this(href, iconClass, id, label, children, "");
    }

    public NavigationItem(String href, String iconClass, String id, String label, Iterable<NavigationItem> children, String styleClass) {
        this.href = href;
        this.id = id;
        this.iconClass = Option.option((Object)iconClass);
        this.label = label;
        this.children = ImmutableList.copyOf(children);
        this.styleClass = Option.option((Object)styleClass);
    }

    public List<NavigationItem> getChildren() {
        return Lists.newArrayList(this.children);
    }

    public String getHref() {
        return this.href;
    }

    public String getIconClass() {
        return (String)this.iconClass.getOrElse((Object)"");
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getStyleClass() {
        return (String)this.styleClass.getOrElse((Object)"");
    }
}

