/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.sidebar.legacy;

import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlComponents;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlTransformer;
import com.atlassian.jira.util.UrlBuilder;
import io.atlassian.fugue.Option;

public class LegacyBrowseAgileUrlTransformer
implements LegacyBrowseProjectUrlTransformer {
    public Option<String> getTransformedUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        if (this.canTransformLegacyUrl(legacyUrlComponents)) {
            return Option.some((Object)this.buildProjectCentricNavUrl(legacyUrlComponents));
        }
        return Option.none();
    }

    private boolean canTransformLegacyUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        Option selectedTab = legacyUrlComponents.getSelectedTab();
        return selectedTab.isDefined() && this.selectedTabIsOldAgileSection((String)selectedTab.get());
    }

    private boolean selectedTabIsOldAgileSection(String selectedTab) {
        return "com.pyxis.greenhopper.jira:greenhopper-project-panel-tab".equals(selectedTab);
    }

    private String buildProjectCentricNavUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        String contextPath = legacyUrlComponents.getContextPath();
        String projectKey = legacyUrlComponents.getProjectKey();
        UrlBuilder url = new UrlBuilder(contextPath, false);
        url.addPath("projects").addPath(projectKey);
        return url.asUrlString();
    }
}

