/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.workflow;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.TooManyProjectsForGetTransitionAnalyticsEvent;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.transition.TransitionManager;
import com.atlassian.jira.transition.WorkflowTransitionEntry;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.query.Query;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gh-workflowService")
public class WorkflowServiceImpl
implements WorkflowService {
    @Autowired
    private ConstantsManager constantsManager;
    @Autowired
    private SearchService jiraSearchService;
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private WorkflowSchemeManager workflowSchemeManager;
    @Autowired
    private WorkflowManager workflowManager;
    @Autowired
    private com.atlassian.jira.bc.workflow.WorkflowService jiraWorkflowService;
    @Autowired
    private TransitionManager transitionManager;
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Override
    public Status getWorkflowStatusObject(String statusId) {
        return this.constantsManager.getStatusObject(statusId);
    }

    @Override
    public Status getStatusByName(final String statusName) {
        if (statusName == null) {
            return null;
        }
        Collection statusObjects = this.constantsManager.getStatusObjects();
        return (Status)Iterables.find((Iterable)statusObjects, (Predicate)new Predicate<Status>(){

            public boolean apply(Status status) {
                return statusName.equalsIgnoreCase(status.getName());
            }
        }, null);
    }

    @Override
    public Set<Status> getAllWorkflowStatusObjects() {
        return new HashSet<Status>(this.constantsManager.getStatusObjects());
    }

    @Override
    public Set<Status> getAllActiveWorkflowStatusObjects() {
        HashSet statuses = Sets.newHashSet();
        Collection activeWorkflows = this.workflowManager.getActiveWorkflows();
        for (JiraWorkflow workflow : activeWorkflows) {
            statuses.addAll(workflow.getLinkedStatusObjects());
        }
        return statuses;
    }

    @Override
    @Nonnull
    public Set<Status> getAccessibleStatuses(ApplicationUser user, Query query) {
        QueryContext queryContext = this.jiraSearchService.getQueryContext(user, query);
        Collection projectIssueTypeContexts = queryContext.getProjectIssueTypeContexts();
        boolean globalContext = false;
        LinkedHashMap projectIssueTypeMappings = new LinkedHashMap();
        this.logger.debug("Query Context for query '%s' - %s", query, queryContext);
        for (Object projectIssueTypeContext : projectIssueTypeContexts) {
            ProjectContext projectContext = projectIssueTypeContext.getProjectContext();
            Collection issueTypeContexts = projectIssueTypeContext.getIssueTypeContexts();
            if (projectContext.isAll()) {
                globalContext = true;
                break;
            }
            Long projectId = projectContext.getProjectId();
            HashSet<String> issueTypeIds = new HashSet<String>();
            for (IssueTypeContext issueTypeContext : issueTypeContexts) {
                if (issueTypeContext.isAll()) continue;
                issueTypeIds.add(issueTypeContext.getIssueTypeId());
            }
            projectIssueTypeMappings.put(projectId, issueTypeIds);
        }
        if (globalContext) {
            return this.getAllActiveWorkflowStatusObjects();
        }
        HashSet<JiraWorkflow> workflows = new HashSet<JiraWorkflow>();
        for (Long projectId : projectIssueTypeMappings.keySet()) {
            Project projectObj = this.projectManager.getProjectObj(projectId);
            Set issueTypeIds = (Set)projectIssueTypeMappings.get(projectId);
            if (issueTypeIds.isEmpty()) {
                workflows.addAll(this.getJiraWorkflows(projectObj));
                continue;
            }
            for (String issueTypeId : issueTypeIds) {
                workflows.addAll(this.getJiraWorkflows(projectObj, issueTypeId));
            }
        }
        HashSet<Status> statuses = new HashSet<Status>();
        for (JiraWorkflow workflow : workflows) {
            statuses.addAll(workflow.getLinkedStatusObjects());
        }
        return statuses;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Boolean> isStatusInitialStatus(@Nonnull JiraWorkflow workflow, @Nonnull Status status) {
        StepDescriptor linkedStep = workflow.getLinkedStep(status);
        if (linkedStep == null) {
            return WorkflowServiceImpl.createNoLinkedStepError(workflow, status);
        }
        List initialActions = workflow.getDescriptor().getInitialActions();
        for (ActionDescriptor action : initialActions) {
            if (action.getUnconditionalResult().getStep() != linkedStep.getId()) continue;
            return ServiceOutcomeImpl.ok(Boolean.TRUE);
        }
        return ServiceOutcomeImpl.ok(Boolean.FALSE);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Scheme> getWorkflowSchemeForProject(Project project) {
        Scheme scheme = this.workflowSchemeManager.getSchemeFor(project);
        return ServiceOutcomeImpl.ok(scheme);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Collection<JiraWorkflow>> getWorkflowsForProject(Project project) {
        try {
            AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(project);
            return ServiceOutcomeImpl.ok(this.getWorkflowsFromWorkflowScheme((WorkflowScheme)workflowScheme));
        }
        catch (DataAccessException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.workflow.scheme.error.not.found.for.project", project.getKey());
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<JiraWorkflow> copyWorkflow(ApplicationUser user, @Nonnull JiraWorkflow workflow, @Nonnull String newName, @Nonnull String newDescription) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        this.jiraWorkflowService.validateCopyWorkflow((JiraServiceContext)context, newName);
        if (context.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(context.getErrorCollection());
        }
        JiraWorkflow clonedWorkflow = this.jiraWorkflowService.copyWorkflow((JiraServiceContext)context, newName, newDescription, workflow);
        if (context.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(context.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(clonedWorkflow);
    }

    @Override
    @Nonnull
    public ServiceOutcome<JiraWorkflow> getWorkflow(ApplicationUser user, @Nonnull String workflowName) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        JiraWorkflow workflow = this.jiraWorkflowService.getWorkflow((JiraServiceContext)context, workflowName);
        if (Objects.isNull(workflow)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.config.workflow.status.error.noview", new Object[0]);
        }
        return WorkflowServiceImpl.convertContextToOutcome((JiraServiceContext)context, workflow);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Boolean> doesWorkflowSchemeExist(String name) {
        try {
            return ServiceOutcomeImpl.ok(this.workflowSchemeManager.schemeExists(name));
        }
        catch (GenericEntityException e) {
            this.logger.error("Error when trying to check if workflow scheme with name '%s' exists: %s", name, e.getMessage());
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.workflow.scheme.error.not.found", name);
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<Boolean> isWorkflowSchemeActive(String name) {
        List associatedSchemes = this.workflowSchemeManager.getAssociatedSchemes(false);
        for (Scheme scheme : associatedSchemes) {
            if (!scheme.getName().equals(name)) continue;
            return ServiceOutcomeImpl.ok(true);
        }
        return ServiceOutcomeImpl.ok(false);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> deleteScheme(String name) {
        Scheme scheme = this.workflowSchemeManager.getSchemeObject(name);
        if (scheme == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.scheme.error.not.found", name);
        }
        try {
            this.workflowSchemeManager.deleteScheme(scheme.getId());
            return ServiceOutcomeImpl.ok();
        }
        catch (GenericEntityException e) {
            this.logger.error("Could not delete scheme '%s': %s", name, e.getMessage());
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.workflow.scheme.error.could.not.delete", name);
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> deleteWorkflow(String name) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(name);
        if (workflow == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.error.not.found", name);
        }
        try {
            this.workflowManager.deleteWorkflow(workflow);
        }
        catch (WorkflowException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, e.getMessage(), new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public Collection<JiraWorkflow> getJiraWorkflows(Project projectObj) {
        return this.getJiraWorkflows(projectObj, null);
    }

    @Override
    @Nonnull
    public Collection<JiraWorkflow> getJiraWorkflows(Project projectObj, String issueTypeId) {
        try {
            AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(projectObj);
            if (issueTypeId == null) {
                return this.getWorkflowsFromWorkflowScheme((WorkflowScheme)workflowScheme);
            }
            return Collections.singleton(this.workflowManager.getWorkflowFromScheme((WorkflowScheme)workflowScheme, issueTypeId));
        }
        catch (DataAccessException e) {
            this.logger.error("Tried to retrieve workflows for a project and got an error: %s", new Object[]{e});
            return Collections.emptySet();
        }
    }

    @Override
    @Nonnull
    public Set<JiraWorkflow> getJiraWorkflows(@Nonnull Set<Issue> issues) {
        Preconditions.checkNotNull(issues);
        HashSet<JiraWorkflow> workflows = new HashSet<JiraWorkflow>();
        HashSet<Pair> projIssueTypePairList = new HashSet<Pair>();
        for (Issue issue : issues) {
            Pair projIssueTypePair = Pair.of((Object)issue.getProjectId(), (Object)issue.getIssueTypeId());
            if (projIssueTypePairList.contains(projIssueTypePair)) continue;
            workflows.addAll(this.getJiraWorkflows(issue.getProjectObject(), issue.getIssueTypeId()));
            projIssueTypePairList.add(projIssueTypePair);
        }
        return workflows;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> associateWorkflowToSchemeAsDefault(String workflowName, Scheme scheme) {
        try {
            GenericValue schemeGv = this.workflowSchemeManager.getScheme(scheme.getId());
            this.workflowSchemeManager.addWorkflowToScheme(schemeGv, workflowName, "0");
            return ServiceOutcomeImpl.ok();
        }
        catch (GenericEntityException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Could not add workflow to scheme", new Object[0]);
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> associateSchemeToProject(Project project, Scheme scheme) {
        this.workflowSchemeManager.addSchemeToProject(project, scheme);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public ServiceOutcome<WorkflowService.WorkTransitions> getTransitions(ApplicationUser user, List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.project.error.id.not.specified", new Object[0]);
        }
        List<Long> distinctProjectIds = projectIds.stream().distinct().collect(Collectors.toList());
        if (!this.isNumberOfProjectsValid(distinctProjectIds)) {
            this.eventPublisher.publish((Object)new TooManyProjectsForGetTransitionAnalyticsEvent(distinctProjectIds.size()));
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.board.transition.too.many.projects", new Object[0]);
        }
        List projects = distinctProjectIds.stream().map(id -> this.projectManager.getProjectObj(id)).collect(Collectors.toList());
        if (projects.stream().anyMatch(Objects::isNull)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.config.workflow.transition.error.noview", new Object[0]);
        }
        for (Project project : projects) {
            if (this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)) continue;
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.config.workflow.transition.error.noview", new Object[0]);
        }
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            Map<Long, Map<String, String>> projectIdAndIssueTypeToWorkflow = projects.stream().collect(Collectors.toMap(Project::getId, this::getIssueTypeToWorkflowFromProject));
            Collection<WorkflowTransitionEntry> workflowToTransitions = this.getWorkflowTransitionEntries(projects, user);
            return new WorkTransitionsImpl(projectIdAndIssueTypeToWorkflow, workflowToTransitions);
        });
    }

    private int getMaxNumberOfProjects() {
        String maxNumberOfIssuesObject = this.applicationProperties.getDefaultBackedString("jira.agile.max.number.projects");
        return NumberUtils.toInt((String)maxNumberOfIssuesObject, (int)100);
    }

    private boolean isNumberOfProjectsValid(List<Long> projectIds) {
        int maxNumberOfProjects = this.getMaxNumberOfProjects();
        return projectIds.size() <= maxNumberOfProjects;
    }

    private Collection<WorkflowTransitionEntry> getWorkflowTransitionEntries(Collection<Project> projects, ApplicationUser user) {
        Set workflows = projects.stream().filter(project -> this.permissionManager.hasPermission(ProjectPermissions.TRANSITION_ISSUES, project, user)).map(this::getJiraWorkflows).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.transitionManager.getTransitions(workflows);
    }

    private Map<String, String> getIssueTypeToWorkflowFromProject(Project project) {
        return project.getIssueTypes().stream().map(IssueConstant::getId).collect(Collectors.toMap(Function.identity(), issueType -> ((JiraWorkflow)Iterables.getOnlyElement(this.getJiraWorkflows(project, (String)issueType))).getName()));
    }

    private Collection<JiraWorkflow> getWorkflowsFromWorkflowScheme(@Nonnull WorkflowScheme workflowScheme) {
        Set result = this.workflowManager.getWorkflowsFromScheme(this.workflowSchemeManager.getSchemeObject(workflowScheme.getId()));
        if (result == null) {
            result = Collections.emptySet();
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(result, (Predicate)Predicates.notNull()));
    }

    private static <T> ServiceOutcome<T> createNoLinkedStepError(JiraWorkflow workflow, Status status) {
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.status.error.no.linked.step", status.getNameTranslation(), workflow.getName());
    }

    private static <T> ServiceOutcome<T> convertContextToOutcome(JiraServiceContext context, T result) {
        if (context.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(context.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(result);
    }

    class WorkTransitionsImpl
    implements WorkflowService.WorkTransitions {
        private Map<Long, Map<String, String>> projectAndIssueTypeToWorkflow;
        private Collection<WorkflowTransitionEntry> workflowTransitionEntries;

        public WorkTransitionsImpl(Map<Long, Map<String, String>> projectAndIssueTypeToWorkflow, Collection<WorkflowTransitionEntry> workflowTransitionEntries) {
            this.projectAndIssueTypeToWorkflow = projectAndIssueTypeToWorkflow;
            this.workflowTransitionEntries = workflowTransitionEntries;
        }

        @Override
        public Map<Long, Map<String, String>> getProjectAndIssueTypeToWorkflow() {
            return this.projectAndIssueTypeToWorkflow;
        }

        @Override
        public Collection<WorkflowTransitionEntry> getWorkflowTransitionEntries() {
            return this.workflowTransitionEntries;
        }
    }
}

