/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.workflow;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.transition.WorkflowTransitionEntry;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public interface WorkflowService {
    public static final String SERVICE = "gh-workflowService";
    public static final String MAX_NUMBER_OF_PROJECTS = "jira.agile.max.number.projects";
    public static final int DEFAULT_MAX_NUMBER_OF_PROJECTS = 100;

    public Set<Status> getAllWorkflowStatusObjects();

    public Set<Status> getAllActiveWorkflowStatusObjects();

    public Status getWorkflowStatusObject(String var1);

    public Status getStatusByName(String var1);

    @Nonnull
    public Set<Status> getAccessibleStatuses(ApplicationUser var1, Query var2);

    @Nonnull
    public ServiceOutcome<Boolean> isStatusInitialStatus(@Nonnull JiraWorkflow var1, @Nonnull Status var2);

    @Nonnull
    public ServiceOutcome<JiraWorkflow> copyWorkflow(ApplicationUser var1, @Nonnull JiraWorkflow var2, @Nonnull String var3, @Nonnull String var4);

    @Nonnull
    public ServiceOutcome<JiraWorkflow> getWorkflow(ApplicationUser var1, @Nonnull String var2);

    @Nonnull
    public ServiceOutcome<Collection<JiraWorkflow>> getWorkflowsForProject(Project var1);

    @Nonnull
    public ServiceOutcome<Boolean> doesWorkflowSchemeExist(String var1);

    @Nonnull
    public ServiceOutcome<Scheme> getWorkflowSchemeForProject(Project var1);

    @Nonnull
    public ServiceOutcome<Boolean> isWorkflowSchemeActive(String var1);

    @Nonnull
    public ServiceOutcome<Void> deleteScheme(String var1);

    @Nonnull
    public ServiceOutcome<Void> deleteWorkflow(String var1);

    @Nonnull
    public Collection<JiraWorkflow> getJiraWorkflows(Project var1);

    @Nonnull
    public Collection<JiraWorkflow> getJiraWorkflows(Project var1, String var2);

    @Nonnull
    public Set<JiraWorkflow> getJiraWorkflows(@Nonnull Set<Issue> var1);

    @Nonnull
    public ServiceOutcome<Void> associateWorkflowToSchemeAsDefault(String var1, Scheme var2);

    @Nonnull
    public ServiceOutcome<Void> associateSchemeToProject(Project var1, Scheme var2);

    @Nonnull
    public ServiceOutcome<WorkTransitions> getTransitions(ApplicationUser var1, List<Long> var2);

    public static interface WorkTransitions {
        public Map<Long, Map<String, String>> getProjectAndIssueTypeToWorkflow();

        public Collection<WorkflowTransitionEntry> getWorkflowTransitionEntries();
    }
}

