/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.workflow;

import com.atlassian.greenhopper.service.issue.field.IssueStatusService;
import com.atlassian.greenhopper.service.workflow.WorkflowConstantsService;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowConstantsServiceImpl
implements WorkflowConstantsService {
    @Autowired
    private StatusManager statusManager;
    @Autowired
    private ResolutionManager resolutionManager;
    @Autowired
    private IssueStatusService issueStatusService;

    @Override
    @Nonnull
    @Deprecated
    public Status getOrCreateStatus(String name, String description) {
        return this.getOrCreateStatus(name, description, 1L);
    }

    @Override
    @Nonnull
    public Status getOrCreateStatus(String name, String description, @Nonnull Long statusCategoryId) {
        Status status = this.getStatusByName(name);
        if (status == null) {
            status = this.issueStatusService.createStatus(name, description, statusCategoryId);
        }
        return status;
    }

    @Override
    @Nonnull
    public Resolution getOrCreateResolution(String name) {
        Resolution resolution = this.getResolutionByName(name);
        if (resolution == null) {
            resolution = this.resolutionManager.createResolution(name, "GreenHopper Managed Resolution");
        }
        return resolution;
    }

    private Status getStatusByName(String name) {
        Collection statuses = this.statusManager.getStatuses();
        for (Status status : statuses) {
            if (!status.getName().equalsIgnoreCase(name)) continue;
            return status;
        }
        return null;
    }

    private Resolution getResolutionByName(String name) {
        return this.resolutionManager.getResolutionByName(name);
    }
}

