/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.workflow;

import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import io.atlassian.util.concurrent.LazyReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SimplifiedWorkflowStringsFactory {
    @Autowired
    private JiraForSoftwareChecker jiraForSoftwareChecker;
    private LazyReference<SimplifiedWorkflowStrings> helper = new LazyReference<SimplifiedWorkflowStrings>(){

        @Override
        protected SimplifiedWorkflowStrings create() {
            if (!SimplifiedWorkflowStringsFactory.this.jiraForSoftwareChecker.isJiraForSoftwareSupported()) {
                return new SimplifiedWorkflowStrings("Managed by JIRA Agile", "Agile Simplified Workflow for Project %s", "Generated by JIRA Agile version", "Agile Simplified Workflow Scheme for Project %s", "%s: Agile Simplified Workflow Scheme", "gh.workflow.simple.workflow.desc", "gh.workflow.simple.workflow.scheme.desc", "Done");
            }
            return new SimplifiedWorkflowStrings("Managed by JIRA Software", "Software Simplified Workflow for Project %s", "Generated by JIRA Software version", "Software Simplified Workflow Scheme for Project %s", "%s: Software Simplified Workflow Scheme", "gh.workflow.simple.workflow.desc", "gh.workflow.simple.workflow.scheme.desc", "Done");
        }
    };

    public SimplifiedWorkflowStrings getSimplifiedWorkflowBrandedStrings() {
        return this.helper.get();
    }

    public static class SimplifiedWorkflowStrings {
        private final String managedByDescription;
        private final String simplifiedWorkflowNameFormat;
        private final String simplifiedWorkflowDescriptionPrefix;
        private final String simplifiedWorkflowSchemeNameV2Format;
        private final String simplifiedWorkflowSchemeNameV3Format;
        private final String workflowSimpleWorkflowDesc;
        private final String workflowSimpleWorkflowSchemeDesc;
        private final String resolutionDone;

        public SimplifiedWorkflowStrings(String managedByDescription, String simplifiedWorkflowNameFormat, String simplifiedWorkflowDescriptionPrefix, String simplifiedWorkflowSchemeNameV2Format, String simplifiedWorkflowSchemeNameV3Format, String workflowSimpleWorkflowDesc, String workflowSimpleWorkflowSchemeDesc, String resolutionDone) {
            this.managedByDescription = managedByDescription;
            this.simplifiedWorkflowNameFormat = simplifiedWorkflowNameFormat;
            this.simplifiedWorkflowDescriptionPrefix = simplifiedWorkflowDescriptionPrefix;
            this.simplifiedWorkflowSchemeNameV2Format = simplifiedWorkflowSchemeNameV2Format;
            this.simplifiedWorkflowSchemeNameV3Format = simplifiedWorkflowSchemeNameV3Format;
            this.workflowSimpleWorkflowDesc = workflowSimpleWorkflowDesc;
            this.workflowSimpleWorkflowSchemeDesc = workflowSimpleWorkflowSchemeDesc;
            this.resolutionDone = resolutionDone;
        }

        public String getManagedByDescription() {
            return this.managedByDescription;
        }

        public String getSimplifiedWorkflowNameFormat() {
            return this.simplifiedWorkflowNameFormat;
        }

        public String getSimplifiedWorkflowNamePrefix() {
            return String.format(this.simplifiedWorkflowNameFormat, "");
        }

        public String getSimplifiedWorkflowDescriptionPrefix() {
            return this.simplifiedWorkflowDescriptionPrefix;
        }

        public String getSimplifiedWorkflowDescriptionFormat() {
            return this.simplifiedWorkflowDescriptionPrefix + " %s. %s";
        }

        public String getSimplifiedWorkflowSchemeNameV2Format() {
            return this.simplifiedWorkflowSchemeNameV2Format;
        }

        public String getSimplifiedWorkflowSchemeNameV2Prefix() {
            return String.format(this.simplifiedWorkflowSchemeNameV2Format, "");
        }

        public String getSimplifiedWorkflowSchemeNameV3Format() {
            return this.simplifiedWorkflowSchemeNameV3Format;
        }

        public String getSimplifiedWorkflowSchemeNameV3Suffix() {
            return String.format(this.simplifiedWorkflowSchemeNameV3Format, "");
        }

        public String getWorkflowSimpleWorkflowDescription() {
            return this.workflowSimpleWorkflowDesc;
        }

        public String getWorkflowSimpleWorkflowSchemeDescription() {
            return this.workflowSimpleWorkflowSchemeDesc;
        }

        public String getResolutionDone() {
            return this.resolutionDone;
        }
    }
}

