/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.workflow;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.workflow.CheckWorkflowEntitiesByNameResult;
import com.atlassian.greenhopper.service.workflow.ColumnConstraintPresets;
import com.atlassian.greenhopper.service.workflow.PredefinedStatuses;
import com.atlassian.greenhopper.service.workflow.PresetData;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowPresets;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowService;
import com.atlassian.greenhopper.service.workflow.SimplifiedWorkflowStringsFactory;
import com.atlassian.greenhopper.service.workflow.WorkflowConstantsService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.util.BuildProperties;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SimplifiedWorkflowServiceImpl
implements SimplifiedWorkflowService {
    public static final int JIRA_5_0_4_BUILD_NUMBER = 731;
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String UPDATE_ISSUE_FIELD_FUNCTION_PLUGIN_KEY = "com.atlassian.jira.plugin.system.workflow:update-issue-field-function";
    private BuildUtilsInfo buildUtilsInfo;
    private SearchService jiraSearchService;
    private StatusManager statusManager;
    private ProjectManager projectManager;
    private PluginAccessor pluginAccessor;
    private WorkflowManager workflowManager;
    private WorkflowSchemeManager workflowSchemeManager;
    private WorkflowService workflowService;
    private I18nFactoryService i18nFactoryService;
    private WorkflowConstantsService workflowConstantsService;
    private BuildProperties buildProperties;
    private SimplifiedWorkflowStringsFactory.SimplifiedWorkflowStrings simplifiedWorkflowStrings;
    private Map<SimplifiedWorkflowPresets, PresetData> presetData;
    private ModuleDescriptorFactory moduleDescriptorFactory;

    @Autowired
    public SimplifiedWorkflowServiceImpl(BuildUtilsInfo buildUtilsInfo, SearchService jiraSearchService, StatusManager statusManager, ProjectManager projectManager, PluginAccessor pluginAccessor, WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager, WorkflowService workflowService, I18nFactoryService i18nFactoryService, WorkflowConstantsService workflowConstantsService, BuildProperties buildProperties, SimplifiedWorkflowStringsFactory simplifiedWorkflowStringsFactory, @Qualifier(value="moduleDescriptorFactory") ModuleDescriptorFactory moduleDescriptorFactory) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.jiraSearchService = jiraSearchService;
        this.statusManager = statusManager;
        this.projectManager = projectManager;
        this.pluginAccessor = pluginAccessor;
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowService = workflowService;
        this.i18nFactoryService = i18nFactoryService;
        this.workflowConstantsService = workflowConstantsService;
        this.buildProperties = buildProperties;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.simplifiedWorkflowStrings = simplifiedWorkflowStringsFactory.getSimplifiedWorkflowBrandedStrings();
        this.presetData = this.createPresets();
    }

    @Override
    public boolean isFeatureEnabled() {
        return this.buildUtilsInfo.getApplicationBuildNumber() >= 731;
    }

    @Override
    public ServiceOutcome<Pair<JiraWorkflow, Project>> getGreenHopperSimplifiedWorkflow(ApplicationUser user, Query query) {
        ServiceOutcome<Pair<JiraWorkflow, Project>> potentialWorkflowAndProject = this.getPotentialWorkflowForConversion(user, query);
        if (!potentialWorkflowAndProject.isValid()) {
            return ServiceOutcomeImpl.error(potentialWorkflowAndProject);
        }
        JiraWorkflow workflow = (JiraWorkflow)potentialWorkflowAndProject.getValue().first();
        Project project = (Project)potentialWorkflowAndProject.getValue().second();
        if ("jira".equals(workflow.getName())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.not.default.jira", new Object[0]);
        }
        Collection schemesForWorkflow = this.workflowSchemeManager.getSchemesForWorkflow(workflow);
        for (GenericValue schemeGv : schemesForWorkflow) {
            Long schemeId = schemeGv.getLong("id");
            Scheme workflowScheme = this.workflowSchemeManager.getSchemeObject(schemeId);
            List projects = this.workflowSchemeManager.getProjects(workflowScheme);
            if (projects.size() > 1) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.exactly.one.project", new Object[0]);
            }
            if (projects.isEmpty()) continue;
            Project p = (Project)projects.iterator().next();
            if (project.getId().equals(p.getId())) continue;
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.exactly.one.project", new Object[0]);
        }
        ServiceOutcome<Void> globalForAllSteps = this.doesEachStepHaveGlobalTransition(workflow);
        if (!globalForAllSteps.isValid()) {
            return ServiceOutcomeImpl.error(globalForAllSteps);
        }
        ServiceOutcome<Void> correctlyNamed = this.doesWorkflowFollowSimplifiedWorkflowNamingScheme(workflow);
        if (!correctlyNamed.isValid()) {
            return ServiceOutcomeImpl.error(correctlyNamed);
        }
        return ServiceOutcomeImpl.ok(Pair.of((Object)workflow, (Object)project));
    }

    @Override
    public ServiceOutcome<Pair<JiraWorkflow, Project>> getPotentialWorkflowForConversion(ApplicationUser user, Query query) {
        QueryContext queryContext = this.jiraSearchService.getQueryContext(user, query);
        Collection projectIssueTypeContexts = queryContext.getProjectIssueTypeContexts();
        boolean globalContext = false;
        HashSet<Long> projectIds = new HashSet<Long>();
        this.log.debug("Query Context for query '%s' - %s", query, queryContext);
        for (QueryContext.ProjectIssueTypeContexts projectIssueTypeContext : projectIssueTypeContexts) {
            ProjectContext projectContext = projectIssueTypeContext.getProjectContext();
            if (projectContext.isAll()) {
                globalContext = true;
                break;
            }
            projectIds.add(projectContext.getProjectId());
        }
        if (globalContext) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.potential.error.query.exactly.one.project", new Object[0]);
        }
        if (projectIds.size() != 1) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.potential.error.query.exactly.one.project", new Object[0]);
        }
        Long projectId = (Long)projectIds.iterator().next();
        Project project = this.projectManager.getProjectObj(projectId);
        Collection<JiraWorkflow> jiraWorkflows = this.workflowService.getJiraWorkflows(project);
        if (jiraWorkflows.size() != 1) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.potential.error.project.one.workflow", project.getName());
        }
        JiraWorkflow workflow = jiraWorkflows.iterator().next();
        return ServiceOutcomeImpl.ok(Pair.of((Object)workflow, (Object)project));
    }

    @Override
    public ServiceOutcome<Status> canStatusBeRemovedFromGreenHopperSimplifiedWorkflow(JiraWorkflow workflow, String statusId) {
        ServiceOutcome<Status> statusOutcome = this.isStatusInWorkflow(workflow, statusId);
        if (!statusOutcome.isValid()) {
            return ServiceOutcomeImpl.error(statusOutcome);
        }
        Status status = statusOutcome.getValue();
        StepDescriptor linkedStep = workflow.getLinkedStep(status);
        ActionDescriptor globalActionForStep = this.findGlobalActionForStep(workflow, linkedStep);
        if (globalActionForStep == null) {
            return SimplifiedWorkflowServiceImpl.createStatusCannotBeRemovedError(status);
        }
        return statusOutcome;
    }

    @Override
    public ServiceOutcome<JiraWorkflow> replaceInitialStatusInGreenHopperSimplifiedWorkflow(ApplicationUser user, @Nonnull JiraWorkflow workflow, @Nonnull Status oldInitialStatus, @Nonnull Status newInitialStatus) {
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor oldInitialStep = mutable.getLinkedStep(oldInitialStatus);
        if (oldInitialStep == null) {
            return SimplifiedWorkflowServiceImpl.createNoLinkedStepError(mutable, oldInitialStatus);
        }
        StepDescriptor newInitialStep = mutable.getLinkedStep(newInitialStatus);
        if (newInitialStep == null) {
            return SimplifiedWorkflowServiceImpl.createNoLinkedStepError(mutable, newInitialStatus);
        }
        Set<Integer> initialActionsToChange = this.findAllActionsWithTargetStep(oldInitialStep, mutable.getDescriptor().getInitialActions());
        for (Integer actionId : initialActionsToChange) {
            ActionDescriptor action = mutable.getDescriptor().getAction(actionId.intValue());
            this.replaceTargetStep(oldInitialStep, newInitialStep, action);
        }
        this.saveMutableWorkflow(mutable);
        return this.workflowService.getWorkflow(user, mutable.getName());
    }

    @Override
    public ServiceOutcome<Void> addStatusToGreenHopperSimplifiedWorkflow(ApplicationUser user, JiraWorkflow workflow, Status status) {
        ServiceOutcome<Status> statusInGreenHopperManagedWorkflow = this.isStatusInWorkflow(workflow, status.getId());
        if (statusInGreenHopperManagedWorkflow.isValid()) {
            return ServiceOutcomeImpl.ok();
        }
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        ServiceOutcome<StepDescriptor> newStep = this.addStep(mutable, status);
        if (!newStep.isValid()) {
            return ServiceOutcomeImpl.error(newStep);
        }
        ServiceOutcome<Void> globalTransition = this.addGlobalTransition(mutable, status.getName(), this.simplifiedWorkflowStrings.getManagedByDescription(), newStep.getValue().getId(), false);
        if (!globalTransition.isValid()) {
            return ServiceOutcomeImpl.error(globalTransition);
        }
        this.saveMutableWorkflow(mutable);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> removeStatusFromGreenHopperSimplifiedWorkflow(ApplicationUser user, JiraWorkflow workflow, Status status) {
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor linkedStep = mutable.getLinkedStep(status);
        if (linkedStep == null) {
            return SimplifiedWorkflowServiceImpl.createStatusCannotBeRemovedError(status);
        }
        ServiceOutcome<Void> remove = this.removeAllActionsForStep(mutable, status, linkedStep);
        if (!remove.isValid()) {
            return ServiceOutcomeImpl.error(remove);
        }
        mutable.removeStep(linkedStep);
        this.saveMutableWorkflow(mutable);
        this.removeStatusFromSystemIfPossible(status);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<JiraWorkflow> convertTransitionsToSimplified(ApplicationUser user, JiraWorkflow mutable, List<Status> resolutionDoneStatuses) {
        this.removeAllActionsFromWorkflow(mutable);
        List steps = mutable.getDescriptor().getSteps();
        for (StepDescriptor step : steps) {
            boolean updateResolutionToDone = this.willStepUpdateResolutionToDone(step, resolutionDoneStatuses);
            ServiceOutcome<Void> addOutcome = this.addGlobalTransition(mutable, step.getName(), this.simplifiedWorkflowStrings.getManagedByDescription(), step.getId(), updateResolutionToDone);
            if (addOutcome.isValid()) continue;
            return ServiceOutcomeImpl.error(addOutcome);
        }
        this.saveMutableWorkflow(mutable);
        return this.workflowService.getWorkflow(user, mutable.getName());
    }

    private boolean willStepUpdateResolutionToDone(StepDescriptor step, List<Status> resolutionDoneStatuses) {
        String stepStatusId = (String)step.getMetaAttributes().get("jira.status.id");
        for (Status status : resolutionDoneStatuses) {
            if (!status.getId().equals(stepStatusId)) continue;
            return true;
        }
        return false;
    }

    private Map<SimplifiedWorkflowPresets, PresetData> createPresets() {
        return ImmutableMap.builder().put((Object)SimplifiedWorkflowPresets.SIMPLIFIED_WORKFLOW, (Object)PresetData.builder().workflowPath("/templates/greenhopper/jira/workflow/GreenHopperLite.xml").statusNames(PredefinedStatuses.TO_DO, PredefinedStatuses.IN_PROGRESS, PredefinedStatuses.DONE).columnConstraint(ColumnConstraintPresets.NONE).resolutionNames(this.simplifiedWorkflowStrings.getResolutionDone()).build()).put((Object)SimplifiedWorkflowPresets.KANBAN_SIMPLIFIED_WORKFLOW, (Object)PresetData.builder().workflowPath("/templates/greenhopper/jira/workflow/GreenHopperKanban.xml").statusNames(PredefinedStatuses.BACKLOG, PredefinedStatuses.SELECTED_FOR_DEVELOPMENT, PredefinedStatuses.IN_PROGRESS, PredefinedStatuses.DONE).columnConstraint(ColumnConstraintPresets.NONE).resolutionNames(this.simplifiedWorkflowStrings.getResolutionDone()).build()).put((Object)SimplifiedWorkflowPresets.KANBAN_SIMPLIFIED_SAMPLE_WORKFLOW, (Object)PresetData.builder().workflowPath("/templates/greenhopper/jira/workflow/GreenHopperKanban.xml").statusNames(PredefinedStatuses.BACKLOG, PredefinedStatuses.SELECTED_FOR_DEVELOPMENT, PredefinedStatuses.IN_PROGRESS, PredefinedStatuses.DONE).columnConstraint(ColumnConstraintPresets.SAMPLE_KANBAN).resolutionNames(this.simplifiedWorkflowStrings.getResolutionDone()).build()).put((Object)SimplifiedWorkflowPresets.BASIC_SOFTWARE_WORKFLOW, (Object)PresetData.builder().workflowPath("/templates/greenhopper/jira/workflow/BasicSoftwareDevelopment.xml").statusNames(PredefinedStatuses.TO_DO, PredefinedStatuses.IN_PROGRESS, PredefinedStatuses.IN_REVIEW, PredefinedStatuses.DONE).columnConstraint(ColumnConstraintPresets.NONE).resolutionNames(this.simplifiedWorkflowStrings.getResolutionDone()).build()).build();
    }

    @Override
    public Map<SimplifiedWorkflowPresets, PresetData> getPresetDefinitions() {
        return this.presetData;
    }

    @Override
    public ServiceOutcome<CheckWorkflowEntitiesByNameResult> checkForSimplifiedWorkflowNamedAfterProject(String projectKey) {
        ServiceOutcome<Boolean> schemeOutcome;
        String workflowName = this.createWorkflowNameFromProject(projectKey);
        String workflowSchemeName = this.createSchemeNameFromProject(projectKey);
        boolean workflowExists = this.workflowManager.workflowExists(workflowName);
        boolean workflowActive = false;
        if (workflowExists) {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
            workflowActive = this.workflowManager.isActive(workflow);
        }
        if (!(schemeOutcome = this.workflowService.doesWorkflowSchemeExist(workflowSchemeName)).isValid()) {
            return ServiceOutcomeImpl.error(schemeOutcome);
        }
        boolean workflowSchemeExists = schemeOutcome.getValue();
        boolean workflowSchemeActive = false;
        if (workflowSchemeExists) {
            ServiceOutcome<Boolean> schemeActive = this.workflowService.isWorkflowSchemeActive(workflowSchemeName);
            if (!schemeActive.isValid()) {
                return ServiceOutcomeImpl.error(schemeActive);
            }
            workflowSchemeActive = schemeActive.getValue();
        }
        return ServiceOutcomeImpl.ok(new CheckWorkflowEntitiesByNameResult(workflowName, workflowSchemeName, workflowExists, workflowActive, workflowSchemeExists, workflowSchemeActive));
    }

    @Override
    public ServiceOutcome<Pair<JiraWorkflow, Scheme>> createSimplifiedWorkflowForNewProject(ApplicationUser user, String projectKey, SimplifiedWorkflowPresets preset) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        PresetData data = PresetData.builder(this.presetData.get((Object)preset)).workflowName(this.createWorkflowNameFromProject(projectKey)).workflowDescription(this.createWorkflowDescription(i18n)).schemeName(this.createSchemeNameFromProject(projectKey)).schemeDescription(this.createSchemeDescription(i18n)).build();
        return this.createWorkflowAndScheme(user, data);
    }

    @Override
    public ServiceOutcome<Void> createSimplifiedWorkflowForNewProject(ApplicationUser user, Project project, SimplifiedWorkflowPresets preset) {
        ServiceOutcome<Pair<JiraWorkflow, Scheme>> workflowAndScheme = this.createSimplifiedWorkflowForNewProject(user, project.getKey(), preset);
        if (!workflowAndScheme.isValid()) {
            return ServiceOutcomeImpl.error(workflowAndScheme);
        }
        this.workflowService.associateSchemeToProject(project, (Scheme)workflowAndScheme.getValue().second());
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Scheme> createSimplifiedWorkflowForExistingProject(ApplicationUser user, Project project, List<Status> resolutionDoneStatuses) {
        String workflowSchemeDesc;
        String workflowDesc;
        String workflowName;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<Collection<JiraWorkflow>> workflowsOutcome = this.workflowService.getWorkflowsForProject(project);
        if (!workflowsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(workflowsOutcome);
        }
        Collection<JiraWorkflow> workflows = workflowsOutcome.getValue();
        if (workflows.size() > 1) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.convert.workflow.error.more.than.one.workflow", project.getName());
        }
        if (workflows.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.convert.workflow.error.no.workflows", project.getName());
        }
        ServiceOutcome<CheckWorkflowEntitiesByNameResult> nameCheckOutcome = this.checkForSimplifiedWorkflowNamedAfterProject(project.getKey());
        if (!nameCheckOutcome.isValid()) {
            return ServiceOutcomeImpl.error(nameCheckOutcome);
        }
        CheckWorkflowEntitiesByNameResult nameCheck = nameCheckOutcome.getValue();
        ServiceOutcome<Void> deleteOutcome = this.deleteExistingNamedEntitiesIfNecessary(nameCheck, i18n, project);
        if (!deleteOutcome.isValid()) {
            return ServiceOutcomeImpl.error(deleteOutcome);
        }
        JiraWorkflow originalWorkflow = workflows.iterator().next();
        ServiceOutcome<JiraWorkflow> copyWorkflowOutcome = this.workflowService.copyWorkflow(user, originalWorkflow, workflowName = this.createWorkflowNameFromProject(project.getKey()), workflowDesc = this.createWorkflowDescription(i18n));
        if (!copyWorkflowOutcome.isValid()) {
            return ServiceOutcomeImpl.error(copyWorkflowOutcome);
        }
        JiraWorkflow copiedWorkflow = copyWorkflowOutcome.getValue();
        this.setGhVersionMetaAttribute(copiedWorkflow.getDescriptor());
        ServiceOutcome<JiraWorkflow> convertTransitionsOutcome = this.convertTransitionsToSimplified(user, copiedWorkflow, resolutionDoneStatuses);
        if (!convertTransitionsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(convertTransitionsOutcome);
        }
        String workflowSchemeName = this.createSchemeNameFromProject(project.getKey());
        ServiceOutcome<Scheme> workflowScheme = this.createWorkflowScheme(workflowSchemeName, workflowSchemeDesc = this.createSchemeDescription(i18n));
        if (!workflowScheme.isValid()) {
            return ServiceOutcomeImpl.error(workflowScheme);
        }
        Scheme newScheme = workflowScheme.getValue();
        ServiceOutcome<Void> associateOutcome = this.workflowService.associateWorkflowToSchemeAsDefault(convertTransitionsOutcome.getValue().getName(), newScheme);
        if (!associateOutcome.isValid()) {
            return ServiceOutcomeImpl.error(associateOutcome);
        }
        return ServiceOutcomeImpl.ok(newScheme);
    }

    @Override
    public ServiceOutcome<Boolean> isStatusResolutionDone(ApplicationUser user, @Nonnull JiraWorkflow workflow, @Nonnull Status status) {
        StepDescriptor stepDescriptor = workflow.getLinkedStep(status);
        if (stepDescriptor == null) {
            return ServiceOutcomeImpl.ok(false);
        }
        Resolution resolution = this.workflowConstantsService.getOrCreateResolution(this.simplifiedWorkflowStrings.getResolutionDone());
        Collection actionDescriptors = workflow.getActionsWithResult(stepDescriptor);
        for (ActionDescriptor actionDescriptor : actionDescriptors) {
            FunctionDescriptor resolutionFunction = this.getResolutionUpdateFunction(workflow, actionDescriptor);
            if (resolutionFunction == null) continue;
            String resolutionId = (String)resolutionFunction.getArgs().get("field.value");
            return ServiceOutcomeImpl.ok(resolution.getId().equals(resolutionId));
        }
        return ServiceOutcomeImpl.ok(false);
    }

    @Override
    public ServiceOutcome<Void> setStatusResolutionDone(ApplicationUser user, @Nonnull JiraWorkflow workflow, @Nonnull Status status, boolean done) {
        JiraWorkflow mutable = this.getMutableWorkflow(workflow);
        StepDescriptor stepDescriptor = mutable.getLinkedStep(status);
        if (stepDescriptor == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "", new Object[0]);
        }
        Resolution resolution = this.workflowConstantsService.getOrCreateResolution(this.simplifiedWorkflowStrings.getResolutionDone());
        Collection actionDescriptors = mutable.getActionsWithResult(stepDescriptor);
        for (ActionDescriptor actionDescriptor : actionDescriptors) {
            FunctionDescriptor resolutionFunction = this.getResolutionUpdateFunction(workflow, actionDescriptor);
            if (resolutionFunction == null) continue;
            String newResolutionId = done ? resolution.getId() : "";
            resolutionFunction.getArgs().put("field.value", newResolutionId);
        }
        this.saveMutableWorkflow(mutable);
        return ServiceOutcomeImpl.ok();
    }

    private FunctionDescriptor getResolutionUpdateFunction(JiraWorkflow workflow, ActionDescriptor actionDescriptor) {
        AbstractWorkflowModuleDescriptor pluginModule = this.getUpdateIssueFieldFunctionModule();
        String implementationClassName = pluginModule.getImplementationClass().getName();
        Collection postFunctions = workflow.getPostFunctionsForTransition(actionDescriptor);
        for (FunctionDescriptor functionDescriptor : postFunctions) {
            String fieldName;
            String className = (String)functionDescriptor.getArgs().get("class.name");
            if (className != null) {
                className = className.trim();
            }
            if ((fieldName = (String)functionDescriptor.getArgs().get("field.name")) != null) {
                fieldName = fieldName.trim();
            }
            if (!functionDescriptor.getType().equals("class") || !implementationClassName.equals(className) || !"resolution".equals(fieldName)) continue;
            return functionDescriptor;
        }
        return null;
    }

    @Nonnull
    private synchronized ServiceOutcome<Pair<JiraWorkflow, Scheme>> createWorkflowAndScheme(ApplicationUser user, PresetData data) {
        ServiceOutcome<JiraWorkflow> workflow = this.createWorkflow(user, data);
        if (!workflow.isValid()) {
            return ServiceOutcomeImpl.from(workflow.getErrors());
        }
        ServiceOutcome<Scheme> defaultGHWorkflowScheme = this.createWorkflowScheme(data.getSchemeName(), data.getSchemeDescription());
        if (!defaultGHWorkflowScheme.isValid()) {
            return ServiceOutcomeImpl.from(defaultGHWorkflowScheme.getErrors());
        }
        ServiceOutcome<Void> associateOutcome = this.workflowService.associateWorkflowToSchemeAsDefault(data.getWorkflowName(), defaultGHWorkflowScheme.getValue());
        if (!associateOutcome.isValid()) {
            return ServiceOutcomeImpl.error(associateOutcome);
        }
        return ServiceOutcomeImpl.ok(Pair.of((Object)workflow.getValue(), (Object)defaultGHWorkflowScheme.getValue()));
    }

    @Nonnull
    private ServiceOutcome<Scheme> createWorkflowScheme(String schemeName, String schemeDescription) {
        Scheme workflowScheme = this.workflowSchemeManager.getSchemeObject(schemeName);
        if (workflowScheme != null) {
            return ServiceOutcomeImpl.ok(workflowScheme);
        }
        Scheme scheme = this.workflowSchemeManager.createSchemeObject(schemeName, schemeDescription);
        return ServiceOutcomeImpl.ok(scheme);
    }

    @Nonnull
    private ServiceOutcome<JiraWorkflow> createWorkflow(ApplicationUser user, PresetData data) {
        List<Status> statuses = this.getOrCreateStatuses(data.getStatusNames());
        List<Resolution> resolutions = this.getOrCreateResolutions(data.getResolutionNames());
        return this.createWorkflow(data.getWorkflowPath(), statuses, resolutions, data.getWorkflowName(), data.getWorkflowDescription(), user);
    }

    private List<Status> getOrCreateStatuses(List<PredefinedStatuses> statusEnums) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (PredefinedStatuses statusEnum : statusEnums) {
            Status status = this.workflowConstantsService.getOrCreateStatus(statusEnum.name, "", statusEnum.getStatusCategoryId());
            statuses.add(status);
        }
        return statuses;
    }

    private List<Resolution> getOrCreateResolutions(List<String> resolutionNames) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        for (String resolutionName : resolutionNames) {
            Resolution resolution = this.workflowConstantsService.getOrCreateResolution(resolutionName);
            resolutions.add(resolution);
        }
        return resolutions;
    }

    @Nonnull
    private ServiceOutcome<JiraWorkflow> createWorkflow(String workflowPath, Collection<Status> statuses, Collection<Resolution> resolutions, String workflowName, String workflowDescription, ApplicationUser user) {
        if (this.workflowManager.workflowExists(workflowName)) {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
            return ServiceOutcomeImpl.ok(workflow);
        }
        String workflowXML = this.getWorkflowDefinition(workflowPath, statuses, resolutions);
        WorkflowDescriptor workflowDescriptor = null;
        try {
            workflowDescriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)workflowXML);
        }
        catch (FactoryException fe) {
            this.log.exception(fe);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, fe.getMessage(), new Object[0]);
        }
        this.setGhVersionMetaAttribute(workflowDescriptor);
        ConfigurableJiraWorkflow workflow = new ConfigurableJiraWorkflow(workflowName, workflowDescriptor, this.workflowManager);
        workflow.setDescription(workflowDescription);
        try {
            this.workflowManager.createWorkflow(user, (JiraWorkflow)workflow);
        }
        catch (WorkflowException we) {
            this.log.exception(we);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, we.getMessage(), new Object[0]);
        }
        JiraWorkflow createdWorkflow = this.workflowManager.getWorkflow(workflowName);
        if (createdWorkflow == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Failed to create workflow.", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(createdWorkflow);
    }

    private void setGhVersionMetaAttribute(WorkflowDescriptor workflowDescriptor) {
        workflowDescriptor.getMetaAttributes().put("gh.version", this.buildProperties.getVersion());
    }

    private String getWorkflowDefinition(String workflowPath, Collection<Status> statuses, Collection<Resolution> resolutions) {
        try {
            String xml = IOUtil.toString((InputStream)this.getClass().getResourceAsStream(workflowPath));
            HashMap<String, String> replacements = new HashMap<String, String>();
            this.addStatusReplacements(statuses, replacements);
            this.addResolutionReplacements(resolutions, replacements);
            xml = this.replaceStatusIds(xml, replacements);
            return xml;
        }
        catch (IOException ioe) {
            this.log.exception(ioe);
            return null;
        }
    }

    private ServiceOutcome<Void> deleteExistingNamedEntitiesIfNecessary(CheckWorkflowEntitiesByNameResult nameCheck, I18n2 i18n, Project project) {
        if (nameCheck.someActive()) {
            String entityKey = nameCheck.workflowActive() ? "gh.common.admin.workflow" : "gh.common.admin.workflow.scheme";
            String entityName = nameCheck.workflowActive() ? nameCheck.getWorkflowName() : nameCheck.getWorkflowSchemeName();
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.project.name.conflict", i18n.getText(entityKey), entityName, project.getName());
        }
        if (nameCheck.existsButNotActive()) {
            ServiceOutcome<Void> deleteWorkflow;
            ServiceOutcome<Void> deleteScheme;
            if (nameCheck.workflowSchemeExists() && !(deleteScheme = this.workflowService.deleteScheme(nameCheck.getWorkflowSchemeName())).isValid()) {
                return ServiceOutcomeImpl.error(deleteScheme);
            }
            if (nameCheck.workflowExists() && !(deleteWorkflow = this.workflowService.deleteWorkflow(nameCheck.getWorkflowName())).isValid()) {
                return ServiceOutcomeImpl.error(deleteWorkflow);
            }
        }
        return ServiceOutcomeImpl.ok();
    }

    private void addStatusReplacements(Collection<Status> statuses, Map<String, String> replacements) {
        for (Status status : statuses) {
            String key = "{STATUS_" + status.getName().toUpperCase() + "}";
            String value = status.getId();
            replacements.put(key, value);
        }
    }

    private void addResolutionReplacements(Collection<Resolution> resolutions, Map<String, String> replacements) {
        for (Resolution resolution : resolutions) {
            String key = "{RESOLUTION_" + resolution.getName() + "}";
            String value = resolution.getId();
            replacements.put(key, value);
        }
    }

    private String replaceStatusIds(String xml, Map<String, String> replacements) {
        for (String key : replacements.keySet()) {
            String value = replacements.get(key);
            xml = xml.replace(key, value);
        }
        return xml;
    }

    private String createWorkflowDescription(I18n2 i18n) {
        return String.format(this.simplifiedWorkflowStrings.getSimplifiedWorkflowDescriptionFormat(), this.buildProperties.getVersion(), i18n.getText(this.simplifiedWorkflowStrings.getWorkflowSimpleWorkflowDescription()));
    }

    private String createSchemeDescription(I18n2 i18n) {
        return String.format(this.simplifiedWorkflowStrings.getSimplifiedWorkflowDescriptionFormat(), this.buildProperties.getVersion(), i18n.getText(this.simplifiedWorkflowStrings.getWorkflowSimpleWorkflowSchemeDescription()));
    }

    private String createWorkflowNameFromProject(String projectKey) {
        return String.format(this.simplifiedWorkflowStrings.getSimplifiedWorkflowNameFormat(), projectKey);
    }

    private String createSchemeNameFromProject(String projectKey) {
        return String.format(this.simplifiedWorkflowStrings.getSimplifiedWorkflowSchemeNameV3Format(), projectKey);
    }

    private ActionDescriptor findGlobalActionForStep(JiraWorkflow workflow, StepDescriptor linkedStep) {
        List globalActions = workflow.getDescriptor().getGlobalActions();
        ActionDescriptor globalActionForStep = null;
        for (ActionDescriptor globalAction : globalActions) {
            if (linkedStep.getId() != globalAction.getUnconditionalResult().getStep() || !globalAction.getName().equals(linkedStep.getName())) continue;
            globalActionForStep = globalAction;
            break;
        }
        return globalActionForStep;
    }

    private ServiceOutcome<Status> isStatusInWorkflow(JiraWorkflow workflow, String statusId) {
        List linkedStatuses = workflow.getLinkedStatusObjects();
        Status found = null;
        for (Status status : linkedStatuses) {
            if (!statusId.equals(status.getId())) continue;
            found = status;
            break;
        }
        if (found == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.status.error.not.found.in.workflow", statusId, workflow.getName());
        }
        return ServiceOutcomeImpl.ok(found);
    }

    private JiraWorkflow getMutableWorkflow(JiraWorkflow jw) {
        JiraWorkflow jiraWorkflow = jw.isDraftWorkflow() ? jw : this.workflowManager.getWorkflowClone(jw.getName());
        return jiraWorkflow;
    }

    private ServiceOutcome<StepDescriptor> addStep(JiraWorkflow mutable, Status status) {
        StepDescriptor newStep = DescriptorFactory.getFactory().createStepDescriptor();
        newStep.setName(status.getName());
        newStep.setId(WorkflowUtil.getNextId((List)mutable.getDescriptor().getSteps()));
        newStep.getMetaAttributes().put("jira.status.id", status.getId());
        newStep.setParent((AbstractDescriptor)mutable.getDescriptor());
        mutable.getDescriptor().addStep(newStep);
        return ServiceOutcomeImpl.ok(newStep);
    }

    private ServiceOutcome<Void> addGlobalTransition(JiraWorkflow mutable, String name, String desc, int stepId, boolean updateResolutionToDone) {
        ActionDescriptor action = DescriptorFactory.getFactory().createActionDescriptor();
        action.setId(mutable.getNextActionId());
        action.setName(name);
        action.getMetaAttributes().put("jira.description", desc);
        action.setView(null);
        ResultDescriptor result = DescriptorFactory.getFactory().createResultDescriptor();
        action.setUnconditionalResult(result);
        result.setStep(stepId);
        result.setOldStatus("Not Done");
        result.setStatus("Done");
        try {
            this.createDefaultPostFunctions(action, updateResolutionToDone);
            this.createDefaultRestriction(action);
        }
        catch (PluginParseException ppe) {
            this.log.warn("Could not create global transition '%s' to step %d in workflow '%s': %s", name, stepId, mutable.getName(), ppe.getMessage());
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.workflow.global.transition.error.could.not.create", name, mutable.getName());
        }
        action.setParent((AbstractDescriptor)mutable.getDescriptor());
        mutable.getDescriptor().addGlobalAction(action);
        return ServiceOutcomeImpl.ok();
    }

    private void createDefaultRestriction(ActionDescriptor actionDescriptor) {
        RestrictionDescriptor restriction = new RestrictionDescriptor();
        ConditionsDescriptor conditionsDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor();
        restriction.setConditionsDescriptor(conditionsDescriptor);
        actionDescriptor.setRestriction(restriction);
    }

    private void removeAllActionsFromWorkflow(JiraWorkflow mutable) {
        mutable.getDescriptor().getGlobalActions().clear();
        mutable.getDescriptor().getCommonActions().clear();
        List steps = mutable.getDescriptor().getSteps();
        for (StepDescriptor step : steps) {
            step.getCommonActions().clear();
            step.getActions().clear();
        }
    }

    private ServiceOutcome<Void> removeAllActionsForStep(JiraWorkflow workflow, Status targetStatus, StepDescriptor targetStep) {
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        ActionDescriptor globalAction = this.findGlobalActionForStep(workflow, targetStep);
        if (globalAction == null) {
            return SimplifiedWorkflowServiceImpl.createStatusCannotBeRemovedError(targetStatus);
        }
        descriptor.removeAction(globalAction);
        Collection allActions = workflow.getAllActions();
        Set<Integer> actionsToRemove = this.findAllActionsWithTargetStep(targetStep, allActions);
        List steps = descriptor.getSteps();
        for (StepDescriptor step : steps) {
            List commonActions = step.getCommonActions();
            Iterator iterator = commonActions.iterator();
            while (iterator.hasNext()) {
                Integer actionId = (Integer)iterator.next();
                if (!actionsToRemove.contains(actionId)) continue;
                iterator.remove();
            }
            List actions = step.getActions();
            Iterator iterator2 = actions.iterator();
            while (iterator2.hasNext()) {
                ActionDescriptor action = (ActionDescriptor)iterator2.next();
                if (!actionsToRemove.contains(action.getId())) continue;
                iterator2.remove();
            }
        }
        Map commonActions = descriptor.getCommonActions();
        for (Integer actionId : actionsToRemove) {
            if (!commonActions.containsKey(actionId)) continue;
            commonActions.remove(actionId);
        }
        targetStep.getActions().clear();
        return ServiceOutcomeImpl.ok();
    }

    private Set<Integer> findAllActionsWithTargetStep(StepDescriptor targetStep, Collection<ActionDescriptor> actions) {
        HashSet<Integer> foundActions = new HashSet<Integer>();
        for (ActionDescriptor action : actions) {
            if (action.getUnconditionalResult().getStep() == targetStep.getId()) {
                foundActions.add(action.getId());
            }
            List conditionalResults = action.getConditionalResults();
            for (ConditionalResultDescriptor conditionalResult : conditionalResults) {
                if (conditionalResult.getStep() != targetStep.getId()) continue;
                foundActions.add(action.getId());
            }
        }
        return foundActions;
    }

    private void replaceTargetStep(StepDescriptor oldInitialStep, StepDescriptor newInitialStep, ActionDescriptor action) {
        ResultDescriptor unconditionalResult = action.getUnconditionalResult();
        if (unconditionalResult.getStep() == oldInitialStep.getId()) {
            unconditionalResult.setStep(newInitialStep.getId());
        }
        List conditionalResults = action.getConditionalResults();
        for (ConditionalResultDescriptor conditionalResult : conditionalResults) {
            if (conditionalResult.getStep() != oldInitialStep.getId()) continue;
            conditionalResult.setStep(newInitialStep.getId());
        }
    }

    private void removeStatusFromSystemIfPossible(Status status) {
        List allWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
        for (JiraWorkflow workflow : allWorkflows) {
            StepDescriptor linkedStep = workflow.getLinkedStep(status);
            if (linkedStep == null) continue;
            return;
        }
        this.log.info("Removing status %s from the system as it is no longer used by any workflows", status.getName());
        this.statusManager.removeStatus(status.getId());
    }

    private ServiceOutcome<Void> doesEachStepHaveGlobalTransition(JiraWorkflow workflow) {
        List steps = workflow.getDescriptor().getSteps();
        for (StepDescriptor step : steps) {
            ActionDescriptor globalActionForStep = this.findGlobalActionForStep(workflow, step);
            if (globalActionForStep != null) continue;
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.no.global.transition.for.step", workflow.getName(), step.getName());
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<Void> doesWorkflowFollowSimplifiedWorkflowNamingScheme(JiraWorkflow workflow) {
        String workflowName = workflow.getName();
        if (!workflowName.startsWith(this.simplifiedWorkflowStrings.getSimplifiedWorkflowNamePrefix())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.simple.workflow.error.not.following.naming.scheme", this.simplifiedWorkflowStrings.getSimplifiedWorkflowNamePrefix());
        }
        return ServiceOutcomeImpl.ok();
    }

    private void createDefaultPostFunctions(ActionDescriptor actionDescriptor, boolean updateResolutionToDone) throws PluginParseException {
        ResultDescriptor unconditionalResult = actionDescriptor.getUnconditionalResult();
        List postFunctions = unconditionalResult.getPostFunctions();
        TreeMap<Integer, FunctionDescriptor> functionsToAdd = new TreeMap<Integer, FunctionDescriptor>();
        EnabledModulePredicate enabledPredicate = new EnabledModulePredicate();
        ModuleDescriptorOfTypePredicate typePredicate = new ModuleDescriptorOfTypePredicate(this.moduleDescriptorFactory, "workflow-function");
        Collection moduleDescriptors = this.pluginAccessor.getModuleDescriptors(typePredicate.and((Predicate)enabledPredicate));
        for (WorkflowFunctionModuleDescriptor functionModuleDescriptor : moduleDescriptors) {
            if (!functionModuleDescriptor.isDefault()) continue;
            FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
            functionDescriptor.setType("class");
            WorkflowPluginFunctionFactory functionFactory = (WorkflowPluginFunctionFactory)functionModuleDescriptor.getModule();
            functionDescriptor.getArgs().put("class.name", functionModuleDescriptor.getImplementationClass().getName());
            functionDescriptor.getArgs().putAll(functionFactory.getDescriptorParams(Collections.EMPTY_MAP));
            if (functionModuleDescriptor.getWeight() != null) {
                functionsToAdd.put(functionModuleDescriptor.getWeight(), functionDescriptor);
                continue;
            }
            functionsToAdd.put(Integer.MAX_VALUE, functionDescriptor);
        }
        FunctionDescriptor clearResolutionPostFunction = this.createUpdateResolutionPostFunction(updateResolutionToDone);
        if (clearResolutionPostFunction != null) {
            functionsToAdd.put(10, clearResolutionPostFunction);
        }
        for (Map.Entry entry : functionsToAdd.entrySet()) {
            postFunctions.add(entry.getValue());
        }
    }

    private FunctionDescriptor createUpdateResolutionPostFunction(boolean updateResolutionToDone) {
        AbstractWorkflowModuleDescriptor pluginModule = this.getUpdateIssueFieldFunctionModule();
        if (pluginModule != null) {
            Resolution resolution = this.workflowConstantsService.getOrCreateResolution(this.simplifiedWorkflowStrings.getResolutionDone());
            String newResolutionValue = updateResolutionToDone ? resolution.getId() : "";
            FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
            functionDescriptor.setType("class");
            functionDescriptor.getArgs().put("class.name", pluginModule.getImplementationClass().getName());
            functionDescriptor.getArgs().putAll(MapBuilder.build((Object)"field.name", (Object)"resolution", (Object)"field.value", (Object)newResolutionValue));
            return functionDescriptor;
        }
        return null;
    }

    private AbstractWorkflowModuleDescriptor getUpdateIssueFieldFunctionModule() {
        AbstractWorkflowModuleDescriptor moduleDescriptor = (AbstractWorkflowModuleDescriptor)this.pluginAccessor.getPluginModule(UPDATE_ISSUE_FIELD_FUNCTION_PLUGIN_KEY);
        if (moduleDescriptor == null) {
            this.log.warn("Could not retrieve workflow-function module for '%s'", UPDATE_ISSUE_FIELD_FUNCTION_PLUGIN_KEY);
        }
        return moduleDescriptor;
    }

    private void saveMutableWorkflow(JiraWorkflow mutable) {
        this.workflowManager.saveWorkflowWithoutAudit(mutable);
    }

    private static <T> ServiceOutcome<T> createStatusCannotBeRemovedError(Status status) {
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.config.workflow.remove.status.error.not.configured", status.getNameTranslation());
    }

    private static <T> ServiceOutcome<T> createNoLinkedStepError(JiraWorkflow workflow, Status status) {
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.workflow.status.error.no.linked.step", status.getNameTranslation(), workflow.getName());
    }
}

