/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.workflow;

import com.atlassian.greenhopper.service.workflow.ColumnConstraintPresets;
import com.atlassian.greenhopper.service.workflow.PredefinedStatuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PresetData {
    private final String schemeName;
    private final String schemeDescription;
    private final String workflowName;
    private final String workflowDescription;
    private final List<PredefinedStatuses> statusNames;
    private final List<String> resolutionNames;
    private final String workflowPath;
    private final ColumnConstraintPresets columnConstraintPreset;

    static Builder builder() {
        return new Builder();
    }

    static Builder builder(PresetData source) {
        return new Builder(source);
    }

    private PresetData(String schemeName, String schemeDescription, String workflowName, String workflowDescription, List<PredefinedStatuses> statusNames, List<String> resolutionNames, String workflowPath, ColumnConstraintPresets columnConstraintPreset) {
        this.schemeName = schemeName;
        this.schemeDescription = schemeDescription;
        this.workflowName = workflowName;
        this.workflowDescription = workflowDescription;
        this.statusNames = statusNames;
        this.resolutionNames = resolutionNames;
        this.workflowPath = workflowPath;
        this.columnConstraintPreset = columnConstraintPreset;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String getSchemeDescription() {
        return this.schemeDescription;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public String getWorkflowDescription() {
        return this.workflowDescription;
    }

    public List<PredefinedStatuses> getStatusNames() {
        return this.statusNames;
    }

    public List<String> getResolutionNames() {
        return this.resolutionNames;
    }

    public String getWorkflowPath() {
        return this.workflowPath;
    }

    public ColumnConstraintPresets getColumnConstraintPreset() {
        return this.columnConstraintPreset;
    }

    static class Builder {
        private String schemeName;
        private String schemeDescription;
        private String workflowName;
        private String workflowDescription;
        private List<PredefinedStatuses> statusNames;
        private List<String> resolutionNames;
        private String workflowPath;
        private ColumnConstraintPresets columnConstraintPreset;

        Builder() {
        }

        Builder(PresetData source) {
            this.schemeName = source.schemeName;
            this.schemeDescription = source.schemeDescription;
            this.workflowName = source.workflowName;
            this.workflowDescription = source.workflowDescription;
            this.statusNames = new ArrayList<PredefinedStatuses>(source.statusNames);
            this.resolutionNames = new ArrayList<String>(source.resolutionNames);
            this.workflowPath = source.workflowPath;
        }

        Builder schemeName(String schemeName) {
            this.schemeName = schemeName;
            return this;
        }

        Builder schemeDescription(String schemeDescription) {
            this.schemeDescription = schemeDescription;
            return this;
        }

        Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        Builder workflowDescription(String workflowDescription) {
            this.workflowDescription = workflowDescription;
            return this;
        }

        Builder statusNames(PredefinedStatuses ... statusNames) {
            this.statusNames = Arrays.asList(statusNames);
            return this;
        }

        Builder resolutionNames(String ... resolutionNames) {
            this.resolutionNames = Arrays.asList(resolutionNames);
            return this;
        }

        Builder workflowPath(String workflowPath) {
            this.workflowPath = workflowPath;
            return this;
        }

        PresetData build() {
            return new PresetData(this.schemeName, this.schemeDescription, this.workflowName, this.workflowDescription, this.statusNames, this.resolutionNames, this.workflowPath, this.columnConstraintPreset);
        }

        public Builder columnConstraint(ColumnConstraintPresets preset) {
            this.columnConstraintPreset = preset;
            return this;
        }
    }
}

