/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.version;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.project.version.VersionMetaData;
import com.atlassian.greenhopper.project.version.VersionMetaDataImpl;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.version.VersionService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateMidnight;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionServiceImpl
implements VersionService {
    static final String ERROR_CONTEXT_START_DATE = "startDate";
    static final String ERROR_CONTEXT_RELEASE_DATE = "releaseDate";
    @Autowired
    private com.atlassian.jira.bc.project.version.VersionService versionService;
    @Autowired
    private IssueService issueService;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private VersionManager versionManager;

    @Override
    public synchronized ServiceOutcome<Map<Project, Version>> createVersions(ApplicationUser user, Collection<Project> projects, String name, String description, DateMidnight releaseDate) {
        Date release = releaseDate == null ? null : releaseDate.toDate();
        return this.createVersions(user, projects, name, description, release);
    }

    private ServiceOutcome<Map<Project, Version>> createVersions(ApplicationUser user, Collection<Project> projects, String name, String description, Date releaseDate) {
        HashMap versions = new HashMap();
        HashMap<Project, VersionService.CreateVersionValidationResult> validationResults = new HashMap<Project, VersionService.CreateVersionValidationResult>();
        for (Project project : projects) {
            VersionService.CreateVersionValidationResult result = this.versionService.validateCreateVersion(user, project, name, releaseDate, description, null);
            if (!result.isValid()) {
                ErrorCollection.Reason reason = ErrorCollection.Reason.VALIDATION_FAILED;
                if (result.getReasons().contains(VersionService.CreateVersionValidationResult.Reason.FORBIDDEN)) {
                    reason = ErrorCollection.Reason.FORBIDDEN;
                }
                return ServiceOutcomeImpl.from(result.getErrorCollection(), reason);
            }
            validationResults.put(project, result);
        }
        for (Map.Entry entry : validationResults.entrySet()) {
            Version version = this.versionService.createVersion(user, (VersionService.CreateVersionValidationResult)entry.getValue());
            versions.put(entry.getKey(), version);
        }
        return ServiceOutcomeImpl.ok(versions);
    }

    @Override
    public ServiceOutcome<Pair<Project, Version>> createVersion(ApplicationUser user, Project project, String name, String description, DateMidnight releaseDate) {
        ServiceOutcome<Map<Project, Version>> createdVersionsOutcome = this.createVersions(user, (Collection<Project>)Lists.newArrayList((Object[])new Project[]{project}), name, description, releaseDate);
        return this.getOneOutcome(project, createdVersionsOutcome);
    }

    private ServiceOutcome<Pair<Project, Version>> getOneOutcome(Project project, ServiceOutcome<Map<Project, Version>> createdVersionsOutcome) {
        if (createdVersionsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.from(createdVersionsOutcome.getErrors());
        }
        Version createdVersion = createdVersionsOutcome.getValue().get(project);
        return ServiceOutcomeImpl.ok(Pair.strictPairOf((Object)project, (Object)createdVersion));
    }

    @Override
    public ServiceOutcome<Pair<Project, Version>> createVersion(ApplicationUser user, Project project, String name, String description, Date releaseDate, Date startDate) {
        ServiceOutcome<Void> dates = VersionServiceImpl.validateStartReleaseDates(startDate, releaseDate, (Option<Date>)Option.none());
        if (dates.isInvalid()) {
            return ServiceOutcomeImpl.error(dates);
        }
        ServiceOutcome<Pair<Project, Version>> versionResult = this.getOneOutcome(project, this.createVersions(user, (Collection<Project>)Lists.newArrayList((Object[])new Project[]{project}), name, description, releaseDate));
        if (versionResult.isInvalid()) {
            return ServiceOutcomeImpl.error(versionResult);
        }
        Version version = (Version)versionResult.getValue().second();
        if (startDate != null) {
            this.versionManager.editVersionStartDate(version, startDate);
            VersionService.VersionResult versionById = this.versionService.getVersionById(user, version.getId());
            if (!versionById.isValid()) {
                return ServiceOutcomeImpl.from(versionById.getErrorCollection());
            }
            version = versionById.getVersion();
        }
        return ServiceOutcomeImpl.ok(Pair.of((Object)versionResult.getValue().first(), (Object)version));
    }

    @Override
    public ServiceOutcome<Void> addIssueToVersion(ApplicationUser user, Issue issue, Version version) {
        Validate.notNull((Object)issue, (String)"Issue must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)version, (String)"Version must not be null", (Object[])new Object[0]);
        IssueService.IssueResult result = this.issueService.getIssue(user, issue.getId());
        if (!result.isValid()) {
            return ServiceOutcomeImpl.from(result.getErrorCollection());
        }
        ServiceOutcome<Void> permissionCheck = this.validateUpdateIssuePermission(user, issue);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        MutableIssue mutableIssue = result.getIssue();
        Collection fixVersions = mutableIssue.getFixVersions();
        if (!fixVersions.contains(version)) {
            fixVersions.add(version);
            mutableIssue.setFixVersions(fixVersions);
            this.issueManager.updateIssue(user, mutableIssue, EventDispatchOption.ISSUE_UPDATED, false);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> setFixVersions(ApplicationUser user, Issue issue, Collection<Version> versions) {
        Validate.notNull((Object)issue, (String)"Issue must not be null", (Object[])new Object[0]);
        Validate.notNull(versions, (String)"Versions collection must not be null", (Object[])new Object[0]);
        IssueService.IssueResult result = this.issueService.getIssue(user, issue.getId());
        if (!result.isValid()) {
            return ServiceOutcomeImpl.from(result.getErrorCollection());
        }
        Long projectId = issue.getProjectId();
        for (Version version : versions) {
            if (version.getProjectId().equals(projectId)) continue;
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.version.issues.project.mismatch", 1);
        }
        ServiceOutcome<Void> permissionCheck = this.validateUpdateIssuePermission(user, issue);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        MutableIssue mutableIssue = result.getIssue();
        HashSet fixVersions = new HashSet(mutableIssue.getFixVersions());
        if (fixVersions.equals(versions)) {
            return ServiceOutcomeImpl.ok();
        }
        mutableIssue.setFixVersions(versions);
        this.issueManager.updateIssue(user, mutableIssue, EventDispatchOption.ISSUE_UPDATED, false);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceResult clearIssueVersions(ApplicationUser user, Issue issue) {
        Validate.notNull((Object)issue);
        IssueService.IssueResult result = this.issueService.getIssue(user, issue.getId());
        if (!result.isValid()) {
            return ServiceOutcomeImpl.from(result.getErrorCollection());
        }
        ServiceOutcome<Void> permissionCheck = this.validateUpdateIssuePermission(user, issue);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        MutableIssue mutableIssue = result.getIssue();
        Collection fixVersions = mutableIssue.getFixVersions();
        if (fixVersions.isEmpty()) {
            return ServiceResultImpl.ok();
        }
        mutableIssue.setFixVersions(Collections.emptySet());
        this.issueManager.updateIssue(user, mutableIssue, EventDispatchOption.ISSUE_UPDATED, false);
        return ServiceResultImpl.ok();
    }

    @Override
    public ServiceOutcome<Void> releaseVersions(ApplicationUser user, Collection<Version> versions, DateMidnight releaseDate) {
        ArrayList<VersionService.ReleaseVersionValidationResult> validationResults = new ArrayList<VersionService.ReleaseVersionValidationResult>();
        for (Version version : versions) {
            VersionService.ReleaseVersionValidationResult validationResult = this.versionService.validateReleaseVersion(user, version, releaseDate == null ? null : releaseDate.toDate());
            validationResults.add(validationResult);
            if (validationResult.isValid()) continue;
            return ServiceOutcomeImpl.from(validationResult.getErrorCollection());
        }
        for (VersionService.ReleaseVersionValidationResult validationResult : validationResults) {
            this.versionService.releaseVersion(validationResult);
        }
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public ServiceOutcome<Version> get(ApplicationUser user, Long versionId) {
        VersionService.VersionResult version = this.versionService.getVersionById(user, versionId);
        if (!version.isValid()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "Version not found", version);
        }
        return ServiceOutcomeImpl.ok(version.getVersion());
    }

    @Override
    public ServiceOutcome<Void> updateVersion(ApplicationUser user, Long versionId, String name, String description, Date releaseDate, Date startDate) {
        VersionService.VersionResult versionResult = this.versionService.getVersionById(user, versionId);
        if (!versionResult.isValid()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "Version not found", versionResult);
        }
        Version version = versionResult.getVersion();
        VersionBuilder builder = this.versionService.newVersionBuilder(version).name(name).description(description).releaseDate(releaseDate).startDate(startDate);
        VersionService.VersionBuilderValidationResult versionBuilderValidationResult = this.versionService.validateUpdate(user, builder);
        if (!versionBuilderValidationResult.isValid()) {
            return ServiceOutcomeImpl.from(versionBuilderValidationResult.getErrorCollection());
        }
        this.versionService.update(user, versionBuilderValidationResult);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public VersionMetaData getMetaData(@Nonnull Version version) {
        Validate.notNull((Object)version);
        return new VersionMetaDataImpl(version);
    }

    static ServiceOutcome<Void> validateStartReleaseDates(Date startDate, Date releaseDate, Option<Date> existingStartDate) {
        if (startDate != null && releaseDate != null && startDate.after(releaseDate)) {
            String errorContext = ERROR_CONTEXT_START_DATE;
            if (existingStartDate.isDefined() && ((Date)existingStartDate.get()).compareTo(startDate) == 0) {
                errorContext = ERROR_CONTEXT_RELEASE_DATE;
            }
            return ServiceOutcomeImpl.error(errorContext, ErrorCollection.Reason.VALIDATION_FAILED, "gh.version.error.start.date.after.release.date", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    private ServiceOutcome<Void> validateUpdateIssuePermission(ApplicationUser user, Issue issue) {
        if (!this.permissionService.canUpdateIssue(user, issue)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "editissue.error.no.edit.permission", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }
}

