/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.version;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.version.VersionPermissionService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionPermissionServiceImpl
implements VersionPermissionService {
    @Autowired
    private PermissionService permissionService;

    @Override
    @Nonnull
    public ServiceOutcome<Void> canCreateAnyVersion(ApplicationUser user, @Nonnull Collection<Project> projects) {
        if (projects.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.version.permission.error.no.projects", new Object[0]);
        }
        if (this.permissionService.isJiraAdministrator(user)) {
            return ServiceOutcomeImpl.ok();
        }
        if (this.permissionService.hasSomePermission(user, projects, 23)) {
            return ServiceOutcomeImpl.ok();
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.version.permission.error.create.for.project", projects.size());
    }
}

