/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.version;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.util.ServiceErrorCollector;
import com.atlassian.greenhopper.service.util.ServiceOutcomeException;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.service.version.ReleaseService;
import com.atlassian.greenhopper.service.version.VersionService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateMidnight;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseServiceImpl
implements ReleaseService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private VersionService versionService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;

    @Override
    public synchronized ServiceOutcome<Void> createAndReleaseVersion(ApplicationUser user, String name, String description, DateMidnight releaseDate, Long rapidViewId, Long columnId) {
        try {
            return ServiceOutcomeHelper.toServiceOutcome(() -> {
                Validate.notNull((Object)rapidViewId, (String)"RapidViewID must not be null", (Object[])new Object[0]);
                RapidView rapidView = ServiceOutcomeHelper.get(this.rapidViewService.getRapidView(user, rapidViewId));
                Map<Project, List<Issue>> issues = this.getDoneIssues(user, rapidView, columnId);
                Set<Project> projects = issues.keySet();
                this.validateReleasePermission(user, projects);
                this.log.info("creating versions in projects: %s", projects);
                Map<Project, Version> versions = ServiceOutcomeHelper.get(this.versionService.createVersions(user, projects, name, description, releaseDate));
                this.log.info("versions created: %s", versions);
                this.addIssuesToVersions(user, issues, versions);
                this.log.info("added issues to versions: %s", issues);
                this.releaseVersions(user, versions, releaseDate);
                this.log.info("versions released", new Object[0]);
            });
        }
        catch (Exception e) {
            this.log.exception(e);
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.release.failed", new Object[0]);
        }
    }

    @Override
    public ServiceOutcome<Map<Project, Integer>> getProjectReleasableIssueCount(ApplicationUser user, Long rapidViewId, Long columnId) {
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            RapidView rapidView = ServiceOutcomeHelper.get(this.rapidViewService.getRapidView(user, rapidViewId));
            Map<Project, List<Issue>> doneIssues = this.getDoneIssues(user, rapidView, columnId);
            this.validateReleasePermission(user, doneIssues.keySet());
            return doneIssues.entrySet().stream().collect(Collectors.toMap(e -> (Project)e.getKey(), e -> ((List)e.getValue()).size()));
        });
    }

    @Override
    public ServiceOutcome<SearchRequest> getNavigatorSearch(ApplicationUser user, Long projectId, Long rapidViewId, Long columnId) {
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            RapidView rapidView = ServiceOutcomeHelper.get(this.rapidViewService.getRapidView(user, rapidViewId));
            Project project = (Project)ServiceOutcomeHelper.get(this.projectService.getProjectById(user, projectId));
            JqlQueryBuilder query = this.getDoneQuery(user, rapidView, columnId);
            query.where().and().project(new String[]{project.getName()});
            return new SearchRequest(query.buildQuery());
        });
    }

    private void releaseVersions(ApplicationUser user, Map<Project, Version> versions, DateMidnight releaseDate) throws ServiceOutcomeException {
        ServiceOutcomeHelper.validate(this.versionService.releaseVersions(user, versions.values(), releaseDate));
    }

    private void addIssuesToVersions(ApplicationUser user, Map<Project, List<Issue>> issues, Map<Project, Version> versions) throws ServiceOutcomeException {
        ServiceErrorCollector collector = new ServiceErrorCollector();
        for (Map.Entry<Project, List<Issue>> entry : issues.entrySet()) {
            Version version = versions.get(entry.getKey());
            for (Issue issue : entry.getValue()) {
                collector.collect(this.versionService.addIssueToVersion(user, issue, version));
            }
        }
        collector.validate();
    }

    private void validateReleasePermission(ApplicationUser user, Collection<Project> projects) throws ServiceOutcomeException {
        if (!this.permissionService.isProjectAdministrator(user, projects)) {
            ServiceOutcomeHelper.throwError(ErrorCollection.Reason.FORBIDDEN, "gh.rapid.release.not_permitted", new Object[0]);
        }
    }

    private Map<Project, List<Issue>> getDoneIssues(ApplicationUser user, RapidView rapidView, Long columnId) throws ServiceOutcomeException {
        JqlQueryBuilder builder = this.getDoneQuery(user, rapidView, columnId);
        SearchResults result = null;
        try {
            result = this.searchService.search(user, builder.buildQuery(), PagerFilter.getUnlimitedFilter());
        }
        catch (SearchException e) {
            ServiceOutcomeHelper.throwError(ErrorCollection.Reason.SERVER_ERROR, e.getLocalizedMessage(), new Object[0]);
        }
        if (result.getResults().isEmpty()) {
            ServiceOutcomeHelper.throwError(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.release.no_issues", new Object[0]);
        }
        return result.getResults().stream().collect(Collectors.groupingBy(Issue::getProjectObject));
    }

    private JqlQueryBuilder getDoneQuery(ApplicationUser user, RapidView rapidView, Long columnId) throws ServiceOutcomeException {
        Column column = ServiceOutcomeHelper.get(this.columnService.getColumn(columnId));
        List<String> statusIds = column.getStatusIds();
        if (statusIds.isEmpty()) {
            ServiceOutcomeHelper.throwError(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.release.no_statuses", new Object[0]);
        }
        Query workModeQuery = ServiceOutcomeHelper.get(this.rapidViewQueryService.getWorkModeQuery(user, rapidView, column));
        return JqlQueryBuilder.newBuilder((Query)workModeQuery);
    }
}

