/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.util;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.util.ServiceOutcomeException;
import com.atlassian.greenhopper.service.util.ServiceRunnable;
import com.atlassian.greenhopper.service.util.ServiceSupplier;

public class ServiceOutcomeHelper {
    private ServiceOutcomeHelper() {
    }

    public static ServiceOutcome<Void> toServiceOutcome(ServiceRunnable runnable) {
        try {
            runnable.run();
            return ServiceOutcomeImpl.ok();
        }
        catch (ServiceOutcomeException e) {
            return ServiceOutcomeImpl.from(e.getErrorCollection());
        }
    }

    public static <T> ServiceOutcome<T> toServiceOutcome(ServiceSupplier<T> supplier) {
        try {
            T result = supplier.apply();
            return ServiceOutcomeImpl.ok(result);
        }
        catch (ServiceOutcomeException e) {
            return ServiceOutcomeImpl.from(e.getErrorCollection());
        }
    }

    public static void throwError(ErrorCollection.Reason reason, String messageKey, Object ... params) throws ServiceOutcomeException {
        throw new ServiceOutcomeException(reason, messageKey, params);
    }

    public static <T> T get(com.atlassian.jira.bc.ServiceOutcome<T> serviceOutcome) throws ServiceOutcomeException {
        if (serviceOutcome.isValid()) {
            return (T)serviceOutcome.get();
        }
        throw new ServiceOutcomeException(serviceOutcome.getErrorCollection());
    }

    public static <T> T get(ServiceOutcome<T> serviceOutcome) throws ServiceOutcomeException {
        if (serviceOutcome.isValid()) {
            return serviceOutcome.getValue();
        }
        throw new ServiceOutcomeException(serviceOutcome.getErrors());
    }

    public static void validate(ServiceOutcome<Void> serviceOutcome) throws ServiceOutcomeException {
        if (serviceOutcome.isInvalid()) {
            throw new ServiceOutcomeException(serviceOutcome.getErrors());
        }
    }

    public static void validate(ServiceResult serviceResult) throws ServiceOutcomeException {
        if (serviceResult.isInvalid()) {
            throw new ServiceOutcomeException(serviceResult.getErrors());
        }
    }

    public static void validate(com.atlassian.jira.bc.ServiceOutcome<Void> serviceOutcome) throws ServiceOutcomeException {
        if (!serviceOutcome.isValid()) {
            throw new ServiceOutcomeException(serviceOutcome.getErrorCollection());
        }
    }

    public static void validate(ErrorCollection errors) throws ServiceOutcomeException {
        if (errors.hasErrors()) {
            throw new ServiceOutcomeException(errors);
        }
    }
}

