/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.util;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.util.ServiceOutcomeException;
import java.util.Optional;

public class ServiceErrorCollector {
    private ErrorCollection errors = new ErrorCollection();
    private Optional<Boolean> isLastResultValid = Optional.empty();

    public void collect(ServiceOutcome<Void> result) {
        this.isLastResultValid = Optional.of(result.isValid());
        if (result.isInvalid()) {
            this.errors.addAllErrors(result.getErrors());
        }
    }

    public void collect(com.atlassian.jira.bc.ServiceOutcome<Void> result) {
        this.isLastResultValid = Optional.of(result.isValid());
        if (!result.isValid()) {
            this.errors.addAllErrors(ErrorCollection.fromJiraErrorCollection(result.getErrorCollection()));
        }
    }

    public <T> T collectOrGet(ServiceOutcome<T> result) {
        this.isLastResultValid = Optional.of(result.isValid());
        if (result.isInvalid()) {
            this.errors.addAllErrors(result.getErrors());
            return null;
        }
        return result.getValue();
    }

    public <T> T collectOrGet(com.atlassian.jira.bc.ServiceOutcome<T> result) {
        this.isLastResultValid = Optional.of(result.isValid());
        if (!result.isValid()) {
            this.errors.addAllErrors(ErrorCollection.fromJiraErrorCollection(result.getErrorCollection()));
            return null;
        }
        return (T)result.get();
    }

    public void validate() throws ServiceOutcomeException {
        if (this.errors.hasErrors()) {
            throw new ServiceOutcomeException(this.errors);
        }
    }

    public Optional<Boolean> isLastResultValid() {
        return this.isLastResultValid;
    }
}

