/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.user;

import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GHAvatarService {
    @Autowired
    private AvatarService avatarService;
    @Autowired
    private WebUtilities webUtilities;

    public String getLargeAvatarURL(ApplicationUser remoteUser) {
        return this.getAvatarImpl(remoteUser, Avatar.Size.LARGE);
    }

    public String getSmallAvatarURL(ApplicationUser remoteUser) {
        return this.getAvatarImpl(remoteUser, Avatar.Size.SMALL);
    }

    private String getAvatarImpl(ApplicationUser remoteUser, Avatar.Size size) {
        try {
            URI avatarURL = this.avatarService.getAvatarURL(remoteUser, remoteUser, size);
            return this.webUtilities.convertRelativeUrlToAbsolute(avatarURL.toString());
        }
        catch (AvatarsDisabledException e) {
            return "";
        }
    }

    public String getLargeProjectAvatarURL(Project project) {
        return this.getProjectAvatarURL(project, Avatar.Size.LARGE);
    }

    public String getSmallProjectAvatarURL(Project project) {
        return this.getProjectAvatarURL(project, Avatar.Size.SMALL);
    }

    private String getProjectAvatarURL(Project project, Avatar.Size size) {
        try {
            URI avatarURL = this.avatarService.getProjectAvatarURL(project, size);
            return this.webUtilities.convertRelativeUrlToAbsolute(avatarURL.toString());
        }
        catch (AvatarsDisabledException e) {
            return "";
        }
    }
}

