/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.timetracking;

import com.atlassian.greenhopper.service.issue.changehistory.SafeChangeHistory;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingHistoryService;
import com.atlassian.greenhopper.util.DateUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.worklog.Worklog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class WorklogTimelineResolver {
    private static final String CHANGE_FIELD = "field";
    private static final String CHANGE_NEWVALUE = "newvalue";
    private static final String CHANGE_OLDVALUE = "oldvalue";
    private static final String CHANGE_WORKLOGID = "WorklogId";
    private static HistoryEntryComparator HISTORY_ENTRY_COMPARATOR = new HistoryEntryComparator();

    /*
     * WARNING - void declaration
     */
    public static List<TimeTrackingHistoryService.HistoryEntry> resolveWorklogTimeline(Issue issue, List<Worklog> worklogs, List<SafeChangeHistory> changes) {
        ArrayList<TimeTrackingHistoryService.HistoryEntry> result = new ArrayList<TimeTrackingHistoryService.HistoryEntry>();
        HashMap<Worklog, TimeTrackingHistoryService.HistoryEntry> logToEntry = new HashMap<Worklog, TimeTrackingHistoryService.HistoryEntry>();
        for (Worklog worklog : worklogs) {
            DateTime worklogDate = DateUtils.toDateTime(worklog.getStartDate());
            Long timespent = worklog.getTimeSpent();
            TimeTrackingHistoryService.HistoryEntry entry = new TimeTrackingHistoryService.HistoryEntry();
            entry.setLogDate(worklogDate);
            entry.setTimeSpent(timespent);
            result.add(entry);
            logToEntry.put(worklog, entry);
        }
        TimeTrackingHistoryService.HistoryEntry firstRemainingEstimate = WorklogTimelineResolver.addFirstRemainingEstimate(issue, changes);
        if (firstRemainingEstimate != null) {
            result.add(firstRemainingEstimate);
        }
        for (SafeChangeHistory change : changes) {
            RemainingEstimateChange estimateChange = WorklogTimelineResolver.getRemainingEstimateChange(change);
            if (estimateChange == null) continue;
            Worklog worklog = WorklogTimelineResolver.findWorklogForChange(worklogs, change);
            TimeTrackingHistoryService.HistoryEntry entry = null;
            if (worklog != null) {
                entry = (TimeTrackingHistoryService.HistoryEntry)logToEntry.get(worklog);
            } else {
                entry = new TimeTrackingHistoryService.HistoryEntry();
                result.add(entry);
            }
            entry.updateEstimateDelta(estimateChange);
            entry.setChangeDate(estimateChange.changeDate);
        }
        Collections.sort(result, HISTORY_ENTRY_COMPARATOR);
        Long l = 0L;
        for (TimeTrackingHistoryService.HistoryEntry historyEntry : result) {
            void var6_9;
            historyEntry.setRemainingEstimateBefore((Long)var6_9);
            Long l2 = var6_9.longValue() + historyEntry.getEstimateDelta();
            historyEntry.setRemainingEstimateAfter(l2);
        }
        return result;
    }

    private static Worklog findWorklogForChange(List<Worklog> worklogs, SafeChangeHistory change) {
        Worklog match = WorklogTimelineResolver.matchById(worklogs, change);
        if (match != null) {
            return match;
        }
        return null;
    }

    private static Worklog matchById(List<Worklog> worklogs, SafeChangeHistory change) {
        for (ChangeItemBean ci : change.getChangeItems()) {
            if (!CHANGE_WORKLOGID.equals(ci.getField())) continue;
            Long id = WorklogTimelineResolver.parseLong(ci.getFrom());
            for (Worklog worklog : worklogs) {
                if (!worklog.getId().equals(id)) continue;
                return worklog;
            }
        }
        return null;
    }

    private static boolean isSameWorker(Worklog worklog, SafeChangeHistory change) {
        return change.getAuthor() == null && worklog.getAuthor() == null || change.getAuthor() != null && change.getAuthor().equals(worklog.getAuthor());
    }

    private static boolean isSameDatePerformed(Worklog worklog, SafeChangeHistory change) {
        long changeTime = change.getTimePerformed().getTime();
        long worklogTime = worklog.getUpdated() != null ? worklog.getUpdated().getTime() : worklog.getCreated().getTime();
        return Math.abs(changeTime - worklogTime) <= 300L;
    }

    private static TimeTrackingHistoryService.HistoryEntry addFirstRemainingEstimate(Issue issue, List<SafeChangeHistory> changes) {
        boolean found = false;
        Long firstEstimate = null;
        for (SafeChangeHistory change : changes) {
            RemainingEstimateChange estimateChange = WorklogTimelineResolver.getRemainingEstimateChange(change);
            if (estimateChange == null) continue;
            firstEstimate = estimateChange.oldValue;
            found = true;
            break;
        }
        if (!found) {
            firstEstimate = issue.getEstimate();
        }
        if (firstEstimate != null) {
            DateTime createdTime = DateUtils.toDateTime(issue.getCreated());
            TimeTrackingHistoryService.HistoryEntry entry = new TimeTrackingHistoryService.HistoryEntry();
            entry.setChangeDate(createdTime);
            entry.setRemainingEstimateAfter(firstEstimate);
            entry.setEstimateDelta(firstEstimate);
            return entry;
        }
        return null;
    }

    private static RemainingEstimateChange getRemainingEstimateChange(SafeChangeHistory change) {
        for (ChangeItemBean ci : change.getChangeItems()) {
            if (!"timeestimate".equals(ci.getField())) continue;
            Long oldValue = WorklogTimelineResolver.parseLong(ci.getFrom());
            Long newValue = WorklogTimelineResolver.parseLong(ci.getTo());
            if (newValue == null) {
                newValue = 0L;
            }
            DateTime changeDate = DateUtils.toDateTime(change.getTimePerformed());
            return new RemainingEstimateChange(oldValue, newValue, changeDate);
        }
        return null;
    }

    private static Long parseLong(String string) {
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    static class HistoryEntryComparator
    implements Comparator<TimeTrackingHistoryService.HistoryEntry> {
        HistoryEntryComparator() {
        }

        @Override
        public int compare(TimeTrackingHistoryService.HistoryEntry o1, TimeTrackingHistoryService.HistoryEntry o2) {
            DateTime d2;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            DateTime d1 = o1.getLogDate();
            if (d1 == null) {
                d1 = o1.getChangeDate();
            }
            if ((d2 = o2.getLogDate()) == null) {
                d2 = o2.getChangeDate();
            }
            return d1.compareTo((ReadableInstant)d2);
        }
    }

    static class RemainingEstimateChange {
        Long oldValue;
        Long newValue;
        DateTime changeDate;

        RemainingEstimateChange(Long oldValue, Long newValue, DateTime changeTime) {
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.changeDate = changeTime;
        }

        public String toString() {
            return "RemainingEstimateChange{oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", changeDate=" + this.changeDate + '}';
        }
    }
}

