/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.timetracking;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeTrackingServiceImpl
implements TimeTrackingService {
    private static final String TIMETRACKING_ERROR_CONTEXT = "timetracking";
    @Autowired
    private IssueService issueService;
    @Autowired
    private IssueUpdateService issueUpdateService;
    @Autowired
    private JiraAuthenticationContext authenticationContext;

    @Override
    @Nonnull
    public ServiceOutcome<Void> updateRemainingEstimate(Issue issue, String duration) {
        ApplicationUser user = this.authenticationContext.getUser();
        IssueInputParametersImpl issueInputParameters = new IssueInputParametersImpl();
        issueInputParameters.setRemainingEstimate(duration);
        return this.performUpdate(issue, user, issueInputParameters, "timeestimate");
    }

    @Override
    public ServiceOutcome<Void> updateRemainingEstimate(Issue issue, String duration, boolean updateOriginalEstimateIfNotSet) {
        ServiceOutcome<Void> outcome = this.updateRemainingEstimate(issue, duration);
        if (outcome.isValid() && updateOriginalEstimateIfNotSet && issue.getOriginalEstimate() == null) {
            outcome = this.updateOriginalEstimate(issue, duration);
        }
        return outcome;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> updateOriginalEstimate(Issue issue, String duration) {
        ApplicationUser user = this.authenticationContext.getUser();
        IssueInputParametersImpl issueInputParameters = new IssueInputParametersImpl();
        issueInputParameters.setOriginalEstimate(duration);
        return this.performUpdate(issue, user, issueInputParameters, "timeoriginalestimate");
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> updateOriginalEstimate(Issue issue, String duration, boolean updateRemainingEstimateIfNotSet) {
        ServiceOutcome<Void> outcome = this.updateOriginalEstimate(issue, duration);
        if (outcome.isValid() && updateRemainingEstimateIfNotSet && issue.getEstimate() == null) {
            outcome = this.updateRemainingEstimate(issue, duration);
        }
        return outcome;
    }

    @Override
    public AggregateTimeTrackingBean getAggregates(Issue issue, Collection<Issue> subTasks) {
        AggregateTimeTrackingBean bean = new AggregateTimeTrackingBean(issue.getOriginalEstimate(), issue.getEstimate(), issue.getTimeSpent(), 0);
        if (issue.isSubTask()) {
            return bean;
        }
        if (subTasks != null && !subTasks.isEmpty()) {
            int subTaskCount = 0;
            for (Issue subTask : subTasks) {
                bean.setRemainingEstimate(AggregateTimeTrackingBean.addAndPreserveNull((Long)subTask.getEstimate(), (Long)bean.getRemainingEstimate()));
                bean.setOriginalEstimate(AggregateTimeTrackingBean.addAndPreserveNull((Long)subTask.getOriginalEstimate(), (Long)bean.getOriginalEstimate()));
                bean.setTimeSpent(AggregateTimeTrackingBean.addAndPreserveNull((Long)subTask.getTimeSpent(), (Long)bean.getTimeSpent()));
                bean.bumpGreatestSubTaskEstimate(subTask.getOriginalEstimate(), subTask.getEstimate(), subTask.getTimeSpent());
                ++subTaskCount;
            }
            bean.setSubTaskCount(subTaskCount);
        }
        return bean;
    }

    private ServiceOutcome<Void> performUpdate(Issue issue, ApplicationUser user, IssueInputParametersImpl issueInputParameters, String correctContextId) {
        IssueService.UpdateValidationResult updateValidationResult = this.issueUpdateService.validateUpdate(user, issue.getId(), (IssueInputParameters)issueInputParameters);
        ErrorCollection errors = new ErrorCollection();
        if (!updateValidationResult.isValid()) {
            com.atlassian.jira.util.ErrorCollection errorCollection = updateValidationResult.getErrorCollection();
            errorCollection = this.fixErrorContextIds(errorCollection, correctContextId);
            return ServiceOutcomeImpl.from(errorCollection);
        }
        IssueService.IssueResult issueResult = this.issueService.update(user, updateValidationResult, EventDispatchOption.ISSUE_UPDATED, true);
        if (issueResult.getErrorCollection().hasAnyErrors()) {
            com.atlassian.jira.util.ErrorCollection errorCollection = issueResult.getErrorCollection();
            errorCollection = this.fixErrorContextIds(errorCollection, correctContextId);
            return ServiceOutcomeImpl.from(errorCollection);
        }
        return ServiceOutcomeImpl.ok();
    }

    private com.atlassian.jira.util.ErrorCollection fixErrorContextIds(com.atlassian.jira.util.ErrorCollection errorCollection, String correctContextId) {
        Map errors = errorCollection.getErrors();
        this.fixError(errors, TIMETRACKING_ERROR_CONTEXT, correctContextId);
        this.fixError(errors, "timetracking_originalestimate", "timeoriginalestimate");
        this.fixError(errors, "timetracking_remainingestimate", "timeestimate");
        return errorCollection;
    }

    private void fixError(Map<String, String> errors, String badContextId, String correctContextId) {
        if (errors.containsKey(badContextId)) {
            errors.put(correctContextId, errors.get(badContextId));
            errors.remove(badContextId);
        }
    }
}

