/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.timetracking;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.changehistory.ChangeHistoryService;
import com.atlassian.greenhopper.service.issue.changehistory.SafeChangeHistory;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingHistoryService;
import com.atlassian.greenhopper.service.timetracking.WorklogTimelineResolver;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeTrackingHistoryServiceImpl
implements TimeTrackingHistoryService {
    @Autowired
    private ChangeHistoryService changeHistoryService;
    @Autowired
    private WorklogManager worklogManager;
    @Autowired
    private SearchService searchService;

    @Override
    public ServiceOutcome<TimeTrackingHistoryService.TimeTrackingHistory> getTimeTrackingHistory(ApplicationUser user, Collection<String> issueKeys) {
        String[] issueKeysArray = issueKeys.toArray(new String[0]);
        ServiceOutcome<SearchResults<Issue>> issues = this.searchService.search(user, JqlQueryBuilder.newBuilder().where().issue(issueKeysArray).buildQuery());
        if (!issues.isValid()) {
            return ServiceOutcomeImpl.error(issues);
        }
        HashMap<String, List<TimeTrackingHistoryService.HistoryEntry>> data = new HashMap<String, List<TimeTrackingHistoryService.HistoryEntry>>();
        for (Issue issue : issues.getValue().getResults()) {
            List<TimeTrackingHistoryService.HistoryEntry> entriesForIssue = this.computeWorklogTimeline(user, issue);
            data.put(issue.getKey(), entriesForIssue);
        }
        TimeTrackingHistoryService.TimeTrackingHistory history = new TimeTrackingHistoryService.TimeTrackingHistory();
        history.setData(data);
        return ServiceOutcomeImpl.ok(history);
    }

    private List<TimeTrackingHistoryService.HistoryEntry> computeWorklogTimeline(ApplicationUser user, Issue issue) {
        List worklogs = this.worklogManager.getByIssue(issue);
        List<SafeChangeHistory> changes = this.changeHistoryService.getChangeHistoriesForUser(issue, user);
        return WorklogTimelineResolver.resolveWorklogTimeline(issue, worklogs, changes);
    }
}

