/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.timetracking;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.timetracking.WorklogTimelineResolver;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public interface TimeTrackingHistoryService {
    public ServiceOutcome<TimeTrackingHistory> getTimeTrackingHistory(ApplicationUser var1, Collection<String> var2);

    public static class HistoryEntry {
        private Long remainingEstimateBefore;
        private Long remainingEstimateAfter;
        private Long timeSpent;
        private Long estimateDelta = 0L;
        private DateTime logDate;
        private DateTime changeDate;

        public Long getRemainingEstimateBefore() {
            return this.remainingEstimateBefore;
        }

        public void setRemainingEstimateBefore(Long remainingEstimateBefore) {
            this.remainingEstimateBefore = remainingEstimateBefore;
        }

        public Long getRemainingEstimateAfter() {
            return this.remainingEstimateAfter;
        }

        public void setRemainingEstimateAfter(Long remainingEstimateAfter) {
            this.remainingEstimateAfter = remainingEstimateAfter;
        }

        public Long getTimeSpent() {
            return this.timeSpent;
        }

        public void setTimeSpent(Long timeSpent) {
            this.timeSpent = timeSpent;
        }

        public DateTime getChangeDate() {
            return this.changeDate;
        }

        public void setChangeDate(DateTime changeDate) {
            this.changeDate = changeDate;
        }

        public DateTime getLogDate() {
            return this.logDate;
        }

        public void setLogDate(DateTime logDate) {
            this.logDate = logDate;
        }

        public Long getEstimateDelta() {
            return this.estimateDelta;
        }

        public void setEstimateDelta(Long estimateDelta) {
            this.estimateDelta = estimateDelta;
        }

        public void updateEstimateDelta(WorklogTimelineResolver.RemainingEstimateChange estimateChange) {
            Long currentDelta = this.estimateDelta;
            Long newEstimate = estimateChange.newValue;
            Long oldEstimate = estimateChange.oldValue;
            if (currentDelta == null) {
                currentDelta = 0L;
            }
            if (newEstimate == null) {
                newEstimate = 0L;
            }
            if (oldEstimate == null) {
                oldEstimate = 0L;
            }
            this.estimateDelta = currentDelta + newEstimate - oldEstimate;
        }
    }

    public static class TimeTrackingHistory {
        Map<String, List<HistoryEntry>> data;

        public Map<String, List<HistoryEntry>> getData() {
            return this.data;
        }

        public void setData(Map<String, List<HistoryEntry>> data) {
            this.data = data;
        }
    }
}

