/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint.health;

import com.atlassian.greenhopper.issue.util.OrderedPriorityHelper;
import com.atlassian.greenhopper.manager.issue.fields.FlagCustomFieldProvider;
import com.atlassian.greenhopper.model.charts.WorkRateData;
import com.atlassian.greenhopper.model.rapid.ColumnProgress;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.WorkRateService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintProgress;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemaining;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemainingService;
import com.atlassian.greenhopper.service.sprint.health.SprintHealth;
import com.atlassian.greenhopper.service.sprint.health.SprintHealthMetricsResolver;
import com.atlassian.greenhopper.service.sprint.health.SprintHealthService;
import com.atlassian.greenhopper.service.sprint.health.SprintIssueMetrics;
import com.atlassian.greenhopper.service.sprint.health.SprintMetrics;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModel;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModelFactory;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintHealthServiceImpl
implements SprintHealthService {
    private static final int BATCH_SIZE = 500;
    @Autowired
    private RapidIssueEntryQueryService issueQueryService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private SprintTimeRemainingService sprintTimeRemainingService;
    @Autowired
    private SprintBurndownModelFactory sprintBurndownModelFactory;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private WorkRateService workRateService;
    @Autowired
    private OfBizDelegator ofBizDelegator;
    @Autowired
    private AvatarService avatarService;
    @Autowired
    private FlagCustomFieldProvider flagCustomFieldProvider;
    @Autowired
    private OrderedPriorityHelper orderedPriorityHelper;
    @Autowired
    private UserManager userManager;
    @Autowired
    private StatusManager statusManager;

    private static String formatDisplayName(String displayName, String username) {
        return String.format("%s (%s)", displayName, username);
    }

    @Override
    public ServiceOutcome<SprintHealth> getSprintHealth(ApplicationUser user, RapidView rapidView, Sprint sprint) {
        ColumnService.ColumnProgressMap progressStatuses;
        ServiceOutcome<CollectIssuesResult> sprintIssuesOutcome = this.issueQueryService.collectSprintIssues(user, rapidView, sprint.getId(), null);
        if (sprintIssuesOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintIssuesOutcome);
        }
        CollectIssuesResult sprintIssues = sprintIssuesOutcome.getValue();
        ServiceOutcome<SprintMetrics> sprintMetricsOutcome = this.collectSprintMetrics(user, rapidView, sprint, sprintIssues, progressStatuses = this.columnService.getProgressStatuses(rapidView));
        if (sprintMetricsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintMetricsOutcome);
        }
        SprintMetrics sprintMetrics = sprintMetricsOutcome.getValue();
        Option<Priority> getHighestPriority = this.orderedPriorityHelper.getHighestPriority();
        ServiceOutcome<SprintIssueMetrics> sprintIssueMetricsOutcome = this.collectSprintIssueMetrics(rapidView, sprintIssues, this.getOnGoingIssueWithHighestPriorityPredicate(getHighestPriority));
        if (sprintIssueMetricsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintIssueMetricsOutcome);
        }
        SprintIssueMetrics sprintIssueMetrics = sprintIssueMetricsOutcome.getValue();
        SprintProgress sprintProgress = this.resolveSprintProgress(sprintIssues, progressStatuses);
        ServiceOutcome<SprintTimeRemaining> sprintTimeRemainingOutcome = this.sprintTimeRemainingService.getSprintTimeRemaining(user, rapidView, sprint.getId());
        if (sprintTimeRemainingOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintTimeRemainingOutcome);
        }
        SprintTimeRemaining timeRemaining = sprintTimeRemainingOutcome.getValue();
        List<SprintHealth.SprintHealthAssignee> assignees = this.getInvolvedAssigneesInSprint(user, sprint.getStartDate(), sprintIssues.getIssues());
        SprintHealth sprintHealth = new SprintHealth();
        sprintHealth.id = sprint.getId();
        sprintHealth.name = sprint.getName();
        sprintHealth.status = SprintHealth.Status.GOOD;
        sprintHealth.assignees = assignees;
        sprintHealth.progress = sprintProgress;
        sprintHealth.columns = progressStatuses;
        sprintHealth.issueMetrics = sprintIssueMetrics;
        sprintHealth.sprintMetrics = sprintMetrics;
        sprintHealth.timeRemaining = timeRemaining;
        sprintHealth.timeBasedEstimation = this.isTimeBasedEstimation(rapidView);
        sprintHealth.timeTrackingEnabled = this.isTimeTrackingEnabled(rapidView);
        sprintHealth.flaggedField = this.flagCustomFieldProvider.getOrCreateDefaultField().getName();
        if (getHighestPriority.isDefined()) {
            Priority priority = (Priority)getHighestPriority.get();
            sprintHealth.highestPriorityId = priority.getId();
            sprintHealth.highestPriorityName = (String)Option.option((Object)priority.getNameTranslation()).getOrElse((Object)priority.getName());
        }
        return ServiceOutcomeImpl.ok(sprintHealth);
    }

    private ServiceOutcome<SprintMetrics> collectSprintMetrics(ApplicationUser user, RapidView rapidView, Sprint sprint, CollectIssuesResult sprintIssues, ColumnService.ColumnProgressMap progressStatuses) {
        ServiceOutcome<SprintBurndownModel> scopeChangeBurndownModelOutcome = this.sprintBurndownModelFactory.getScopeChangeBurndownModel(user, rapidView, sprint.getId());
        if (scopeChangeBurndownModelOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(scopeChangeBurndownModelOutcome);
        }
        SprintBurndownModel sprintBurndown = scopeChangeBurndownModelOutcome.getValue();
        ServiceOutcome<WorkRateData> workRateOutcome = this.workRateService.getRateData(user, rapidView, sprint.getStartDate(), sprint.getEndDate());
        if (workRateOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(workRateOutcome);
        }
        WorkRateData workRateData = workRateOutcome.getValue();
        DateTime now = new DateTime(sprint.getStartDate().getZone());
        Long durationCompletionPercentage = SprintHealthMetricsResolver.calculateSprintCompletionPercentage(sprint, workRateData, now);
        SprintProgress sprintProgress = this.resolveSprintProgress(sprintIssues, progressStatuses);
        Long workCompletedPercentage = SprintHealthMetricsResolver.calculateWorkCompletionPercentage(sprintProgress);
        Long scopeChangePercentage = SprintHealthMetricsResolver.calculateScopeChangePercentage(sprint, sprintBurndown);
        SprintMetrics sprintMetrics = new SprintMetrics();
        sprintMetrics.addMetric(SprintMetrics.Type.DURATION_COMPLETION_PERCENTAGE, durationCompletionPercentage.toString());
        sprintMetrics.addMetric(SprintMetrics.Type.WORK_COMPLETION_PERCENTAGE, workCompletedPercentage.toString());
        sprintMetrics.addMetric(SprintMetrics.Type.SCOPE_CHANGE_PERCENTAGE, scopeChangePercentage.toString());
        return ServiceOutcomeImpl.ok(sprintMetrics);
    }

    private Predicate<RapidIssueEntry> getOnGoingIssueWithHighestPriorityPredicate(final Option<Priority> highestPriority) {
        return highestPriority.isEmpty() ? Predicates.alwaysFalse() : new Predicate<RapidIssueEntry>(){

            public boolean apply(RapidIssueEntry issue) {
                return SprintHealthServiceImpl.this.isHighestPriority(issue.priorityId, (Priority)highestPriority.get());
            }
        };
    }

    private ServiceOutcome<SprintIssueMetrics> collectSprintIssueMetrics(RapidView rapidView, CollectIssuesResult sprintIssues, Predicate<RapidIssueEntry> highestPriorityPredicate) {
        SprintIssueMetrics sprintIssueMetrics = new SprintIssueMetrics();
        int highestPriorityIssueCount = 0;
        int flaggedIssueCount = 0;
        ColumnService.ColumnProgressMap progressStatuses = this.columnService.getProgressStatuses(rapidView);
        for (RapidIssueEntry issue : sprintIssues.getIssues()) {
            if (this.isIssueDone(issue, progressStatuses)) continue;
            if (highestPriorityPredicate.apply((Object)issue)) {
                ++highestPriorityIssueCount;
            }
            if (issue.flagged == null) continue;
            ++flaggedIssueCount;
        }
        sprintIssueMetrics.addMetric(SprintIssueMetrics.Type.BLOCKERS, highestPriorityIssueCount);
        sprintIssueMetrics.addMetric(SprintIssueMetrics.Type.FLAGGED, flaggedIssueCount);
        return ServiceOutcomeImpl.ok(sprintIssueMetrics);
    }

    private SprintProgress resolveSprintProgress(CollectIssuesResult sprintIssues, ColumnService.ColumnProgressMap progressStatuses) {
        return SprintHealthMetricsResolver.resolveSprintProgress(progressStatuses, sprintIssues.getIssues());
    }

    private boolean isHighestPriority(String priorityId, Priority highestPriority) {
        return highestPriority.getId().equalsIgnoreCase(priorityId);
    }

    private boolean isTimeBasedEstimation(RapidView rapidView) {
        boolean timeBased = false;
        StatisticsField estimateStatistic = this.estimateStatisticService.getEstimateStatistic(rapidView);
        if (estimateStatistic.getConfig().getType().equals((Object)StatisticsFieldConfig.Type.JIRA_FIELD) && estimateStatistic.getDocumentId().equals("timeoriginalestimate")) {
            timeBased = true;
        }
        return timeBased;
    }

    private boolean isTimeTrackingEnabled(RapidView rapidView) {
        StatisticsField trackingStatistic = this.trackingStatisticService.getTrackingStatistic(rapidView);
        return !trackingStatistic.getConfig().getType().equals((Object)StatisticsFieldConfig.Type.NONE);
    }

    private boolean isIssueDone(RapidIssueEntry issue, ColumnService.ColumnProgressMap progressStatuses) {
        return ColumnProgress.DONE.equals((Object)progressStatuses.resolve(this.statusManager.getStatus(issue.statusId)));
    }

    @VisibleForTesting
    List<SprintHealth.SprintHealthAssignee> getInvolvedAssigneesInSprint(ApplicationUser user, DateTime sprintStartDate, List<RapidIssueEntry> issues) {
        HashMap assigneesDisplayName = Maps.newHashMap();
        for (RapidIssueEntry issue : issues) {
            if (issue.assignee == null) continue;
            assigneesDisplayName.put(issue.assignee, SprintHealthServiceImpl.formatDisplayName(issue.assigneeName, issue.assignee));
        }
        ImmutableList issueIds = ImmutableList.copyOf((Iterable)Iterables.transform(issues, (Function)new Function<RapidIssueEntry, Long>(){

            public Long apply(@Nullable RapidIssueEntry input) {
                return input.id;
            }
        }));
        int issueCount = issues.size();
        int batchNum = 0;
        int startIndex = 0;
        while (startIndex < issueCount) {
            ArrayList<EntityExpr> conditionList = new ArrayList<EntityExpr>();
            conditionList.add(new EntityExpr("issue", EntityOperator.IN, (Object)issueIds));
            conditionList.add(new EntityExpr("field", EntityOperator.EQUALS, (Object)"assignee"));
            conditionList.add(new EntityExpr("created", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)new Timestamp(sprintStartDate.getMillis())));
            EntityConditionList conditions = new EntityConditionList(conditionList, EntityOperator.AND);
            List changeItemsForFieldGVs = this.ofBizDelegator.findByCondition("ChangeGroupChangeItemView", (EntityCondition)conditions, null);
            for (GenericValue changeItemGV : changeItemsForFieldGVs) {
                String newAssignee = this.getUsername(changeItemGV.getString("newvalue"));
                String newAssigneeName = changeItemGV.getString("newstring");
                String oldAssignee = this.getUsername(changeItemGV.getString("oldvalue"));
                String oldAssigneeName = changeItemGV.getString("oldstring");
                if (newAssignee != null) {
                    assigneesDisplayName.put(newAssignee, SprintHealthServiceImpl.formatDisplayName(newAssigneeName, newAssignee));
                }
                if (oldAssignee == null) continue;
                assigneesDisplayName.put(oldAssignee, SprintHealthServiceImpl.formatDisplayName(oldAssigneeName, oldAssignee));
            }
            startIndex = ++batchNum * 500;
        }
        ArrayList avatars = Lists.newArrayListWithExpectedSize((int)assigneesDisplayName.size());
        for (String assignee : assigneesDisplayName.keySet()) {
            URI avatarURL = this.avatarService.getAvatarURL(user, this.userManager.getUserByName(assignee), Avatar.Size.LARGE);
            avatars.add(new SprintHealth.SprintHealthAssignee(assignee, (String)assigneesDisplayName.get(assignee), avatarURL.toString()));
        }
        return avatars;
    }

    private String getUsername(String userKey) {
        ApplicationUser applicationUser = this.userManager.getUserByKey(userKey);
        return applicationUser != null ? applicationUser.getUsername() : null;
    }
}

