/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint.health;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.charts.WorkRateData;
import com.atlassian.greenhopper.model.charts.WorkRateEntry;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.ColumnProgress;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintProgress;
import com.atlassian.greenhopper.service.sprint.health.SprintHealth;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModel;
import com.atlassian.greenhopper.web.rapid.chart.SprintTimes;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.jira.component.ComponentAccessor;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SprintHealthMetricsResolver {
    private static final LoggerWrapper LOG = LoggerWrapper.with(SprintHealthMetricsResolver.class);

    public static SprintProgress resolveSprintProgress(ColumnService.ColumnProgressMap columnProgressMap, List<RapidIssueEntry> issues) {
        SprintProgress sprintProgress = new SprintProgress(Lists.newArrayList((Object[])new String[]{ColumnProgress.NOT_STARTED.getNameKey(), ColumnProgress.IN_PROGRESS.getNameKey(), ColumnProgress.DONE.getNameKey()}));
        for (RapidIssueEntry issue : issues) {
            RapidIssueEntry.NumberFieldValue statFieldValue;
            Double estimateValue;
            if (issue.estimateStatistic == null || issue.parentId != null || (estimateValue = (statFieldValue = issue.estimateStatistic.getStatFieldValue()).getValue()) == null) continue;
            ColumnProgress columnProgress = columnProgressMap.resolve(ComponentAccessor.getConstantsManager().getStatus(issue.statusId));
            sprintProgress.incrementColumnEstimate(columnProgress.getNameKey(), estimateValue);
        }
        return sprintProgress;
    }

    public static SprintHealth.Status resolveSprintStatus(Long sprintCompletionPercentage, Long workCompletedPercentage) {
        long divergence;
        int steps;
        int rating;
        long divergenceStep;
        long l = divergenceStep = sprintCompletionPercentage < 100L ? (long)Math.round((100L - sprintCompletionPercentage) / 5L) : 5L;
        if (divergenceStep < 5L) {
            divergenceStep = 5L;
        }
        if ((rating = 4 - (steps = Double.valueOf(Math.floor((divergence = sprintCompletionPercentage - workCompletedPercentage) / divergenceStep)).intValue())) > 5) {
            rating = 5;
        }
        if (rating < 1) {
            rating = 1;
        }
        SprintHealth.Status status = SprintHealth.Status.resolveByRating(rating);
        LOG.info("Resolved sprint status %s where sprint completion %s percent, and work completion %s percent", status.name(), sprintCompletionPercentage.toString(), workCompletedPercentage.toString());
        return status;
    }

    public static boolean isIssueStale(RapidIssueEntry issue, Sprint sprint) {
        long sprintEndTime;
        long sprintDuration;
        long sprintStartTime = sprint.getStartDate().getMillis();
        long timeInColumnSinceStartOfSprint = issue.timeInColumn.enteredStatus - sprintStartTime;
        boolean stale = timeInColumnSinceStartOfSprint > (sprintDuration = (sprintEndTime = sprint.getEndDate().getMillis()) - sprintStartTime) / 2L;
        LOG.info("Check if issue %s is stale. Sprint duration is %d hours and issue has been in the same column for %d hours. Stale? %s", issue.key, sprintDuration / 3600000L, timeInColumnSinceStartOfSprint / 3600000L, stale);
        return stale;
    }

    public static boolean isIssueBoomerang(Sprint sprint, List<Column> columns, String issueKey, SortedSet<IssueColumnChange> statusChanges) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MM-yy hh:mm Z");
        long sprintStartTime = sprint.getStartDate().getMillis();
        boolean boomerang = statusChanges.size() >= columns.size() * 2;
        LOG.info("Check if issue %s is a boomerang. Boomerang? " + boomerang, new Object[0]);
        return boomerang;
    }

    public static Long calculateSprintCompletionPercentage(Sprint sprint, WorkRateData workRate, DateTime now) {
        Long sprintDuration = SprintHealthMetricsResolver.calculateDuration(sprint.getStartDate(), sprint.getEndDate(), workRate);
        Long timeWorkedSinceSprintStart = now.isAfter((ReadableInstant)sprint.getStartDate()) ? SprintHealthMetricsResolver.calculateDuration(sprint.getStartDate(), now, workRate) : 0L;
        double sprintDays = sprintDuration.doubleValue() / 8.64E7;
        double daysWorked = timeWorkedSinceSprintStart.doubleValue() / 8.64E7;
        LOG.info("Calculating sprint completion [sprint duration=%s, time worked since sprint start=%s]", sprintDays, daysWorked);
        Long percentage = Math.round(100.0 * timeWorkedSinceSprintStart.doubleValue() / sprintDuration.doubleValue());
        if (percentage > 100L) {
            return 100L;
        }
        if (percentage < 0L) {
            return 0L;
        }
        return percentage;
    }

    public static long calculateDuration(DateTime startDate, DateTime endDate, WorkRateData workRate) {
        long duration = endDate.getMillis() - startDate.getMillis();
        for (WorkRateEntry rateEntry : workRate.getRates()) {
            if (rateEntry.getRate() != 0) continue;
            if ((rateEntry.getStart().isBefore((ReadableInstant)startDate) || rateEntry.getStart().isEqual((ReadableInstant)startDate)) && rateEntry.getEnd().isAfter((ReadableInstant)startDate)) {
                duration -= rateEntry.getEnd().getMillis() - startDate.getMillis();
                continue;
            }
            if (rateEntry.getStart().isAfter((ReadableInstant)startDate) && rateEntry.getEnd().isBefore((ReadableInstant)endDate)) {
                duration -= rateEntry.getEnd().getMillis() - rateEntry.getStart().getMillis();
                continue;
            }
            if (!rateEntry.getStart().isBefore((ReadableInstant)endDate) || !rateEntry.getEnd().isAfter((ReadableInstant)endDate) && !rateEntry.getEnd().isEqual((ReadableInstant)endDate)) continue;
            duration -= endDate.getMillis() - rateEntry.getStart().getMillis();
        }
        return duration >= 0L ? duration : 0L;
    }

    public static Long calculateScopeChangePercentage(Sprint sprint, SprintBurndownModel sprintBurndown) {
        Iterable timeOrderedBurdownChanges = Iterables.concat(sprintBurndown.changes.values());
        HashMap<String, BurndownIssueState> initialStatesByIssueKey = new HashMap<String, BurndownIssueState>();
        HashMap<String, BurndownIssueState> completeStateByIssueKey = new HashMap<String, BurndownIssueState>();
        SprintTimes sprintTimes = new SprintTimes(sprint).invoke();
        for (BurndownChange change : timeOrderedBurdownChanges) {
            boolean initial = change.date.isBefore((ReadableInstant)sprintTimes.getStartTime());
            if (Boolean.FALSE.equals(change.added)) {
                if (initial) {
                    SprintHealthMetricsResolver.markStateAsDeleted(initialStatesByIssueKey, change.key);
                }
                SprintHealthMetricsResolver.markStateAsDeleted(completeStateByIssueKey, change.key);
            }
            if (Boolean.TRUE.equals(change.added)) {
                if (initial) {
                    SprintHealthMetricsResolver.markStateAsAdded(initialStatesByIssueKey, change.key);
                }
                SprintHealthMetricsResolver.markStateAsAdded(completeStateByIssueKey, change.key);
            }
            if (change.statC == null) continue;
            if (initial) {
                SprintHealthMetricsResolver.updateStateEstimate(initialStatesByIssueKey, change.key, change.statC.newValue);
            }
            SprintHealthMetricsResolver.updateStateEstimate(completeStateByIssueKey, change.key, change.statC.newValue);
        }
        double initialEstimate = SprintHealthMetricsResolver.sumStatesEstimates(initialStatesByIssueKey.values());
        double estimatesRatio = initialEstimate == 0.0 ? 1.0 : SprintHealthMetricsResolver.sumStatesEstimates(completeStateByIssueKey.values()) / initialEstimate;
        return Math.round(100.0 * estimatesRatio);
    }

    private static double sumStatesEstimates(Collection<BurndownIssueState> states) {
        double estimatesSum = 0.0;
        for (BurndownIssueState state : states) {
            if (!state.present || state.estimate == null) continue;
            estimatesSum += state.estimate.doubleValue();
        }
        return estimatesSum;
    }

    private static void markStateAsAdded(Map<String, BurndownIssueState> store, String key) {
        BurndownIssueState state = store.get(key);
        if (state == null) {
            state = new BurndownIssueState();
            store.put(key, state);
        }
        state.present = true;
    }

    private static void markStateAsDeleted(Map<String, BurndownIssueState> store, String key) {
        if (store.containsKey(key)) {
            BurndownIssueState state = store.get(key);
            state.present = false;
        }
    }

    private static void updateStateEstimate(Map<String, BurndownIssueState> store, String key, Double estimate) {
        BurndownIssueState state = store.get(key);
        if (state == null) {
            state = new BurndownIssueState();
            store.put(key, state);
        }
        state.estimate = estimate;
    }

    public static Long calculateWorkCompletionPercentage(SprintProgress sprintProgress) {
        Map<String, Double> estimatesByColumn = sprintProgress.getEstimateByColumn();
        Double notStartedEstimate = estimatesByColumn.get(ColumnProgress.NOT_STARTED.getNameKey());
        Double inProgressEstimate = estimatesByColumn.get(ColumnProgress.IN_PROGRESS.getNameKey());
        Double doneEstimate = estimatesByColumn.get(ColumnProgress.DONE.getNameKey());
        Double totalEstimate = notStartedEstimate + inProgressEstimate + doneEstimate;
        return Math.round(100.0 * (doneEstimate / totalEstimate));
    }

    private static class BurndownIssueState {
        boolean present;
        Double estimate;

        private BurndownIssueState() {
        }
    }

    public static class IssueColumnChange
    implements Comparable<IssueColumnChange> {
        public String issueKey;
        public Column columnFrom;
        public Column columnTo;
        public Long time;

        @Override
        public int compareTo(IssueColumnChange other) {
            return this.time.compareTo(other.time);
        }
    }
}

