/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint.health;

import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.sprint.SprintProgress;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemaining;
import com.atlassian.greenhopper.service.sprint.health.SprintIssueMetrics;
import com.atlassian.greenhopper.service.sprint.health.SprintMetrics;
import java.util.List;

public class SprintHealth {
    public String name;
    public long id;
    public Status status;
    public List<SprintHealthAssignee> assignees;
    public SprintTimeRemaining timeRemaining;
    public SprintProgress progress;
    public SprintIssueMetrics issueMetrics;
    public SprintMetrics sprintMetrics;
    public boolean timeBasedEstimation;
    public boolean timeTrackingEnabled;
    public String highestPriorityId;
    public String highestPriorityName;
    public String flaggedField;
    public ColumnService.ColumnProgressMap columns;

    public static class SprintHealthAssignee {
        public final String username;
        public final String displayName;
        public final String avatarURL;

        public SprintHealthAssignee(String username, String displayName, String avatarURL) {
            this.username = username;
            this.displayName = displayName;
            this.avatarURL = avatarURL;
        }
    }

    public static enum Status {
        AWESOME(5, "gh.gadget.sprint.health.status.awesome"),
        GOOD(4, "gh.gadget.sprint.health.status.good"),
        OK(3, "gh.gadget.sprint.health.status.ok"),
        BAD(2, "gh.gadget.sprint.health.status.bad"),
        HORRIBLE(1, "gh.gadget.sprint.health.status.horrible");

        private int rating;
        private String key;

        private Status(int rating, String key) {
            this.rating = rating;
            this.key = key;
        }

        public static Status resolveByRating(int rating) {
            for (Status status : Status.values()) {
                if (status.getRating() != rating) continue;
                return status;
            }
            return OK;
        }

        public int getRating() {
            return this.rating;
        }

        public String getKey() {
            return this.key;
        }
    }
}

