/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SprintUtils {
    public static final Predicate<Sprint> SPRINT_FUTURE = new SprintStatePredicate(Sprint.State.FUTURE);
    public static final Predicate<Sprint> SPRINT_ACTIVE = new SprintStatePredicate(Sprint.State.ACTIVE);
    public static final Predicate<Sprint> SPRINT_CLOSED = new SprintStatePredicate(Sprint.State.CLOSED);
    public static final Predicate<Sprint> SPRINT_NOT_CLOSED = SprintUtils.getStatesPredicate(Sprint.State.FUTURE, Sprint.State.ACTIVE);
    public static final Ordering<DateTime> DATE_COMPARATOR = Ordering.natural().nullsFirst();
    public static final Ordering<Long> SEQUENCE_COMPARATOR = Ordering.natural().nullsFirst();
    public static final Ordering<Sprint.State> STATE_COMPARATOR = Ordering.explicit((Object)((Object)Sprint.State.CLOSED), (Object[])new Sprint.State[]{Sprint.State.ACTIVE, Sprint.State.FUTURE});
    public static final Ordering<Sprint> SPRINT_START_DATE_COMPARATOR = DATE_COMPARATOR.onResultOf((Function)new Function<Sprint, DateTime>(){

        public DateTime apply(Sprint input) {
            return input.getStartDate();
        }
    });
    public static final Ordering<Sprint> SPRINT_END_DATE_COMPARATOR = DATE_COMPARATOR.onResultOf((Function)new Function<Sprint, DateTime>(){

        public DateTime apply(Sprint input) {
            return input.getEndDate();
        }
    });
    public static final Ordering<Sprint> SPRINT_ID_COMPARATOR = Ordering.natural().onResultOf((Function)new Function<Sprint, Comparable>(){

        public Comparable apply(Sprint input) {
            return input.getId();
        }
    });
    public static final Ordering<Sprint> SPRINT_STATE_COMPARATOR = STATE_COMPARATOR.onResultOf((Function)new Function<Sprint, Sprint.State>(){

        public Sprint.State apply(Sprint input) {
            return input.getState();
        }
    });
    public static final Ordering<Sprint> SPRINT_BYDATE_COMPARATOR = SPRINT_START_DATE_COMPARATOR.compound(SPRINT_END_DATE_COMPARATOR).nullsFirst();
    public static final Ordering<Sprint> SPRINT_SEQUENCE_COMPARATOR = SEQUENCE_COMPARATOR.onResultOf((Function)new Function<Sprint, Long>(){

        public Long apply(Sprint input) {
            return input.getSequence();
        }
    }).nullsFirst();
    public static final Ordering<Sprint> SPRINT_NATURAL_COMPARATOR = SPRINT_STATE_COMPARATOR.compound(SPRINT_SEQUENCE_COMPARATOR).compound(SPRINT_ID_COMPARATOR).nullsFirst();
    public static final Ordering<Sprint> SPRINT_DESCENDING_COMPARATOR = SPRINT_STATE_COMPARATOR.compound(SPRINT_SEQUENCE_COMPARATOR).compound(SPRINT_BYDATE_COMPARATOR).nullsFirst();

    public static Predicate<Sprint> getStatesPredicate(Sprint.State ... states) {
        EnumSet<Sprint.State> stateSet = EnumSet.copyOf(Arrays.asList(states));
        return SprintUtils.getStatesPredicate(stateSet);
    }

    public static Predicate<Sprint> getStatesPredicate(EnumSet<Sprint.State> states) {
        Predicate predicate = Predicates.alwaysFalse();
        for (Sprint.State state : states) {
            predicate = Predicates.or(SprintUtils.getStatePredicate(state), (Predicate)predicate);
        }
        return predicate;
    }

    public static List<Sprint> getFilteredAndSortedSprints(EnumSet<Sprint.State> states, Collection<Sprint> ... sprintCollections) {
        return SprintUtils.getFilteredAndSortedSprintsOrderingBy(states, SPRINT_NATURAL_COMPARATOR, sprintCollections);
    }

    public static List<Sprint> getFilteredAndSortedSprints(Ordering<Sprint> comparator, EnumSet<Sprint.State> states, Collection<Sprint> ... sprintCollections) {
        return SprintUtils.getFilteredAndSortedSprintsOrderingBy(states, comparator, sprintCollections);
    }

    public static List<Sprint> getFilteredAndSortedSprintsOrderingBy(EnumSet<Sprint.State> states, Ordering<Sprint> comparator, Collection<Sprint> ... sprintCollections) {
        HashSet<Sprint> sprintSet = new HashSet<Sprint>();
        for (Collection<Sprint> sprints : sprintCollections) {
            sprintSet.addAll(sprints);
        }
        ArrayList allSprints = Lists.newArrayList(sprintSet);
        List<Sprint> filteredSprints = SprintUtils.filter(allSprints, states);
        ArrayList resultList = Lists.newArrayList(filteredSprints);
        Collections.sort(resultList, comparator);
        return resultList;
    }

    public static List<Sprint> filter(List<Sprint> sprints, EnumSet<Sprint.State> states) {
        return Lists.newArrayList((Iterable)Iterables.filter(sprints, SprintUtils.getStatesPredicate(states)));
    }

    public static Collection<Sprint> getSprintsForIds(SprintManager sprintManager, Collection<Long> ids) {
        HashSet sprints = Sets.newHashSet();
        for (Long id : ids) {
            ServiceOutcome<Sprint> sprint = sprintManager.getSprint(id);
            if (!sprint.isValid()) continue;
            sprints.add(sprint.getValue());
        }
        return sprints;
    }

    private static Predicate<Sprint> getStatePredicate(Sprint.State state) {
        switch (state) {
            case FUTURE: {
                return SPRINT_FUTURE;
            }
            case ACTIVE: {
                return SPRINT_ACTIVE;
            }
            case CLOSED: {
                return SPRINT_CLOSED;
            }
        }
        throw new RuntimeException("Unknown sprint state: " + (Object)((Object)state));
    }

    public static Predicate<Sprint> getAllClosedSprintsAfterTheGivenOne(final Sprint checkingSprint) {
        return new Predicate<Sprint>(){

            public boolean apply(@Nullable Sprint existingSprint) {
                return Sprint.State.CLOSED == existingSprint.getState() && existingSprint.getCompleteDate().isAfter((ReadableInstant)checkingSprint.getCompleteDate());
            }
        };
    }

    private static class SprintStatePredicate
    implements Predicate<Sprint> {
        private final Sprint.State state;

        private SprintStatePredicate(Sprint.State state) {
            this.state = state;
        }

        public boolean apply(Sprint input) {
            return this.state == input.getState();
        }
    }
}

