/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.model.charts.WorkRateData;
import com.atlassian.greenhopper.model.charts.WorkRateEntry;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.WorkRateService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemaining;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemainingService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintTimeRemainingServiceImpl
implements SprintTimeRemainingService {
    @Autowired
    private SprintService sprintService;
    @Autowired
    private TimeZoneService timeZoneService;
    @Autowired
    private WorkRateService workRateService;

    @Override
    public ServiceOutcome<SprintTimeRemaining> getWorkdaysInPeriod(ApplicationUser user, RapidView rapidView, DateTime startDate, DateTime endDate) {
        String timeZoneId = this.getConfiguredTimeZoneId(user);
        DateTimeZone timeZone = DateTimeZone.forID((String)timeZoneId);
        DateTime today = startDate.toDateTime(timeZone);
        DateTime sprintEnd = endDate.toDateTime(timeZone);
        Duration duration = Duration.ZERO;
        if (today.isBefore((ReadableInstant)sprintEnd)) {
            ServiceOutcome<WorkRateData> rateDataOutcome = this.workRateService.getRateData(user, rapidView, today, sprintEnd);
            if (rateDataOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(rateDataOutcome);
            }
            WorkRateData workRateData = rateDataOutcome.getValue();
            for (WorkRateEntry workEntry : workRateData.getRates()) {
                if (workEntry.getRate() == 0) continue;
                duration = duration.plus((ReadableDuration)new Duration((ReadableInstant)workEntry.getStart(), (ReadableInstant)workEntry.getEnd()));
            }
        }
        SprintTimeRemaining timeRemaining = new SprintTimeRemaining();
        timeRemaining.days = (int)duration.getStandardDays();
        return ServiceOutcomeImpl.ok(timeRemaining);
    }

    @Override
    public ServiceOutcome<SprintTimeRemaining> getSprintTimeRemaining(ApplicationUser user, RapidView rapidView, Long sprintId) {
        ServiceOutcome<Sprint> sprintOutcome = this.sprintService.getSprint(user, sprintId);
        if (sprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintOutcome);
        }
        Sprint sprint = sprintOutcome.getValue();
        return this.getWorkdaysInPeriod(user, rapidView, DateTime.now(), sprint.getEndDate());
    }

    private String getConfiguredTimeZoneId(ApplicationUser user) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        boolean usesJiraTimeZone = this.timeZoneService.usesJiraTimeZone((JiraServiceContext)context);
        if (!usesJiraTimeZone) {
            TimeZoneInfo userTimeZoneInfo = this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)context);
            if (!context.getErrorCollection().hasAnyErrors()) {
                return userTimeZoneInfo.getTimeZoneId();
            }
        }
        context = new JiraServiceContextImpl((ApplicationUser)null);
        TimeZoneInfo defaultTimeZoneInfo = this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)context);
        return defaultTimeZoneInfo.getTimeZoneId();
    }
}

