/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintPickerMatcher;
import com.atlassian.greenhopper.customfield.sprint.SprintResolver;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.atlassian.greenhopper.service.Pages;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.sprint.RemoteSprintLinkService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintQuery;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.util.DateTimeProvider;
import com.atlassian.greenhopper.web.rapid.plan.RankCustomFieldProvider;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class SprintServiceImpl
implements SprintService {
    private static final int SPRINT_NAME_MAX_LENGTH = 30;
    private static final int SPRINT_GOAL_MAX_LENGTH = 1000;
    public static final long DEFAULT_JIRA_AGILE_SPRINT_MAX_DURATION_DAYS = 735L;
    public static final String JIRA_AGILE_SPRINT_MAX_DURATION_DAYS = "jira.agile.sprint.max.duration.days";
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    @Autowired
    private SprintIssueService sprintIssueService;
    @Autowired
    private SprintPermissionService sprintPermissionService;
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private RapidViewSprintQueryService rapidViewSprintQueryService;
    @Autowired
    private RemoteSprintLinkService remoteSprintLinkService;
    @Autowired
    private SprintHelper sprintHelper;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private DateTimeProvider clock;
    @Autowired
    private JiraProperties jiraProperties;
    @Autowired
    private RankCustomFieldProvider rankCustomFieldProvider;

    @Override
    @Nonnull
    public ServiceOutcome<Set<Sprint>> getSprints(@Nullable ApplicationUser user, RapidView rapidView, Set<Long> sprintIds) {
        HashSet<Sprint> sprints = new HashSet<Sprint>();
        for (Long sprintId : sprintIds) {
            ServiceOutcome<Sprint> sprintOutcome = this.getSprint(user, sprintId);
            if (sprintOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(sprintOutcome);
            }
            sprints.add(sprintOutcome.getValue());
        }
        return ServiceOutcomeImpl.ok(sprints);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Page<Sprint>> getSprints(@Nullable ApplicationUser user, RapidView rapidView, PageRequest pageRequest, SprintQuery query) {
        ServiceResult boardValidateOutcome = this.validateBoardSupportsSprints(rapidView);
        if (boardValidateOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(boardValidateOutcome);
        }
        ServiceOutcome<List<Sprint>> sprints = this.rapidViewSprintQueryService.getSprints(user, rapidView, EnumSet.copyOf(query.getStates()), false);
        if (!sprints.isValid()) {
            return ServiceOutcomeImpl.error(sprints);
        }
        return ServiceOutcomeImpl.ok(Pages.toPage((Iterable)sprints.get(), pageRequest, null));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> getSprint(@Nullable ApplicationUser user, Long sprintId) {
        ServiceOutcome<Sprint> sprintOutcome = this.sprintManager.getSprint(sprintId);
        if (sprintOutcome.isInvalid()) {
            return sprintOutcome;
        }
        return this.checkSprintViewPermission(user, sprintOutcome.get());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Set<Sprint>> findSprintsByName(@Nullable ApplicationUser user, String searchQuery, int maxResults, boolean excludeCompleted) {
        SprintResolver sprintResolver = new SprintResolver();
        SprintPickerMatcher searchPredicate = new SprintPickerMatcher(searchQuery, excludeCompleted);
        HashSet matchingSprints = Sets.newHashSet(sprintResolver.findSprintByPredicate(user, false, searchPredicate, maxResults));
        return ServiceOutcomeImpl.ok(matchingSprints);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> createSprint(@Nullable ApplicationUser user, RapidView rapidView, Sprint sprintToCreate, Set<Issue> issues) {
        ServiceResult assignOutcome;
        this.rapidViewService.getRapidView(user, sprintToCreate.getRapidViewId());
        if (!rapidView.getId().equals(sprintToCreate.getRapidViewId())) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.view.difference", new Object[0]);
        }
        ServiceOutcome<Sprint> sprintOutcome = this.createSprint(user, sprintToCreate);
        if (sprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintOutcome);
        }
        Sprint sprint = sprintOutcome.get();
        if (!issues.isEmpty() && (assignOutcome = this.sprintIssueService.moveIssuesToSprint(user, sprint, issues)).isInvalid()) {
            return ServiceOutcomeImpl.error(assignOutcome);
        }
        return ServiceOutcomeImpl.ok(sprint);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> createSprint(@Nullable ApplicationUser user, Sprint sprintToCreate) {
        if (sprintToCreate.getRapidViewId() == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.origin.board.required", new Object[]{sprintToCreate.getState()});
        }
        ServiceResult validateOutcome = this.validateSprintEdit(sprintToCreate);
        if (validateOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(validateOutcome);
        }
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(user, sprintToCreate.getRapidViewId());
        if (rapidViewOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewOutcome);
        }
        RapidView rapidView = rapidViewOutcome.get();
        ServiceResult permissionOutcome = this.sprintPermissionService.canCreateSprint(user, rapidView);
        if (permissionOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(permissionOutcome);
        }
        ServiceResult boardValidateOutcome = this.validateBoardSupportsAddingSprints(user, rapidView);
        if (boardValidateOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(boardValidateOutcome);
        }
        ServiceOutcome<Sprint> sprintOutcome = this.sprintManager.createSprint(sprintToCreate);
        if (sprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintOutcome);
        }
        return ServiceOutcomeImpl.ok(sprintOutcome.get());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> updateSprint(@Nullable ApplicationUser user, Sprint newSprint) {
        ServiceResult logStateChangeOutcome;
        boolean shouldLogStateChange;
        ServiceOutcome<Sprint> updateOutcome;
        ServiceResult canUpdate = this.sprintPermissionService.canUpdateSprint(user, newSprint);
        if (canUpdate.isInvalid()) {
            return ServiceOutcomeImpl.error(canUpdate);
        }
        ServiceOutcome<Sprint> existingSprintOutcome = this.sprintManager.getSprint(newSprint.getId());
        if (existingSprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(existingSprintOutcome);
        }
        Sprint existingSprint = existingSprintOutcome.get();
        ServiceResult validateOutcome = this.validateSprintEdit(newSprint);
        if (validateOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(validateOutcome);
        }
        if (existingSprint.isClosed() && this.isFieldsOtherThanNameAndGoalChanged(newSprint, existingSprint)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rest.validation.sprint.state.update.cannot.update.closed", new Object[0]);
        }
        if (!this.isValidSprintStateTransition(newSprint, existingSprint)) {
            return this.transitionNotSupportedError(newSprint, existingSprint);
        }
        if (existingSprint.isActive() && newSprint.isClosed()) {
            newSprint = Sprint.builder(newSprint).completeDate(this.clock.getCurrentDateTime()).build();
        }
        if ((updateOutcome = this.sprintManager.updateSprint(newSprint)).isInvalid()) {
            return ServiceOutcomeImpl.error(updateOutcome);
        }
        boolean bl = shouldLogStateChange = !newSprint.isFuture() && newSprint.getState() != existingSprint.getState();
        if (shouldLogStateChange && (logStateChangeOutcome = this.logStateChange(user, updateOutcome.get())).isInvalid()) {
            return ServiceOutcomeImpl.error(logStateChangeOutcome);
        }
        return updateOutcome;
    }

    private boolean isFieldsOtherThanNameAndGoalChanged(Sprint newSprint, Sprint existingSprint) {
        return !Objects.equals((Object)newSprint.getState(), (Object)existingSprint.getState()) || !Objects.equals(newSprint.getRapidViewId(), existingSprint.getRapidViewId()) || !Objects.equals(newSprint.getStartDate(), existingSprint.getStartDate()) || !Objects.equals(newSprint.getEndDate(), existingSprint.getEndDate()) || !Objects.equals(newSprint.getCompleteDate(), existingSprint.getCompleteDate());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> reopenSprint(@Nullable ApplicationUser user, @Nonnull Sprint sprint) {
        ServiceOutcome<Sprint> existingSprintOutcome = this.sprintManager.getSprint(sprint.getId());
        if (existingSprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(existingSprintOutcome);
        }
        Sprint existingSprint = existingSprintOutcome.get();
        ServiceResult canUpdate = this.sprintPermissionService.canUpdateSprint(user, existingSprint);
        if (canUpdate.isInvalid()) {
            return ServiceOutcomeImpl.error(canUpdate);
        }
        ServiceOutcome<Iterable<Issue>> issuesForSprint = this.sprintIssueService.getIssuesForSprint(user, existingSprint);
        if (!issuesForSprint.isValid()) {
            return ServiceOutcomeImpl.error(issuesForSprint);
        }
        ArrayList issuesInSprint = Lists.newArrayList(issuesForSprint.get());
        boolean areAllIssuesInAnActiveSprint = issuesInSprint.stream().allMatch(input -> {
            ServiceOutcome<Option<Sprint>> activeSprintForIssue = this.sprintIssueService.getActiveSprintForIssue(user, (Issue)input);
            return activeSprintForIssue.isValid() && activeSprintForIssue.get().isDefined();
        });
        if (areAllIssuesInAnActiveSprint) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.sprint.reopen.no_issues", new Object[0]);
        }
        Sprint newSprint = Sprint.builder(existingSprint).state(Sprint.State.ACTIVE).build();
        ServiceOutcome<Sprint> reopenOutcome = this.sprintManager.updateSprint(newSprint);
        ServiceResult logStateChangeOutcome = this.logStateChange(user, reopenOutcome.get());
        if (logStateChangeOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(logStateChangeOutcome);
        }
        return reopenOutcome;
    }

    private ServiceOutcome<Sprint> transitionNotSupportedError(Sprint sprintInput, Sprint currentSprint) {
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rest.validation.sprint.state.transition.not.supported", currentSprint.getState().toString(), sprintInput.getState().toString());
    }

    private boolean isValidSprintStateTransition(Sprint sprintInput, Sprint sprint) {
        return sprint.getState() == sprintInput.getState() || sprint.isFuture() && sprintInput.isActive() || sprint.isActive() && sprintInput.isClosed();
    }

    @Override
    @Nonnull
    public ServiceResult swapSprints(@Nullable ApplicationUser user, Sprint sprintA, Sprint sprintB) {
        ServiceResult canUpdateSprintA = this.sprintPermissionService.canUpdateSprint(user, sprintA);
        if (canUpdateSprintA.isInvalid()) {
            return canUpdateSprintA;
        }
        ServiceResult canUpdateSprintB = this.sprintPermissionService.canUpdateSprint(user, sprintB);
        if (canUpdateSprintB.isInvalid()) {
            return canUpdateSprintB;
        }
        return this.sprintManager.swapSprints(sprintA, sprintB);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Option<Sprint>> getLastCompletedSprint(@Nullable ApplicationUser user, RapidView rapidView) {
        EnumSet<Sprint.State> statesToSearch = EnumSet.of(Sprint.State.CLOSED);
        ServiceOutcome<List<Sprint>> sprintsResults = this.rapidViewSprintQueryService.getSprints(user, rapidView, statesToSearch, false);
        if (sprintsResults.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintsResults);
        }
        List<Sprint> sprints = sprintsResults.get();
        Collections.sort(sprints, SprintUtils.SPRINT_DESCENDING_COMPARATOR);
        if (sprints.isEmpty()) {
            return ServiceOutcomeImpl.ok(Option.none(Sprint.class));
        }
        return ServiceOutcomeImpl.ok(Option.some((Object)sprints.get(sprints.size() - 1)));
    }

    @Override
    @Nonnull
    public ServiceResult deleteSprint(@Nullable ApplicationUser user, Sprint sprint, @Nullable Long rapidViewId) {
        ServiceOutcome<Iterable<Issue>> maybeRemovedIssues;
        ServiceResult hasPermission = this.sprintPermissionService.canUpdateSprint(user, sprint);
        if (hasPermission.isInvalid()) {
            return hasPermission;
        }
        ServiceResult canSprintBeDeleted = this.canSprintBeDeleted(sprint);
        if (canSprintBeDeleted.isInvalid()) {
            return canSprintBeDeleted;
        }
        ServiceOutcome<Void> deleteSprintOutcome = this.sprintManager.deleteSprint(sprint);
        if (deleteSprintOutcome.isInvalid()) {
            return deleteSprintOutcome;
        }
        RapidView rapidView = null;
        SprintHelper.FutureSprintMapping futureSprintMapping = null;
        if (rapidViewId != null) {
            ServiceOutcome<RapidView> maybeRapidView = this.rapidViewService.getRapidView(user, rapidViewId);
            if (maybeRapidView.isInvalid()) {
                return maybeRapidView;
            }
            rapidView = maybeRapidView.get();
            ServiceOutcome<SprintHelper.FutureSprintMapping> maybeFutureSprintMapping = this.sprintHelper.getFutureSprintMapping(user, rapidView);
            if (maybeFutureSprintMapping.isInvalid()) {
                return maybeFutureSprintMapping;
            }
            futureSprintMapping = maybeFutureSprintMapping.get();
        }
        if ((maybeRemovedIssues = this.sprintIssueService.removeAllIssuesFromSprint(user, sprint)).isInvalid()) {
            return maybeRemovedIssues;
        }
        this.remoteSprintLinkService.removeAllRemoteSprintLinks(user, sprint);
        if (rapidView != null) {
            this.sprintHelper.addToNextFutureSprint(user, rapidView, sprint, (List<Issue>)ImmutableList.copyOf(maybeRemovedIssues.get()), futureSprintMapping);
        }
        return ServiceResultImpl.ok();
    }

    private ServiceResult canSprintBeDeleted(Sprint sprint) {
        return sprint.getState() != Sprint.State.ACTIVE ? ServiceResultImpl.ok() : ServiceResultImpl.validationError("gh.sprint.error.delete.active.sprint", new String[0]);
    }

    private ServiceResult logStateChange(@Nullable ApplicationUser user, Sprint updatedSprint) {
        if (updatedSprint.isFuture()) {
            return ServiceResultImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.sprint.audit.validation.error", new Object[0]);
        }
        return this.sprintManager.logStateChange(updatedSprint, user);
    }

    private ServiceOutcome<Sprint> checkSprintViewPermission(@Nullable ApplicationUser user, Sprint sprint) {
        ServiceOutcome<Boolean> canView = this.sprintPermissionService.canViewSprint(user, sprint);
        if (canView.isInvalid()) {
            return ServiceOutcomeImpl.error(canView);
        }
        if (!canView.get().booleanValue()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.sprint.error.not.found", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(sprint);
    }

    private ServiceResult validateSprintEdit(Sprint sprint) {
        ServiceResult nameOutcome = this.validateSprintName(sprint.getName());
        if (nameOutcome.isInvalid()) {
            return nameOutcome;
        }
        ServiceResult goalOutcome = this.validateSprintGoal(sprint.getGoal());
        if (goalOutcome.isInvalid()) {
            return goalOutcome;
        }
        if (sprint.getState() == null) {
            return ServiceResultImpl.validationError("gh.sprint.error.state.required", new String[0]);
        }
        return this.validateSprintDates(sprint);
    }

    private ServiceResult validateBoardSupportsSprints(RapidView rapidView) {
        if (!rapidView.isSprintSupportEnabled()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.view.does.not.support.sprints", new Object[0]);
        }
        return ServiceResultImpl.ok();
    }

    private ServiceResult validateBoardSupportsAddingSprints(@Nullable ApplicationUser user, RapidView rapidView) {
        ServiceResult boardSupportsSprintsResult = this.validateBoardSupportsSprints(rapidView);
        if (boardSupportsSprintsResult.isInvalid()) {
            return boardSupportsSprintsResult;
        }
        return ServiceResultImpl.ok();
    }

    private ServiceResult validateSprintName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return ServiceResultImpl.error("name", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.name.required", new Object[0]);
        }
        if (name.length() > 30) {
            return ServiceResultImpl.error("name", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.name.too.long", 30);
        }
        return ServiceResultImpl.ok();
    }

    private ServiceResult validateSprintGoal(@Nullable String goal) {
        if (StringUtils.defaultString((String)goal).length() > 1000) {
            return ServiceResultImpl.error("goal", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.goal.too.long", 1000);
        }
        return ServiceResultImpl.ok();
    }

    private ServiceResult validateSprintDates(Sprint sprint) {
        DateTime startDate = sprint.getStartDate();
        DateTime endDate = sprint.getEndDate();
        DateTime completeDate = sprint.getCompleteDate();
        if (startDate != null && endDate != null) {
            if (startDate.compareTo((ReadableInstant)endDate) >= 0) {
                return ServiceResultImpl.error("startDate", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.start.date.before.end.date", new Object[0]);
            }
            long maxSprintDurationDays = this.jiraProperties.getLong(JIRA_AGILE_SPRINT_MAX_DURATION_DAYS, Long.valueOf(735L));
            if ((long)Days.daysBetween((ReadableInstant)startDate, (ReadableInstant)endDate).getDays() > maxSprintDurationDays) {
                this.logger.warn("Sprint duration has exceeded default limit during validation. This can be overwritten by system.property jira.agile.sprint.max.duration.days", new Object[0]);
                return ServiceResultImpl.error("endDate", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.duration.too.long", new Object[0]);
            }
        }
        if (startDate != null && completeDate != null && startDate.compareTo((ReadableInstant)completeDate) > 0) {
            return ServiceResultImpl.error("completeDate", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.start.date.before.complete.date", new Object[0]);
        }
        if (!sprint.isFuture()) {
            if (startDate == null) {
                return ServiceResultImpl.error("startDate", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.start.date.required", new Object[0]);
            }
            if (endDate == null) {
                return ServiceResultImpl.error("endDate", ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.end.date.required", new Object[0]);
            }
        }
        return ServiceResultImpl.ok();
    }
}

