/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.ComposedIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.ProjectsCallback;
import com.atlassian.greenhopper.service.issue.callback.SprintAndProjectsCallback;
import com.atlassian.greenhopper.service.issue.callback.SprintIdCallback;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.ConditionBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintQueryServiceImpl
implements SprintQueryService {
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private ProjectManager projectManager;

    @Override
    @Nonnull
    public ServiceOutcome<List<Sprint>> getSprints(ApplicationUser user, Query jql) {
        return this.getSprints(user, jql, false);
    }

    @Override
    @Nonnull
    public ServiceOutcome<List<Sprint>> getSprints(ApplicationUser user, Query jql, boolean includeHistoricSprints) {
        SprintIdCallback callback = new SprintIdCallback(this.sprintCustomFieldService.getDefaultSprintField(), includeHistoricSprints);
        ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, jql, callback);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        Collection<Sprint> sprintCollection = SprintUtils.getSprintsForIds(this.sprintManager, callback.getSprintIds());
        ArrayList sprints = Lists.newArrayList(sprintCollection);
        Collections.sort(sprints, SprintUtils.SPRINT_BYDATE_COMPARATOR);
        return ServiceOutcomeImpl.ok(sprints);
    }

    private ServiceOutcome<Pair<List<Sprint>, Set<Long>>> getSprintsAndProjectIds(ApplicationUser user, Query jql) {
        SprintIdCallback sprintsCallback = new SprintIdCallback(this.sprintCustomFieldService.getDefaultSprintField(), false);
        ProjectsCallback projectsCallback = new ProjectsCallback();
        ComposedIssueDataCallback compoundCallback = ComposedIssueDataCallback.of((IssueDataCallback[])new AbstractIssueDataCallback[]{sprintsCallback, projectsCallback});
        ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, jql, compoundCallback);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        Collection<Sprint> sprintsCollection = SprintUtils.getSprintsForIds(this.sprintManager, sprintsCallback.getSprintIds());
        ArrayList sprints = Lists.newArrayList(sprintsCollection);
        Collections.sort(sprints, SprintUtils.SPRINT_BYDATE_COMPARATOR);
        ServiceOutcome<Set<Long>> projectIds = this.convertStringsIdsToLongs(projectsCallback.getProjectIds());
        if (!projectIds.isValid()) {
            return ServiceOutcomeImpl.error(projectIds);
        }
        return ServiceOutcomeImpl.ok(new Pair((Object)sprints, projectIds.getValue()));
    }

    protected ServiceOutcome<Set<Long>> convertStringsIdsToLongs(Set<String> projectIds) {
        try {
            return ServiceOutcomeImpl.ok(Sets.newHashSet((Iterable)Iterables.transform(projectIds, (Function)new Function<String, Long>(){

                public Long apply(@Nullable String s) {
                    return Long.valueOf(s);
                }
            })));
        }
        catch (NumberFormatException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public ServiceOutcome<Pair<List<Sprint>, Set<Long>>> getOpenSprintsAndBacklogProjects(ApplicationUser user, Query jql) {
        ServiceOutcome<Pair<List<Sprint>, Set<Long>>> sprintsAndProjectIds = this.getSprintsAndProjectIds(user, jql);
        if (!sprintsAndProjectIds.isValid()) {
            return sprintsAndProjectIds;
        }
        LinkedList<Sprint> openSprints = new LinkedList<Sprint>();
        for (Sprint sprint : (List)sprintsAndProjectIds.getValue().left()) {
            if (sprint.getState() != Sprint.State.ACTIVE) continue;
            openSprints.add(sprint);
        }
        return ServiceOutcomeImpl.ok(new Pair(openSprints, sprintsAndProjectIds.getValue().right()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<List<Sprint>> getClosedSprints(ApplicationUser user, Query jql) {
        ServiceOutcome<List<Sprint>> sprints = this.getSprints(user, jql, true);
        if (!sprints.isValid()) {
            return sprints;
        }
        LinkedList<Sprint> closedSprints = new LinkedList<Sprint>();
        for (Sprint sprint : sprints.getValue()) {
            if (sprint.getState() != Sprint.State.CLOSED) continue;
            closedSprints.add(sprint);
        }
        return ServiceOutcomeImpl.ok(closedSprints);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Set<Project>> getProjects(ApplicationUser user, Sprint sprint) {
        return this.getProjectsImpl(user, sprint, false);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Set<Project>> getProjectsOverrideSecurity(ApplicationUser user, Sprint sprint) {
        return this.getProjectsImpl(user, sprint, true);
    }

    @Nonnull
    private ServiceOutcome<Set<Project>> getProjectsImpl(ApplicationUser user, Sprint sprint, boolean overrideSecurity) {
        ProjectsCallback callback;
        Query query = JqlQueryBuilder.newBuilder().where().defaultAnd().addClause(this.getSprintClause(sprint)).endWhere().orderBy().clear().endOrderBy().buildQuery();
        ServiceOutcome<Void> outcome = this.issueDataService.findOverrideSecurity(user, query, callback = new ProjectsCallback());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.from(outcome.getErrors());
        }
        HashSet<Project> projects = new HashSet<Project>();
        for (String projectIdString : callback.getProjectIds()) {
            Long projectId = null;
            try {
                projectId = Long.parseLong(projectIdString);
            }
            catch (NumberFormatException nfe) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Unable to parse project id: " + projectIdString, new Object[0]);
            }
            Project project = this.projectManager.getProjectObj(projectId);
            if (project == null) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "Could not locate project with id: " + projectId, new Object[0]);
            }
            projects.add(project);
        }
        return ServiceOutcomeImpl.ok(projects);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Map<Sprint, Set<Project>>> getProjects(ApplicationUser user, List<Sprint> sprints) {
        return this.getProjectsImpl(user, sprints, false);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Map<Sprint, Set<Project>>> getProjectsOverrideSecurity(ApplicationUser user, List<Sprint> sprints) {
        return this.getProjectsImpl(user, sprints, true);
    }

    private ServiceOutcome<Map<Sprint, Set<Project>>> getProjectsImpl(ApplicationUser user, List<Sprint> sprints, boolean overrideSecurity) {
        Query sprintsQuery = JqlQueryBuilder.newBuilder().where().addClause(this.getSprintsClause(sprints)).endWhere().orderBy().clear().buildQuery();
        SprintAndProjectsCallback callback = new SprintAndProjectsCallback(this.sprintCustomFieldService.getDefaultSprintField());
        ServiceOutcome<Void> findOutcome = null;
        findOutcome = overrideSecurity ? this.issueDataService.findOverrideSecurity(user, sprintsQuery, callback) : this.issueDataService.findWithServiceOutcome(user, sprintsQuery, callback);
        if (!findOutcome.isValid()) {
            return ServiceOutcomeImpl.error(findOutcome);
        }
        return this.convertCallback(callback.getSprintToProjects());
    }

    private ServiceOutcome<Map<Sprint, Set<Project>>> convertCallback(Map<String, Set<String>> sprintToProjects) {
        HashMap<String, Project> stringToProjectMap = new HashMap<String, Project>();
        HashMap result = new HashMap();
        for (Map.Entry<String, Set<String>> sprintAndProject : sprintToProjects.entrySet()) {
            long sprintId;
            try {
                sprintId = Long.parseLong(sprintAndProject.getKey());
            }
            catch (NumberFormatException e) {
                continue;
            }
            ServiceOutcome<Sprint> sprint = this.sprintManager.getSprint(sprintId);
            if (!sprint.isValid()) {
                return ServiceOutcomeImpl.error(sprint);
            }
            HashSet<Project> projects = new HashSet<Project>();
            for (String projectIdString : sprintAndProject.getValue()) {
                Project project = (Project)stringToProjectMap.get(projectIdString);
                if (project == null) {
                    long projectId;
                    try {
                        projectId = Long.parseLong(projectIdString);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    project = this.projectManager.getProjectObj(Long.valueOf(projectId));
                    stringToProjectMap.put(projectIdString, project);
                }
                if (project == null) continue;
                projects.add(project);
            }
            result.put(sprint.getValue(), projects);
        }
        return ServiceOutcomeImpl.ok(result);
    }

    @Override
    public Clause getInOpenSprintClause() {
        return this.sprintFieldClause().in().function("openSprints").buildClause();
    }

    @Override
    public Clause getNotInOpenSprintClause() {
        return this.sprintFieldClause().notIn().function("openSprints").buildClause();
    }

    @Override
    public Clause getInSprintClause() {
        return this.sprintFieldClause().isNotEmpty().buildClause();
    }

    @Override
    public Clause getNotInSprint() {
        return this.sprintFieldClause().isEmpty().buildClause();
    }

    @Override
    public Clause getSprintClause(Sprint sprint) {
        return this.sprintFieldClause().eq(sprint.getId()).buildClause();
    }

    @Override
    public Clause getSprintsClause(Collection<Sprint> sprints) {
        HashSet<Long> sprintIds = new HashSet<Long>();
        for (Sprint sprint : sprints) {
            sprintIds.add(sprint.getId());
        }
        return this.sprintFieldClause().in(sprintIds.toArray(new Long[sprintIds.size()])).buildClause();
    }

    @Override
    public Clause getNotInFutureSprintClause() {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.where().defaultOr().sub().addClause(this.sprintFieldClause().isEmpty().buildClause()).addClause(this.sprintFieldClause().notInFunc("futureSprints").buildClause()).endsub();
        return queryBuilder.buildQuery().getWhereClause();
    }

    private ConditionBuilder sprintFieldClause() {
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        return JqlQueryBuilder.newClauseBuilder().defaultAnd().customField(defaultSprintField.getIdAsLong());
    }
}

