/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintPropertyService;
import com.atlassian.greenhopper.service.sprint.event.SprintPropertyDeletedEvent;
import com.atlassian.greenhopper.service.sprint.event.SprintPropertySetEvent;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintPropertyHelper
implements EntityPropertyHelper<Sprint> {
    private final SprintPermissionService sprintPermissionService;
    private final SprintManager sprintManager;
    private final ErrorCollectionTransformer errorCollectionTransformer;

    @Autowired
    public SprintPropertyHelper(SprintPermissionService sprintPermissionService, SprintManager sprintManager, ErrorCollectionTransformer errorCollectionTransformer) {
        this.sprintPermissionService = sprintPermissionService;
        this.sprintManager = sprintManager;
        this.errorCollectionTransformer = errorCollectionTransformer;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Sprint> hasEditPermissionFunction() {
        return (user, sprint) -> this.serviceResultToErrorCollection(this.sprintPermissionService.canUpdateSprint((ApplicationUser)user, (Sprint)sprint));
    }

    public EntityPropertyHelper.CheckPermissionFunction<Sprint> hasReadPermissionFunction() {
        return (user, sprint) -> this.serviceResultToErrorCollection(this.sprintPermissionService.canViewSprint((ApplicationUser)user, (Sprint)sprint));
    }

    public Function<Long, Option<Sprint>> getEntityByIdFunction() {
        return sprintId -> {
            ServiceOutcome<Sprint> sprint = this.sprintManager.getSprint((long)sprintId);
            return sprint.isValid() ? Option.option((Object)sprint.get()) : Option.none();
        };
    }

    public BiFunction<ApplicationUser, EntityProperty, SprintPropertySetEvent> createSetPropertyEventBiFunction() {
        return (user, property) -> new SprintPropertySetEvent((EntityProperty)property, (ApplicationUser)user);
    }

    public BiFunction<ApplicationUser, EntityProperty, SprintPropertyDeletedEvent> createDeletePropertyEventBiFunction() {
        return (user, property) -> new SprintPropertyDeletedEvent((EntityProperty)property, (ApplicationUser)user);
    }

    public EntityPropertyType getEntityPropertyType() {
        return SprintPropertyService.SPRINT_ENTITY_PROPERTY_TYPE;
    }

    private ErrorCollection serviceResultToErrorCollection(ServiceResult serviceResult) {
        if (serviceResult.isValid()) {
            return new SimpleErrorCollection();
        }
        return this.errorCollectionTransformer.toJiraErrorCollection(serviceResult.getErrors());
    }
}

