/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

public class SprintProgress {
    private Map<String, Double> estimateByColumn = Maps.newLinkedHashMap();

    public SprintProgress(Collection<String> columnNames) {
        for (String columnName : columnNames) {
            this.estimateByColumn.put(columnName, 0.0);
        }
    }

    public void incrementColumnEstimate(String columnName, Double estimateToAdd) {
        if (this.estimateByColumn.containsKey(columnName)) {
            Double estimateSum = this.estimateByColumn.get(columnName);
            estimateSum = estimateSum + estimateToAdd;
            estimateSum = Math.floor(estimateSum * 10.0) / 10.0;
            this.estimateByColumn.put(columnName, estimateSum);
        }
    }

    public Map<String, Double> getEstimateByColumn() {
        return this.estimateByColumn;
    }
}

