/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.jira.permission.GHProjectPermissions;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintPermissionServiceImpl
implements SprintPermissionService {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private SprintQueryService sprintQueryService;
    @Autowired
    private SearchService jiraSearchService;
    @Autowired
    private QueryService queryService;
    @Autowired
    private ProjectManager projectManager;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;

    @Override
    @Nonnull
    public ServiceOutcome<Boolean> canViewSprint(ApplicationUser user, Sprint sprint) {
        ServiceOutcome<RapidView> rapidView;
        if (this.permissionService.isJiraAdministrator(user)) {
            return ServiceOutcomeImpl.ok(true);
        }
        if (sprint.getRapidViewId() != null && (rapidView = this.rapidViewService.getRapidView(user, sprint.getRapidViewId())).isValid()) {
            return ServiceOutcomeImpl.ok(true);
        }
        ServiceOutcome<Long> issueCount = this.getIssueCountForSprint(user, sprint);
        if (!issueCount.isValid()) {
            return ServiceOutcomeImpl.from(issueCount.getErrors());
        }
        boolean canView = issueCount.get() > 0L;
        return ServiceOutcomeImpl.ok(canView);
    }

    @Override
    @Nonnull
    public ServiceResult canCreateSprint(ApplicationUser user, RapidView rapidView) {
        if (this.permissionService.isJiraAdministrator(user)) {
            return ServiceResultImpl.ok();
        }
        return this.validateManageSprintsPermissionInBoard(user, rapidView, "gh.sprint.create.no.permission");
    }

    @Override
    @Nonnull
    public ServiceResult canUpdateSprint(ApplicationUser user, Sprint sprint) {
        if (this.permissionService.isJiraAdministrator(user)) {
            return ServiceResultImpl.ok();
        }
        ServiceOutcome<RapidView> outcome = this.rapidViewService.getRapidView(user, sprint.getRapidViewId());
        RapidView rapidView = outcome.getValue();
        if (rapidView != null) {
            return this.validateManageSprintsPermissionInBoard(user, rapidView, "gh.sprint.update.no.permission");
        }
        return this.validateManageSprintsPermissionInSprint(user, sprint, "gh.sprint.update.no.permission");
    }

    @Override
    @Nonnull
    public ServiceOutcome<Map<Sprint, Boolean>> canUpdateSprints(ApplicationUser user, List<Sprint> sprints) {
        HashMap<Sprint, Boolean> permissions = new HashMap<Sprint, Boolean>();
        for (Sprint sprint : sprints) {
            permissions.put(sprint, this.canUpdateSprint(user, sprint).isValid());
        }
        return ServiceOutcomeImpl.ok(permissions);
    }

    @Override
    @Nonnull
    public ServiceResult canAddRemoveIssuesToSprint(ApplicationUser user, Iterable<Issue> issues) {
        Issue issue;
        boolean checkFailed = false;
        Iterator<Issue> iterator = issues.iterator();
        while (iterator.hasNext() && !(checkFailed = !this.permissionService.hasPermission(user, issue = iterator.next(), 28))) {
        }
        if (checkFailed) {
            return ServiceResultImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.sprint.issue.edit.no.permission", new Object[0]);
        }
        return ServiceResultImpl.ok();
    }

    @Override
    public boolean hasManageSprintsPermission(ApplicationUser user, RapidView rapidView) {
        return this.permissionService.isJiraAdministrator(user) || this.validateManageSprintsPermissionInBoard(user, rapidView, "").isValid();
    }

    private ServiceResult validateManageSprintsPermissionInBoard(ApplicationUser user, RapidView rapidView, String validationMsgKey) {
        ServiceOutcome<Set<Project>> boardFilterProjects = this.queryService.getProjectsForRapidViewFilterQuery(user, rapidView);
        if (!boardFilterProjects.isValid()) {
            return ServiceOutcomeImpl.error(boardFilterProjects);
        }
        ImmutableSet projects = boardFilterProjects.getValue();
        if (CollectionUtils.isEmpty(projects)) {
            projects = ImmutableSet.copyOf((Collection)this.projectManager.getProjectObjects());
        }
        if (this.hasManageSprintsPermissionInAllProjects(user, (Set<Project>)projects)) {
            return ServiceResultImpl.ok();
        }
        String projectNames = this.getProjectNamesString(user, (Set<Project>)projects);
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, validationMsgKey, projectNames);
    }

    private ServiceResult validateManageSprintsPermissionInSprint(ApplicationUser user, Sprint sprint, String validationMsgKey) {
        ServiceOutcome<Set<Project>> projectsForSprint = this.sprintQueryService.getProjectsOverrideSecurity(user, sprint);
        if (projectsForSprint.isInvalid()) {
            return ServiceOutcomeImpl.error(projectsForSprint);
        }
        Set<Project> projects = projectsForSprint.get();
        if (this.hasManageSprintsPermissionInAllProjects(user, projects)) {
            return ServiceResultImpl.ok();
        }
        String projectNames = this.getProjectNamesString(user, projects);
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, validationMsgKey, projectNames);
    }

    private ServiceOutcome<Long> getIssueCountForSprint(ApplicationUser user, Sprint sprint) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.where().defaultAnd().addClause(this.sprintQueryService.getSprintClause(sprint));
        try {
            long totalCount = this.jiraSearchService.searchCount(user, queryBuilder.buildQuery());
            return ServiceOutcomeImpl.ok(totalCount);
        }
        catch (SearchException e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, e.getMessage(), new Object[0]);
        }
    }

    private String getProjectNamesString(ApplicationUser user, Set<Project> projects) {
        StringBuilder sb = new StringBuilder();
        for (Project project : projects) {
            if (this.permissionService.hasPermission(user, project, 10)) {
                sb.append(project.getName()).append(", ");
                continue;
            }
            sb.append(project.getId()).append(", ");
        }
        String projectNames = sb.toString();
        projectNames = projectNames.substring(0, projectNames.length() - 2);
        return projectNames;
    }

    private boolean hasManageSprintsPermissionInAllProjects(ApplicationUser user, Set<Project> projects) {
        return projects.stream().allMatch(project -> this.permissionManager.hasPermission(GHProjectPermissions.MANAGE_SPRINTS, project, user));
    }
}

