/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.events.sprint.SprintEventPublisher;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.audit.AuditEntryManager;
import com.atlassian.greenhopper.model.rapid.AuditEntry;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintAO;
import com.atlassian.greenhopper.service.sprint.SprintAOMapper;
import com.atlassian.greenhopper.service.sprint.SprintDao;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPropertyService;
import com.atlassian.greenhopper.service.sprint.SprintStateAuditEntry;
import com.atlassian.greenhopper.service.sprint.SprintStateAuditEntryComparator;
import com.atlassian.greenhopper.service.sprint.SprintStateAuditLog;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.web.rapid.GHJSONMarshaller;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import net.java.ao.RawEntity;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintManagerImpl
implements SprintManager {
    private static final LoggerWrapper log = LoggerWrapper.with(SprintManagerImpl.class);
    public static final String SPRINT_AUDIT_LOG_TYPE = "SPRINT";
    @Autowired
    private SprintDao sprintDao;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    @Autowired
    private AuditEntryManager auditEntryManager;
    @Autowired
    private ClusterLockService clusterLockService;
    @Autowired
    private JsonEntityPropertyManager jsonEntityPropertyManager;
    @Autowired
    private SprintEventPublisher sprintEventPublisher;
    private SprintAOMapper sprintAOMapper;
    private GHJSONMarshaller ghjsonMarshaller;
    private CachedReference<Map<Long, Sprint>> cache;

    @PostConstruct
    public void init() {
        CacheSettings settings = new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(1000000).build();
        this.cache = this.cacheFactoryManager.create().getCachedReference(SprintManagerImpl.class, SprintManagerImpl.class.getName() + ".sprintCache", new SprintCacheSupplier(), settings);
    }

    @Autowired
    @VisibleForTesting
    void setSprintAOMapper(SprintAOMapper sprintAOMapper) {
        this.sprintAOMapper = sprintAOMapper;
    }

    @Autowired
    @VisibleForTesting
    void setGhjsonMarshaller(GHJSONMarshaller ghjsonMarshaller) {
        this.ghjsonMarshaller = ghjsonMarshaller;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> getSprint(long id) {
        Sprint sprint = this.cache.get().get(id);
        if (sprint == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.sprint.error.not.found", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(sprint);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Collection<Sprint>> getAllSprints() {
        return ServiceOutcomeImpl.ok(this.cache.get().values());
    }

    @Override
    @Nonnull
    public ServiceOutcome<Collection<Sprint>> getSprints(EnumSet<Sprint.State> states) {
        Predicate<Sprint> statesPredicate = SprintUtils.getStatesPredicate(states);
        ServiceOutcome<Collection<Sprint>> allSprints = this.getAllSprints();
        if (allSprints.isInvalid()) {
            return allSprints;
        }
        return ServiceOutcomeImpl.ok(Lists.newArrayList((Iterable)Iterables.filter((Iterable)allSprints.getValue(), statesPredicate)));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Collection<Sprint>> getSprintsForView(RapidView rapidView) {
        ServiceOutcome<Collection<Sprint>> allSprints = this.getAllSprints();
        if (allSprints.isInvalid()) {
            return allSprints;
        }
        return ServiceOutcomeImpl.ok(Lists.newArrayList((Iterable)Iterables.filter((Iterable)allSprints.getValue(), (Predicate)new RapidViewPredicate(rapidView.getId()))));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Collection<Sprint>> getSprintsForView(Long rapidViewId, EnumSet<Sprint.State> states) {
        Predicate<Sprint> statesPredicate = SprintUtils.getStatesPredicate(states);
        ServiceOutcome<Collection<Sprint>> allSprints = this.getAllSprints();
        if (allSprints.isInvalid()) {
            return allSprints;
        }
        return ServiceOutcomeImpl.ok(Lists.newArrayList((Iterable)Iterables.filter((Iterable)allSprints.getValue(), (Predicate)Predicates.and(statesPredicate, (Predicate)new RapidViewPredicate(rapidViewId)))));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> createSprint(Sprint sprint) {
        return this.createSprint(this.sprintAOMapper.toAO(sprint));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> createSprint(Map<String, Object> fields) {
        SprintAO sprintAO = (SprintAO)this.sprintDao.create(fields);
        if (sprintAO == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.error.can.not.create", "sprint");
        }
        this.cache.reset();
        Sprint newSprint = this.cache.get().get(sprintAO.getId());
        if (newSprint == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.sprint.ao.failure", new Object[0]);
        }
        this.sprintEventPublisher.publishSprintCreated(newSprint);
        return ServiceOutcomeImpl.ok(newSprint);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Sprint> updateSprint(Sprint sprint) {
        NonSequenceUpdate partialUpdate = new NonSequenceUpdate();
        return this.updateSprint(sprint, partialUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public ServiceOutcome<Void> swapSprints(@Nonnull Sprint sprintA, @Nonnull Sprint sprintB) {
        if (sprintA.equals(sprintB)) {
            return ServiceOutcomeImpl.ok();
        }
        ClusterLock lock = this.clusterLockService.getLockForName(SprintManagerImpl.class.getName());
        log.trace("Testing lock for swapping sprints", new Object[0]);
        try {
            if (!lock.tryLock(5L, TimeUnit.SECONDS)) return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.api.sprint.error.swap.retrytimeout", new Object[0]);
            ServiceOutcome<Sprint> sprintAOutcome = this.getSprint(sprintA.getId());
            if (sprintAOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(sprintAOutcome);
            }
            sprintA = sprintAOutcome.getValue();
            ServiceOutcome<Sprint> sprintBOutcome = this.getSprint(sprintB.getId());
            if (sprintBOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(sprintBOutcome);
            }
            sprintB = sprintBOutcome.getValue();
            log.debug("Attempting sprint swap of %s and %s", SprintManagerImpl.formatSprint(sprintA), SprintManagerImpl.formatSprint(sprintB));
            try {
                Long sequenceA = this.sprintAOMapper.getSequence(sprintA);
                Long sequenceB = this.sprintAOMapper.getSequence(sprintB);
                if (sequenceA.equals(sequenceB)) {
                    log.warn("%s and %s have the same sequence number. This will cause incorrect behaviour and should be fixed manually in the database.", SprintManagerImpl.formatSprint(sprintA), SprintManagerImpl.formatSprint(sprintB));
                    ServiceOutcome<Void> serviceOutcome = ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.api.sprint.error.swap.duplicate.sequence", new Object[0]);
                    return serviceOutcome;
                }
                ArrayList sprintsToUpdate = Lists.newArrayList((Object[])new Sprint[]{Sprint.builder(sprintA).sequence(sequenceB).build(), Sprint.builder(sprintB).sequence(sequenceA).build()});
                ArrayList results = Lists.newArrayList();
                SequenceUpdate partialUpdate = new SequenceUpdate();
                for (Sprint sprint : sprintsToUpdate) {
                    ServiceOutcome<Sprint> outcome = this.updateSprint(sprint, partialUpdate);
                    if (outcome.isInvalid()) {
                        log.warn("Update of %s failed during sprint swap operation. This may cause data inconsistencies.", SprintManagerImpl.formatSprint(sprint));
                        ServiceOutcome<Void> serviceOutcome = ServiceOutcomeImpl.error(outcome);
                        return serviceOutcome;
                    }
                    results.add(outcome.getValue());
                }
                log.debug("Sprint swap successful: %s and %s", SprintManagerImpl.formatSprint((Sprint)results.get(0)), SprintManagerImpl.formatSprint((Sprint)results.get(1)));
                ServiceOutcome serviceOutcome = ServiceOutcomeImpl.ok();
                return serviceOutcome;
            }
            finally {
                log.trace("Unlocking lock for swapping sprints", new Object[0]);
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.CONFLICT, "gh.api.sprint.error.swap.retrytimeout", new Object[0]);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> logStateChange(Sprint updatedSprint, ApplicationUser user) {
        SprintStateAuditEntry auditEntryData = new SprintStateAuditEntry();
        if (updatedSprint.isClosed()) {
            auditEntryData.setOperation(SprintStateAuditEntry.Operation.CLOSE);
        } else {
            auditEntryData.setOperation(SprintStateAuditEntry.Operation.OPEN);
            ServiceOutcome<SprintStateAuditLog> serviceOutcome = this.getSprintStateAuditLog(updatedSprint);
        }
        String userKey = user == null ? null : ApplicationUsers.getKeyFor((ApplicationUser)user);
        AuditEntry auditEntry = AuditEntry.builder().user(userKey).entityId(updatedSprint.getId()).entityType(SPRINT_AUDIT_LOG_TYPE).category("SprintOpenClose").time(DateTime.now()).data(this.ghjsonMarshaller.marshalToJSON(auditEntryData)).build();
        this.auditEntryManager.save(auditEntry);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    @Nonnull
    public ServiceOutcome<SprintStateAuditLog> getSprintStateAuditLog(Sprint sprint) {
        List<AuditEntry> auditEntryList = this.auditEntryManager.getByEntityIdEntityClassAndCategory(sprint.getId(), SPRINT_AUDIT_LOG_TYPE, "SprintOpenClose");
        TreeSet auditEntrySortedSet = Sets.newTreeSet((Comparator)SprintStateAuditEntryComparator.getInstance());
        auditEntrySortedSet.addAll(auditEntryList);
        AuditEntry mostRecentAuditEntry = null;
        if (!auditEntrySortedSet.isEmpty()) {
            mostRecentAuditEntry = (AuditEntry)auditEntrySortedSet.last();
        }
        SprintStateAuditLog sprintStateAuditLog = SprintStateAuditLog.builder().sortedAuditEntries(auditEntrySortedSet).lastChangingUser(mostRecentAuditEntry != null ? mostRecentAuditEntry.getUser() : null).build();
        return ServiceOutcomeImpl.ok(sprintStateAuditLog);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> deleteSprint(Sprint sprint) {
        this.sprintDao.delete(sprint.getId());
        this.jsonEntityPropertyManager.deleteByEntity(SprintPropertyService.SPRINT_ENTITY_PROPERTY_TYPE.getDbEntityName(), sprint.getId());
        this.cache.reset();
        this.sprintEventPublisher.publishSprintDeleted(sprint);
        return ServiceOutcomeImpl.ok();
    }

    @Override
    public void flushCache() {
        this.cache.reset();
    }

    private ServiceOutcome<Sprint> updateSprint(Sprint sprint, PartialUpdate partialUpdate) {
        Long sprintId = sprint.getId();
        ServiceOutcome existing = this.sprintDao.load(sprintId);
        if (!existing.isValid()) {
            return ServiceOutcomeImpl.error(existing);
        }
        Sprint existingSprint = this.sprintAOMapper.toModel((SprintAO)existing.getValue());
        this.sprintDao.flushAll();
        partialUpdate.apply(sprint, (SprintAO)existing.getValue());
        this.sprintDao.save((RawEntity)existing.getValue());
        this.cache.reset();
        ServiceOutcome<Sprint> newSprintOutcome = this.getSprint(sprintId);
        if (newSprintOutcome.isValid()) {
            this.sprintEventPublisher.publishUpdateEvents(existingSprint, newSprintOutcome.get());
        }
        return newSprintOutcome;
    }

    private static String formatSprint(Sprint sprint) {
        return String.format("Sprint[id=%d,name=%s,seq=%d]", sprint.getId(), sprint.getName(), sprint.getSequence());
    }

    private final class NonSequenceUpdate
    implements PartialUpdate {
        private NonSequenceUpdate() {
        }

        @Override
        public void apply(Sprint source, SprintAO target) {
            SprintManagerImpl.this.sprintAOMapper.update(source, target);
        }
    }

    private final class SequenceUpdate
    implements PartialUpdate {
        private SequenceUpdate() {
        }

        @Override
        public void apply(Sprint source, SprintAO target) {
            SprintManagerImpl.this.sprintAOMapper.updateSequence(source, target);
        }
    }

    private static interface PartialUpdate {
        public void apply(Sprint var1, SprintAO var2);
    }

    private class SprintCacheSupplier
    implements Supplier<Map<Long, Sprint>> {
        private SprintCacheSupplier() {
        }

        @Override
        public Map<Long, Sprint> get() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            SprintManagerImpl.this.sprintDao.loadAll(sprintAO -> {
                Sprint sprint = SprintManagerImpl.this.sprintAOMapper.toModel((SprintAO)sprintAO);
                builder.put((Object)sprint.getId(), (Object)sprint);
            });
            return builder.build();
        }
    }

    private static class RapidViewPredicate
    implements Predicate<Sprint> {
        private final Long rapidViewId;

        private RapidViewPredicate(Long rapidViewId) {
            this.rapidViewId = rapidViewId;
        }

        public boolean apply(Sprint input) {
            return this.rapidViewId != null && this.rapidViewId.equals(input.getRapidViewId());
        }
    }
}

