/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.web.rapid.sprint.SprintStatusChangeHelper;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class SprintIssueServiceImpl
implements SprintIssueService {
    @Autowired
    private IssueUpdateService issueUpdateService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private IssueIndexManager issueIndexManager;
    @Autowired
    private SprintPermissionService sprintPermissionService;
    @Autowired
    private SprintStatusChangeHelper sprintHelper;
    @Autowired
    private SprintManager sprintManager;
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());

    @Override
    @Nonnull
    public ServiceResult moveIssuesToBacklog(@Nullable ApplicationUser user, Collection<Issue> issues) {
        ServiceResult permissionCheck = this.sprintPermissionService.canAddRemoveIssuesToSprint(user, issues);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        List<Issue> parentIssues = this.getParentIssuesFromIssues(issues);
        return this.updateIssuesInSprint(user, parentIssues, (Function<Pair<Issue, CustomField>, IssueInputParameters>)((Function)input -> {
            List<Sprint> existingSprints = this.getExistingSprints((Issue)input.first(), (CustomField)input.second());
            ArrayList closedSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, SprintUtils.SPRINT_CLOSED));
            return this.convertSprintToParameters((CustomField)input.second(), closedSprints);
        }));
    }

    @Override
    @Nonnull
    public ServiceResult moveIssuesToSprint(@Nullable ApplicationUser user, Sprint sprint, Collection<Issue> issues) {
        if (sprint.getState().equals((Object)Sprint.State.CLOSED)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.sprint.closed", new Object[0]);
        }
        ServiceResult permissionCheck = this.sprintPermissionService.canAddRemoveIssuesToSprint(user, issues);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        List<Issue> parentIssues = this.getParentIssuesFromIssues(issues);
        return this.updateIssuesInSprint(user, parentIssues, (Function<Pair<Issue, CustomField>, IssueInputParameters>)((Function)input -> {
            List<Sprint> existingSprints = this.getExistingSprints((Issue)input.first(), (CustomField)input.second());
            ArrayList updatedSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, SprintUtils.SPRINT_CLOSED));
            updatedSprints.add(sprint);
            return this.convertSprintToParameters((CustomField)input.second(), updatedSprints);
        }));
    }

    @Override
    @Nonnull
    public ServiceResult moveIncompleteIssuesBackToReopenedSprint(@Nullable ApplicationUser user, @Nonnull Sprint sprint, @Nonnull Collection<Issue> issues) {
        ServiceResult permissionCheck = this.sprintPermissionService.canAddRemoveIssuesToSprint(user, issues);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        List<Issue> parentIssues = this.getParentIssuesFromIssues(issues);
        return this.updateIssuesInSprint(user, parentIssues, (Function<Pair<Issue, CustomField>, IssueInputParameters>)((Function)input -> {
            ArrayList existingSprints = this.getExistingSprints((Issue)input.first(), (CustomField)input.second());
            ArrayList activeSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, (Predicate)Predicates.and(SprintUtils.SPRINT_ACTIVE, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)sprint)))));
            if (activeSprints.size() == 0) {
                ArrayList updatedSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, SprintUtils.SPRINT_CLOSED));
                updatedSprints.add(sprint);
                return this.convertSprintToParameters((CustomField)input.second(), updatedSprints);
            }
            existingSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)sprint))));
            return this.convertSprintToParameters((CustomField)input.second(), existingSprints);
        }));
    }

    @Override
    @Nonnull
    public ServiceResult moveCompleteIssuesBackToReopenedSprint(@Nullable ApplicationUser user, @Nonnull Sprint sprint, @Nonnull Collection<Issue> issues) {
        ServiceResult permissionCheck = this.sprintPermissionService.canAddRemoveIssuesToSprint(user, issues);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        List<Issue> parentIssues = this.getParentIssuesFromIssues(issues);
        Function updateFunction = input -> {
            boolean issueIsNotCompletedInAnotherSprint;
            Issue issue = (Issue)input.first();
            CustomField field = (CustomField)input.second();
            ArrayList existingSprints = this.getExistingSprints(issue, field);
            ArrayList activeSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, (Predicate)Predicates.and(SprintUtils.SPRINT_ACTIVE, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)sprint)))));
            boolean issueIsCurrentlyNotInAnyActiveSprint = CollectionUtils.isEmpty((Collection)activeSprints);
            boolean bl = issueIsNotCompletedInAnotherSprint = !this.sprintHelper.wasIssueCompletedInAnotherSprint(sprint, issue);
            if (issueIsCurrentlyNotInAnyActiveSprint && issueIsNotCompletedInAnotherSprint) {
                ArrayList updatedSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, SprintUtils.SPRINT_CLOSED));
                updatedSprints.add(sprint);
                return this.convertSprintToParameters(field, updatedSprints);
            }
            existingSprints = Lists.newArrayList((Iterable)Iterables.filter(existingSprints, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)sprint))));
            return this.convertSprintToParameters(field, existingSprints);
        };
        return this.updateIssuesInSprint(user, parentIssues, (Function<Pair<Issue, CustomField>, IssueInputParameters>)updateFunction, false);
    }

    @Override
    @Nonnull
    public ServiceResult removeIssuesFromSprint(@Nullable ApplicationUser user, Sprint sprint, Collection<Issue> issues) {
        if (!this.canBulkRemoveIssues(sprint)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.sprint.closed", new Object[0]);
        }
        ServiceResult permissionCheck = this.sprintPermissionService.canAddRemoveIssuesToSprint(user, issues);
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        List<Issue> parentIssues = this.getParentIssuesFromIssues(issues);
        return this.updateIssuesInSprint(user, parentIssues, (Function<Pair<Issue, CustomField>, IssueInputParameters>)((Function)input -> {
            List<Sprint> existingSprints = this.getExistingSprints((Issue)input.first(), (CustomField)input.second());
            existingSprints.remove(sprint);
            return this.convertSprintToParameters((CustomField)input.second(), existingSprints);
        }));
    }

    private boolean canBulkRemoveIssues(Sprint sprint) {
        boolean deleted = this.sprintManager.getSprint(sprint.getId()).isInvalid();
        boolean closed = Sprint.State.CLOSED.equals((Object)sprint.getState());
        return deleted || !closed;
    }

    private List<Issue> getParentIssuesFromIssues(Collection<Issue> issues) {
        return Lists.newArrayList((Iterable)Iterables.filter(issues, input -> !input.isSubTask()));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Iterable<Issue>> removeAllIssuesFromSprint(@Nullable ApplicationUser user, Sprint sprint) {
        if (!this.canBulkRemoveIssues(sprint)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.sprint.closed", new Object[0]);
        }
        ServiceOutcome<Iterable<Issue>> issuesForSprint = this.getIssuesForSprint(user, sprint);
        if (!issuesForSprint.isValid()) {
            return ServiceOutcomeImpl.error(issuesForSprint);
        }
        ServiceResult permissionCheck = this.sprintPermissionService.canAddRemoveIssuesToSprint(user, issuesForSprint.getValue());
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.error(permissionCheck);
        }
        Iterable<Issue> issues = issuesForSprint.get();
        ServiceResult removeResult = this.removeIssuesFromSprint(user, sprint, Sets.newHashSet(issues));
        if (!removeResult.isValid()) {
            return ServiceOutcomeImpl.error(removeResult);
        }
        return ServiceOutcomeImpl.ok(issues);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Iterable<Sprint>> getSprintsForIssue(@Nullable ApplicationUser user, Issue issue) {
        CustomField defaultSprintField = this.sprintCustomFieldService.getDefaultSprintField();
        List customFieldValue = (List)issue.getCustomFieldValue(defaultSprintField);
        customFieldValue = customFieldValue != null ? customFieldValue : Collections.emptyList();
        return ServiceOutcomeImpl.ok(customFieldValue);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Option<Sprint>> getActiveSprintForIssue(@Nullable ApplicationUser user, Issue issue) {
        return ServiceOutcomes.map(this.getSprintsForIssue(user, issue), new SprintFilterFunction(issue, SprintUtils.SPRINT_ACTIVE));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Option<Sprint>> getActiveOrFutureSprintForIssue(@Nullable ApplicationUser user, Issue issue) {
        return ServiceOutcomes.map(this.getSprintsForIssue(user, issue), new SprintFilterFunction(issue, SprintUtils.SPRINT_NOT_CLOSED));
    }

    @Override
    @Nonnull
    public ServiceOutcome<Iterable<Issue>> getIssuesForSprint(@Nullable ApplicationUser user, Sprint sprint) {
        CustomField sprintField = this.sprintCustomFieldService.getDefaultSprintField();
        Clause clause = JqlQueryBuilder.newClauseBuilder().field(sprintField.toString()).eq(sprint.getId()).buildClause();
        JqlQueryBuilder query = JqlQueryBuilder.newBuilder();
        query.where().addClause(clause);
        query.orderBy().issueKey(SortOrder.ASC);
        ServiceOutcome<SearchResults<Issue>> search = this.searchService.search(user, query.buildQuery());
        if (!search.isValid()) {
            return ServiceOutcomeImpl.error(search);
        }
        List issues = search.get().getResults();
        return ServiceOutcomeImpl.ok(issues);
    }

    private ServiceResult updateIssuesInSprint(@Nullable ApplicationUser user, Collection<Issue> issues, Function<Pair<Issue, CustomField>, IssueInputParameters> updateFunction) {
        return this.updateIssuesInSprint(user, issues, updateFunction, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResult updateIssuesInSprint(@Nullable ApplicationUser user, Collection<Issue> issues, Function<Pair<Issue, CustomField>, IssueInputParameters> updateFunction, boolean performValidation) {
        long startTime;
        ErrorCollection errors;
        block11: {
            CustomField sprintField;
            block10: {
                ServiceOutcome serviceOutcome;
                errors = new ErrorCollection();
                sprintField = this.sprintCustomFieldService.getDefaultSprintField();
                startTime = System.currentTimeMillis();
                this.issueIndexManager.hold();
                try {
                    if (!performValidation) break block10;
                    if (!this.updateWithValidation(user, issues, updateFunction, errors, sprintField)) break block11;
                    serviceOutcome = ServiceOutcomeImpl.from(errors);
                }
                catch (Throwable throwable) {
                    try {
                        this.issueIndexManager.release();
                    }
                    catch (IndexException e) {
                        this.logger.error("Uncaught exception while updating database; now IndexException when trying to release index hold: %s", e.getMessage());
                    }
                    throw throwable;
                }
                try {
                    this.issueIndexManager.release();
                }
                catch (IndexException e) {
                    this.logger.error("Uncaught exception while updating database; now IndexException when trying to release index hold: %s", e.getMessage());
                }
                return serviceOutcome;
            }
            this.updateWithoutValidation(user, issues, updateFunction, errors, sprintField);
        }
        try {
            this.issueIndexManager.release();
        }
        catch (IndexException e) {
            this.logger.error("Uncaught exception while updating database; now IndexException when trying to release index hold: %s", e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        this.logger.debug("Time taken for updating %d sprint issues : %d ms", issues.size(), endTime - startTime);
        if (errors.hasErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        return ServiceResultImpl.ok();
    }

    private boolean updateWithValidation(@Nullable ApplicationUser user, Collection<Issue> issues, Function<Pair<Issue, CustomField>, IssueInputParameters> updateFunction, ErrorCollection errors, CustomField sprintField) {
        ArrayList<IssueService.UpdateValidationResult> results = new ArrayList<IssueService.UpdateValidationResult>();
        for (Issue issue : issues) {
            IssueInputParameters params = (IssueInputParameters)updateFunction.apply((Object)Pair.of((Object)issue, (Object)sprintField));
            IssueService.UpdateValidationResult updateValidationResult = this.issueUpdateService.validateUpdate(user, issue.getId(), params);
            results.add(updateValidationResult);
            if (updateValidationResult.isValid()) continue;
            errors.addAllErrors(ErrorCollection.fromJiraErrorCollectionWithReasons(updateValidationResult.getErrorCollection()));
        }
        if (errors.hasErrors()) {
            return true;
        }
        for (IssueService.UpdateValidationResult result : results) {
            IssueService.IssueResult issueResult = this.issueUpdateService.update(user, result);
            if (issueResult.isValid()) continue;
            errors.addAllErrors(ErrorCollection.fromJiraErrorCollectionWithReasons(issueResult.getErrorCollection()));
        }
        return false;
    }

    private void updateWithoutValidation(@Nullable ApplicationUser user, Collection<Issue> issues, Function<Pair<Issue, CustomField>, IssueInputParameters> updateFunction, ErrorCollection errors, CustomField sprintField) {
        for (Issue issue : issues) {
            IssueService.IssueResult issueResult = this.issueUpdateService.skipValidationAndUpdate(user, issue.getId(), (IssueInputParameters)updateFunction.apply((Object)Pair.of((Object)issue, (Object)sprintField)));
            if (issueResult.isValid()) continue;
            errors.addAllErrors(ErrorCollection.fromJiraErrorCollectionWithReasons(issueResult.getErrorCollection()));
        }
    }

    private List<Sprint> getExistingSprints(Issue issue, CustomField sprintField) {
        Collection customFieldValue = (Collection)issue.getCustomFieldValue(sprintField);
        ArrayList<Sprint> values = new ArrayList<Sprint>();
        if (customFieldValue != null) {
            values.addAll(customFieldValue);
        }
        return values;
    }

    private String[] convertSprintsToString(CustomField customField, List<Sprint> sprints) {
        CustomFieldParamsImpl customFieldParams = new CustomFieldParamsImpl(customField, sprints);
        customFieldParams.transformObjectsToStrings();
        ArrayList sprintStrings = new ArrayList(customFieldParams.getValuesForNullKey());
        return sprintStrings.toArray(new String[0]);
    }

    private IssueInputParameters convertSprintToParameters(CustomField customField, List<Sprint> sprints) {
        String[] sprintValue = this.convertSprintsToString(customField, sprints);
        IssueInputParametersImpl params = new IssueInputParametersImpl();
        params.addCustomFieldValue(customField.getIdAsLong(), sprintValue);
        return params;
    }

    private static class SprintFilterFunction
    implements Function<Iterable<Sprint>, Option<Sprint>> {
        public final Issue issue;
        public final Predicate<Sprint> sprintPredicate;

        private SprintFilterFunction(Issue issue, Predicate<Sprint> sprintPredicate) {
            this.issue = issue;
            this.sprintPredicate = sprintPredicate;
        }

        public Option<Sprint> apply(@Nullable Iterable<Sprint> allSprints) {
            ImmutableList sprints = ImmutableList.copyOf((Iterable)Iterables.filter(allSprints, this.sprintPredicate));
            if (sprints.size() > 1) {
                throw new IllegalStateException("Issue " + this.issue.getKey() + " has multiple active or future sprints");
            }
            if (sprints.isEmpty()) {
                return Option.none();
            }
            return Option.some(sprints.iterator().next());
        }
    }
}

