/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.customfield.sprint.IssueKeyData;
import com.atlassian.greenhopper.customfield.sprint.SprintCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntry;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.ComposedIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueAndParentKeyCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueSummaryCallback;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintHistoryDataCollector;
import com.atlassian.greenhopper.service.sprint.SprintHistoryService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintHistoryServiceImpl
implements SprintHistoryService {
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;

    @Override
    @Nonnull
    public ServiceOutcome<Map<String, List<SprintHistoryEntry>>> findSprintHistory(ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull Sprint sprint, @Nonnull ClauseToAdd additionalClause) {
        return this.findSprintHistory(user, rapidView, sprint, additionalClause, null);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Map<String, List<SprintHistoryEntry>>> findSprintHistory(ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull Sprint sprint, @Nonnull ClauseToAdd additionalClause, IssueDataCallback issueDataCallback) {
        ServiceOutcome<Query> query = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!query.isValid()) {
            return ServiceOutcomeImpl.error(query);
        }
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)query.getValue());
        additionalClause.appendWithDefaultAnd(queryBuilder);
        CustomField sprintField = this.sprintCustomFieldService.getDefaultSprintField();
        SprintHistoryDataCollector sprintHistoryDataCollector = new SprintHistoryDataCollector(sprintField, sprint);
        IssueDataCallback collector = null;
        collector = issueDataCallback != null ? ComposedIssueDataCallback.of((IssueDataCallback[])new IssueDataCallback[]{sprintHistoryDataCollector, issueDataCallback}) : sprintHistoryDataCollector;
        ServiceOutcome<Void> collectOutcome = this.findHistoryForSprint(user, queryBuilder.buildQuery(), sprint, collector, sprintField);
        if (!collectOutcome.isValid()) {
            return ServiceOutcomeImpl.error(collectOutcome);
        }
        return ServiceOutcomeImpl.ok(sprintHistoryDataCollector.getIssueSprintHistory());
    }

    @Override
    @Nonnull
    public ServiceOutcome<IssueKeyData> findIssueKeysInSprint(ApplicationUser user, @Nonnull RapidView rapidView, @Nonnull Sprint sprint, @Nonnull ClauseToAdd additionalClause) {
        ServiceOutcome<Query> query = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!query.isValid()) {
            return ServiceOutcomeImpl.error(query);
        }
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)query.getValue());
        additionalClause.appendWithDefaultAnd(queryBuilder);
        CustomField sprintField = this.sprintCustomFieldService.getDefaultSprintField();
        IssueAndParentKeyCallback issueAndParentKeyCallback = new IssueAndParentKeyCallback();
        IssueSummaryCallback issueSummaryCallback = new IssueSummaryCallback();
        ComposedIssueDataCallback composedCallback = ComposedIssueDataCallback.of((IssueDataCallback[])new AbstractIssueDataCallback[]{issueAndParentKeyCallback, issueSummaryCallback});
        ServiceOutcome<Void> collectOutcome = this.findHistoryForSprint(user, queryBuilder.buildQuery(), sprint, composedCallback, sprintField);
        if (!collectOutcome.isValid()) {
            return ServiceOutcomeImpl.error(collectOutcome);
        }
        return ServiceOutcomeImpl.ok(new IssueKeyData(issueAndParentKeyCallback.getIssueToParentKeyMap(), issueSummaryCallback.getSummaries()));
    }

    private ServiceOutcome<Void> findHistoryForSprint(ApplicationUser user, Query query, Sprint sprint, IssueDataCallback callback, CustomField sprintField) {
        Term term = new Term(SprintCustomFieldIndexer.getHistoryFieldId(sprintField), sprint.getId().toString());
        TermQuery historySprintTerm = new TermQuery(term);
        return this.issueDataService.find(user, query, callback, (org.apache.lucene.search.Query)historySprintTerm);
    }
}

