/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntry;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.jira.issue.fields.CustomField;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;

public class SprintHistoryDataCollector
implements IssueDataCallback {
    private final CustomField sprintField;
    private String valuePrefix;
    private Map<String, List<SprintHistoryEntry>> issueSprintHistory;
    private List<SprintHistoryEntry> tempEntries;

    public SprintHistoryDataCollector(CustomField sprintField, Sprint sprint) {
        this.sprintField = sprintField;
        this.valuePrefix = SprintHistoryEntry.getLuceneValuePrefix(sprint.getId());
        this.issueSprintHistory = new HashMap<String, List<SprintHistoryEntry>>();
        this.tempEntries = new ArrayList<SprintHistoryEntry>();
    }

    @Override
    public Set<String> getFields() {
        return Collections.singleton(SprintCustomFieldIndexer.getChangesFieldId(this.sprintField));
    }

    @Override
    public boolean requiresIssueDoc() {
        return false;
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (data == null) {
            return;
        }
        if (!data.startsWith(this.valuePrefix)) {
            return;
        }
        SprintHistoryEntry entry = SprintHistoryEntry.fromLuceneValue(data);
        if (entry != null) {
            this.tempEntries.add(entry);
        }
    }

    @Override
    public void issueComplete(Long issueId, String issueKey, Option<Document> issueDoc) {
        this.issueSprintHistory.put(issueKey, this.tempEntries);
        this.tempEntries = new ArrayList<SprintHistoryEntry>();
    }

    public Map<String, List<SprintHistoryEntry>> getIssueSprintHistory() {
        return this.issueSprintHistory;
    }
}

