/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.sprint.SprintCFType;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.ManagedCustomFieldProvider;
import com.atlassian.greenhopper.service.index.IndexCheckService;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintCustomFieldServiceImpl
implements SprintCustomFieldService,
ManagedCustomFieldProvider {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String KEY_DEFAULT_SPRINT_CUSTOMFIELD_ID = "GreenHopper.Sprint.Default.customfield.id";
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private ReindexMessageManager reindexMessageManager;
    @Autowired
    private IndexCheckService indexCheckService;

    @Override
    public CustomField getDefaultSprintField() {
        CustomField sprintField = this.getDefaultSprintFieldOrNull();
        if (sprintField == null) {
            sprintField = this.createDefaultSprintField();
        }
        return sprintField;
    }

    @Override
    public boolean doesDefaultSprintFieldExist() {
        return this.getDefaultSprintFieldOrNull() != null;
    }

    private CustomField getDefaultSprintFieldOrNull() {
        this.log.debug("Requesting the Default Sprint field", new Object[0]);
        Long id = this.propertyDao.getLongProperty(KEY_DEFAULT_SPRINT_CUSTOMFIELD_ID);
        if (id != null) {
            this.log.debug("Field ID '%d' has been set -- verifying that the field still exists", id);
            CustomField sprintField = this.customFieldService.getCustomField(id);
            if (sprintField != null) {
                this.log.debug("Default Sprint field with custom field ID '%d' exists", sprintField.getIdAsLong());
                return sprintField;
            }
            this.log.debug("Sprint field with ID '%d' did not exist", id);
        }
        return null;
    }

    private synchronized CustomField createDefaultSprintField() {
        CustomField field = this.getDefaultSprintFieldOrNull();
        if (field == null) {
            this.checkCustomFieldDoesNotExist();
            field = this.createCustomField();
            this.propertyDao.setLongProperty(KEY_DEFAULT_SPRINT_CUSTOMFIELD_ID, field.getIdAsLong());
            this.reindexMessageManager.pushMessage(this.jiraAuthenticationContext.getUser(), "GreenHopper Sprint Field Creation");
            this.indexCheckService.setCheckNecessary(IndexCheckService.CheckType.SPRINT, (Option<String>)Option.none());
        }
        return field;
    }

    private void checkCustomFieldDoesNotExist() {
        Long id = this.propertyDao.getLongProperty(KEY_DEFAULT_SPRINT_CUSTOMFIELD_ID);
        if (id != null && this.customFieldService.verifyCustomFieldExistsInDB(id)) {
            throw new RuntimeException(String.format("Custom field '%s' with ID '%d' exists in DB, but was not returned by the custom field service.", "Sprint", id));
        }
    }

    private CustomField createCustomField() {
        CustomField field;
        List<CustomField> customFields = this.customFieldService.getCustomFields(SprintCFType.class);
        if (!customFields.isEmpty()) {
            field = customFields.get(0);
            this.log.info("Existing field found, using Sprint field called %s with id %d", field.getName(), field.getIdAsLong());
        } else {
            field = this.customFieldService.createCustomField(SprintCFType.CUSTOMFIELD_METADATA);
            this.log.info("Created Default Sprint field with ID '%d'", field.getIdAsLong());
        }
        return field;
    }

    @Override
    public Collection<CustomField> getManagedFields() {
        return Arrays.asList(this.getDefaultSprintField());
    }
}

