/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.manager.AOMapper;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintAO;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class SprintAOMapper
implements AOMapper<SprintAO, Sprint> {
    @Nonnull
    public Long getSequence(@Nonnull Sprint sprint) {
        Long sequence = sprint.getSequence();
        if (sequence == null) {
            sequence = sprint.getId();
        }
        return sequence;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(Sprint model) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RAPID_VIEW_ID", model.getRapidViewId());
        map.put("STARTED", model.getState() != Sprint.State.FUTURE);
        map.put("CLOSED", model.getState() == Sprint.State.CLOSED);
        map.put("NAME", model.getName());
        map.put("GOAL", model.getGoal());
        map.put("START_DATE", SprintAOMapper.toLong(model.getStartDate()));
        map.put("END_DATE", SprintAOMapper.toLong(model.getEndDate()));
        map.put("COMPLETE_DATE", SprintAOMapper.toLong(model.getCompleteDate()));
        return map;
    }

    @Override
    @Nonnull
    public Sprint toModel(SprintAO entityAO) {
        long sprintId = entityAO.getId();
        Sprint.State state = Sprint.State.FUTURE;
        if (entityAO.isClosed()) {
            state = Sprint.State.CLOSED;
        } else if (entityAO.isStarted()) {
            state = Sprint.State.ACTIVE;
        }
        Sprint.SprintBuilder builder = Sprint.builder().id(sprintId).name(entityAO.getName()).rapidViewId(entityAO.getRapidViewId()).state(state).startDate(entityAO.getStartDate()).endDate(entityAO.getEndDate()).completeDate(entityAO.getCompleteDate()).goal(entityAO.getGoal());
        Long sequenceAO = entityAO.getSequence();
        if (sequenceAO == null) {
            sequenceAO = entityAO.getId();
        }
        return builder.sequence(sequenceAO).build();
    }

    @Override
    public void update(Sprint source, SprintAO target) {
        target.setRapidViewId(source.getRapidViewId());
        target.setStarted(source.getState() != Sprint.State.FUTURE);
        target.setClosed(source.getState() == Sprint.State.CLOSED);
        target.setName(source.getName());
        target.setGoal(source.getGoal());
        target.setStartDate(SprintAOMapper.toLong(source.getStartDate()));
        target.setEndDate(SprintAOMapper.toLong(source.getEndDate()));
        target.setCompleteDate(SprintAOMapper.toLong(source.getCompleteDate()));
    }

    public void updateSequence(Sprint source, SprintAO target) {
        target.setSequence(source.getSequence());
    }

    private static Long toLong(DateTime date) {
        return date == null ? null : Long.valueOf(date.getMillis());
    }
}

