/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.api.entity.remotelink.sprint.RemoteSprintLink;
import com.atlassian.greenhopper.entity.remotelink.RemoteEntityLinkService;
import com.atlassian.greenhopper.events.RemoteSprintLinkEvent;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteSprintLinkService {
    public static final String SPRINT_REMOTE_LINK = "SprintRemoteLink";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired
    private SprintService sprintManager;
    @Autowired
    private RemoteEntityLinkService remoteEntityLinkService;
    @Autowired
    private SprintPermissionService sprintPermissionService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private EventPublisher eventPublisher;

    public ServiceOutcome<List<RemoteSprintLink>> getRemoteSprintLinks(ApplicationUser user, Sprint sprint) {
        return this.getRemoteSprintLinks(user, sprint, null);
    }

    public ServiceOutcome<List<RemoteSprintLink>> getRemoteSprintLinks(ApplicationUser user, Sprint sprint, final RemoteSprintLink.ApplicationType applicationType) {
        ServiceOutcome<Sprint> sprintOutcome = this.sprintManager.getSprint(user, sprint.getId());
        if (sprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintOutcome);
        }
        List<EntityProperty> linksProperties = this.remoteEntityLinkService.findByEntityId(SPRINT_REMOTE_LINK, sprint.getId());
        ImmutableList allRemoteSprintLinks = ImmutableList.copyOf((Iterable)Iterables.transform(linksProperties, (Function)new Function<EntityProperty, RemoteSprintLink>(){

            public RemoteSprintLink apply(EntityProperty input) {
                return RemoteSprintLinkService.this.transform(input);
            }
        }));
        if (applicationType == null) {
            return ServiceOutcomeImpl.ok(allRemoteSprintLinks);
        }
        Iterable filteredRemoteSprintLinks = Iterables.filter((Iterable)allRemoteSprintLinks, (Predicate)new Predicate<RemoteSprintLink>(){

            public boolean apply(@Nullable RemoteSprintLink remoteSprintLink) {
                return remoteSprintLink.getApplicationType().equals((Object)applicationType);
            }
        });
        ArrayList remoteSprintLinks = Lists.newArrayList((Iterable)filteredRemoteSprintLinks);
        return ServiceOutcomeImpl.ok(remoteSprintLinks);
    }

    public ServiceOutcome<List<RemoteSprintLink>> getRemoteLinkedSprintsByGlobalId(String globalId) {
        I18n2 i18n = this.i18nFactoryService.getI18n();
        if (Strings.isNullOrEmpty((String)globalId)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, i18n.getText("gh.remote.links.specify.link"), new Object[0]);
        }
        List<EntityProperty> sprints = this.remoteEntityLinkService.findByGlobalId(SPRINT_REMOTE_LINK, globalId);
        return ServiceOutcomeImpl.ok(ImmutableList.copyOf((Iterable)Iterables.transform(sprints, (Function)new Function<EntityProperty, RemoteSprintLink>(){

            public RemoteSprintLink apply(EntityProperty input) {
                return RemoteSprintLinkService.this.transform(input);
            }
        })));
    }

    public ServiceOutcome<Integer> countRemoteLinkedSprintsByGlobalId(String globalId) {
        List<EntityProperty> sprints = this.remoteEntityLinkService.findByGlobalId(SPRINT_REMOTE_LINK, globalId);
        return ServiceOutcomeImpl.ok(sprints != null ? sprints.size() : 0);
    }

    public ServiceOutcome<RemoteSprintLink> createRemoteSprintLink(ApplicationUser user, Long sprintId, String globalId, String title, String url, String relationship, String applicationType, String applicationName) {
        I18n2 i18n = this.i18nFactoryService.getI18n();
        if (sprintId == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, i18n.getText("gh.remote.links.specify.sprint"), new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)globalId)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, i18n.getText("gh.remote.links.specify.link"), new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)applicationType)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, i18n.getText("gh.remote.links.specify.application.type"), new Object[0]);
        }
        if (!RemoteSprintLink.ApplicationType.exists(applicationType)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, i18n.getText("gh.remote.links.sprint.unsupported.application.type", (Object)applicationType, (Object)RemoteSprintLink.ApplicationType.listNamesAsCommaSeparatedString()), new Object[0]);
        }
        ServiceOutcome<Sprint> sprintOutcome = this.sprintManager.getSprint(user, sprintId);
        if (sprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.from(sprintOutcome.getErrors());
        }
        Sprint sprint = sprintOutcome.getValue();
        if (!this.canEdit(user, sprint)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, i18n.getText("gh.remote.links.sprint.not.permitted"), sprint.getName());
        }
        try {
            JsonLink jsonLink = new JsonLink();
            jsonLink.title = title;
            jsonLink.url = url;
            jsonLink.relationship = relationship;
            jsonLink.applicationName = applicationName;
            jsonLink.applicationType = applicationType;
            String fixedGlobalId = this.remoteEntityLinkService.putEntityPropertyValue(SPRINT_REMOTE_LINK, globalId, OBJECT_MAPPER.writeValueAsString((Object)jsonLink), sprintId);
            EntityProperty entityProperty = this.remoteEntityLinkService.get(SPRINT_REMOTE_LINK, sprintId, fixedGlobalId);
            this.eventPublisher.publish((Object)new RemoteSprintLinkEvent(this.transform(entityProperty)));
            return ServiceOutcomeImpl.ok(this.transform(entityProperty));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, i18n.getText("gh.remote.links.error"), e.toString());
        }
    }

    public ServiceOutcome<Void> removeRemoteSprintLink(ApplicationUser user, Sprint sprint, Long linkId) {
        I18n2 i18n = this.i18nFactoryService.getI18n();
        if (!this.canEdit(user, sprint)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, i18n.getText("gh.remote.links.sprint.not.permitted"), sprint.getName());
        }
        List<EntityProperty> remoteSprintLinks = this.remoteEntityLinkService.findByEntityId(SPRINT_REMOTE_LINK, sprint.getId());
        for (EntityProperty remoteSprintLink : remoteSprintLinks) {
            if (!remoteSprintLink.getId().equals(linkId)) continue;
            this.remoteEntityLinkService.delete(SPRINT_REMOTE_LINK, sprint.getId(), remoteSprintLink.getKey());
            this.eventPublisher.publish((Object)new RemoteSprintLinkEvent(this.transform(remoteSprintLink)));
            break;
        }
        return ServiceOutcomeImpl.ok();
    }

    public ServiceOutcome<Void> removeAllRemoteSprintLinks(ApplicationUser user, Sprint sprint) {
        I18n2 i18n = this.i18nFactoryService.getI18n();
        if (!this.canEdit(user, sprint)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, i18n.getText("gh.remote.links.sprint.not.permitted"), sprint.getName());
        }
        List<EntityProperty> remoteSprintLinks = this.remoteEntityLinkService.findByEntityId(SPRINT_REMOTE_LINK, sprint.getId());
        this.remoteEntityLinkService.deleteAll(SPRINT_REMOTE_LINK, sprint.getId());
        HashSet<String> publishedLinks = new HashSet<String>();
        for (EntityProperty remoteSprintLink : remoteSprintLinks) {
            if (publishedLinks.contains(remoteSprintLink.getKey())) continue;
            this.eventPublisher.publish((Object)new RemoteSprintLinkEvent(this.transform(remoteSprintLink)));
            publishedLinks.add(remoteSprintLink.getKey());
        }
        return ServiceOutcomeImpl.ok();
    }

    private boolean canEdit(ApplicationUser user, Sprint sprint) {
        ServiceResult canUpdate = this.sprintPermissionService.canUpdateSprint(user, sprint);
        return canUpdate.isValid();
    }

    private RemoteSprintLink transform(EntityProperty entityProperty) {
        try {
            JsonLink jsonLink = (JsonLink)OBJECT_MAPPER.readValue(entityProperty.getValue(), JsonLink.class);
            RemoteSprintLink.ApplicationType applicationType = RemoteSprintLink.ApplicationType.resolve(jsonLink.applicationType);
            return new RemoteSprintLink(entityProperty.getId(), entityProperty.getEntityId(), entityProperty.getKey(), jsonLink.title, jsonLink.url, jsonLink.relationship, applicationType, jsonLink.applicationName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class JsonLink {
        public String title;
        public String url;
        public String relationship;
        public String applicationType;
        public String applicationName;
    }
}

