/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.sprint;

import com.atlassian.greenhopper.api.entity.remotelink.sprint.RemoteSprintLink;
import com.atlassian.greenhopper.api.sprints.RemoteLinkedSprint;
import com.atlassian.greenhopper.api.sprints.RemoteLinkedSprints;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemaining;
import com.atlassian.greenhopper.service.sprint.SprintTimeRemainingService;
import com.atlassian.greenhopper.web.rapid.RapidViewLocationResolverFactory;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteLinkedSprintMapper {
    private final String GO_TO_BOARD_URL = "secure/GHGoToBoard.jspa?sprintId=%s";
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private SprintTimeRemainingService sprintTimeRemainingService;
    @Autowired
    private RapidViewLocationResolverFactory rapidViewLocationResolverFactory;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidViewManager rapidViewManager;

    public ServiceOutcome<RemoteLinkedSprints> mapList(ApplicationUser user, List<RemoteSprintLink> linkedSprints) {
        ArrayList<RemoteLinkedSprint> sprintModelList = new ArrayList<RemoteLinkedSprint>();
        ErrorCollection errorCollection = new ErrorCollection();
        for (RemoteSprintLink linkedSprint : linkedSprints) {
            ServiceOutcome<RemoteLinkedSprint> sprint = this.map(user, linkedSprint);
            if (sprint.isValid()) {
                sprintModelList.add(sprint.getValue());
                continue;
            }
            errorCollection.addAllErrors(sprint.getErrors());
        }
        if (errorCollection.getDefinitiveReason() == ErrorCollection.Reason.SERVER_ERROR) {
            return ServiceOutcomeImpl.from(errorCollection);
        }
        RemoteLinkedSprints sprints = new RemoteLinkedSprints();
        sprints.sprints = sprintModelList;
        return ServiceOutcomeImpl.ok(sprints);
    }

    public ServiceOutcome<RemoteLinkedSprint> map(ApplicationUser user, RemoteSprintLink linkedSprint) {
        ServiceOutcome<Set<RapidView>> rapidViewsForSprint;
        Long sprintId = linkedSprint.getSprintId();
        ServiceOutcome<Sprint> sprintOutcome = this.sprintManager.getSprint(sprintId);
        if (sprintOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintOutcome);
        }
        Sprint sprint = sprintOutcome.getValue();
        RemoteLinkedSprint sprintModel = new RemoteLinkedSprint();
        sprintModel.id = sprintId;
        sprintModel.title = sprint.getName();
        sprintModel.status = this.getStatus(user, sprint);
        Long rapidViewId = sprint.getRapidViewId();
        if (rapidViewId == null && (rapidViewsForSprint = this.rapidViewLocationResolverFactory.forSprint().getRapidViewsForObject(user, sprint)).isValid() && !rapidViewsForSprint.getValue().isEmpty()) {
            RapidView rapidView = rapidViewsForSprint.getValue().iterator().next();
            rapidViewId = rapidView.getId();
        }
        if (rapidViewId != null && this.rapidViewManager.get(rapidViewId).isValid()) {
            ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(user, rapidViewId);
            if (rapidViewOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(rapidViewOutcome);
            }
            if (sprint.isActive()) {
                ServiceOutcome<SprintTimeRemaining> daysRemaining = this.sprintTimeRemainingService.getSprintTimeRemaining(user, rapidViewOutcome.getValue(), sprint.getId());
                if (daysRemaining.isInvalid()) {
                    return ServiceOutcomeImpl.error(daysRemaining);
                }
                sprintModel.daysRemaining = daysRemaining.getValue().days;
            }
        }
        sprintModel.url = this.getUrl(sprint);
        return ServiceOutcomeImpl.ok(sprintModel);
    }

    private String getUrl(Sprint sprint) {
        return String.format("secure/GHGoToBoard.jspa?sprintId=%s", sprint.getId());
    }

    private String getStatus(ApplicationUser user, Sprint sprint) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        if (sprint.isActive()) {
            return i18n.getText("gh.sprint.status.active");
        }
        if (sprint.isClosed()) {
            return i18n.getText("gh.sprint.status.complete");
        }
        return i18n.getText("gh.sprint.status.future");
    }
}

