/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.searchrequest;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.service.searchrequest.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestEntity;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.util.Visitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchRequestServiceImpl
implements SearchRequestService {
    private final LoggerWrapper log = LoggerWrapper.with(SearchRequestServiceImpl.class);
    @Autowired
    private SearchRequestManager searchRequestManager;

    @Override
    public void visitAll(final Visitor<SearchRequest> searchRequestVisitor) {
        this.searchRequestManager.visitAll((Visitor)new Visitor<SearchRequestEntity>(){

            public void visit(SearchRequestEntity searchRequestEntity) {
                try {
                    SearchRequest searchRequest = SearchRequestServiceImpl.this.searchRequestManager.getSearchRequestById(searchRequestEntity.getId());
                    if (searchRequest != null) {
                        searchRequestVisitor.visit((Object)searchRequest);
                    }
                }
                catch (Exception e) {
                    SearchRequestServiceImpl.this.log.exception(e);
                    return;
                }
            }
        });
    }

    @Override
    public SearchRequest update(SearchRequest searchRequest) {
        return this.searchRequestManager.update(searchRequest);
    }
}

