/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.workingdays;

import com.atlassian.greenhopper.manager.workingdays.WorkingDaysManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.workingdays.WorkingDaysService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkingDaysServiceImpl
implements WorkingDaysService {
    @Autowired
    TimeZoneService timeZoneService;
    @Autowired
    RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    WorkingDaysManager workingDaysManager;

    @Override
    public DateTimeZone getDateTimeZone(WorkingDaysConfig config) {
        String timezoneId = config.getTimezoneId();
        if (timezoneId == null || timezoneId.isEmpty() || timezoneId.equals("defaultTimeZoneId")) {
            return this.getJiraDefaultTimeZone();
        }
        return DateTimeZone.forID((String)timezoneId);
    }

    private DateTimeZone getJiraDefaultTimeZone() {
        JiraServiceContextImpl context = new JiraServiceContextImpl((ApplicationUser)null);
        TimeZoneInfo defaultTimeZoneInfo = this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)context);
        TimeZone timeZone = TimeZone.getTimeZone(defaultTimeZoneInfo.getTimeZoneId());
        return DateTimeZone.forTimeZone((TimeZone)timeZone);
    }

    @Override
    public String getDateTimeZoneIdForUser(ApplicationUser user) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        boolean usesJiraTimeZone = this.timeZoneService.usesJiraTimeZone((JiraServiceContext)context);
        if (!usesJiraTimeZone) {
            TimeZoneInfo userTimeZoneInfo = this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)context);
            if (!context.getErrorCollection().hasAnyErrors()) {
                return userTimeZoneInfo.getTimeZoneId();
            }
        }
        return "defaultTimeZoneId";
    }

    @Override
    public ServiceOutcome<WorkingDaysConfig> getWorkingDaysConfiguration(ApplicationUser user, RapidView rapidView) {
        return this.workingDaysManager.get(rapidView);
    }

    @Override
    public ServiceOutcome<WorkingDaysConfig> updateWorkingDaysConfiguration(ApplicationUser user, RapidView rapidView, WorkingDaysConfig workingDaysConfig) {
        ServiceOutcome<Void> outcome = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return this.workingDaysManager.update(rapidView, workingDaysConfig);
    }

    @Override
    public ServiceOutcome<WorkingDaysConfig> addNonWorkingDay(ApplicationUser user, RapidView rapidView, LocalDate date) {
        ServiceOutcome<Void> outcome = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        ServiceOutcome<WorkingDaysConfig> config = this.workingDaysManager.get(rapidView);
        if (!config.isValid()) {
            return ServiceOutcomeImpl.error(config);
        }
        if (config.getValue().containsNonWorkingDay(date)) {
            return config;
        }
        WorkingDaysConfig updatedConfig = WorkingDaysConfig.builder(config.getValue()).addNonWorkingDay(date).build();
        return this.workingDaysManager.update(rapidView, updatedConfig);
    }

    @Override
    public ServiceOutcome<WorkingDaysConfig> removeNonWorkingDay(ApplicationUser user, RapidView rapidView, LocalDate date) {
        ServiceOutcome<Void> outcome = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        ServiceOutcome<WorkingDaysConfig> config = this.workingDaysManager.get(rapidView);
        if (!config.isValid()) {
            return ServiceOutcomeImpl.error(config);
        }
        if (!config.getValue().containsNonWorkingDay(date)) {
            return config;
        }
        WorkingDaysConfig updatedConfig = WorkingDaysConfig.builder(config.getValue()).removeNonWorkingDay(date).build();
        return this.workingDaysManager.update(rapidView, updatedConfig);
    }
}

