/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.subquery;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryManager;
import com.atlassian.greenhopper.service.subquery.Subquery;
import com.atlassian.greenhopper.service.subquery.SubqueryService;
import com.atlassian.greenhopper.web.rapid.view.JqlHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.order.OrderByImpl;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ExperimentalApi
public class SubqueryServiceImpl
implements SubqueryService {
    private final RapidViewPermissionService rapidViewPermissionService;
    private final JqlHelper jqlHelper;
    private final SubqueryManager subqueryManager;

    @Autowired
    public SubqueryServiceImpl(RapidViewPermissionService rapidViewPermissionService, JqlHelper jqlHelper, SubqueryManager subqueryManager) {
        this.rapidViewPermissionService = rapidViewPermissionService;
        this.jqlHelper = jqlHelper;
        this.subqueryManager = subqueryManager;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Subquery> updateSubquery(ApplicationUser user, RapidView rapidView, Subquery subquery) {
        ServiceOutcome<Void> permissionOutcome = this.rapidViewPermissionService.validateModifyPermission(user, rapidView);
        if (!permissionOutcome.isValid()) {
            return ServiceOutcomeImpl.error(permissionOutcome);
        }
        ServiceResult queryOutcome = this.validateQuery(user, subquery);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        return this.subqueryManager.updateSubquery(rapidView, subquery);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Subquery> getSubquery(ApplicationUser user, RapidView rapidView) {
        Subquery subquery = this.subqueryManager.getSubquery(rapidView);
        if (subquery == null) {
            return ServiceOutcomeImpl.ok(Subquery.builder().emptyQuery().build());
        }
        String sanitisedQuery = this.jqlHelper.getSanitisedQueryString(user, subquery.getQuery());
        return ServiceOutcomeImpl.ok(Subquery.builder(subquery).query(sanitisedQuery).build());
    }

    private ServiceResult validateQuery(ApplicationUser user, Subquery subquery) {
        if (StringUtils.isNotBlank((CharSequence)subquery.getQuery())) {
            ServiceOutcome<Query> query = this.jqlHelper.validateJql(user, subquery.getQuery(), "query");
            if (query.isValid() && !query.get().getOrderByClause().equals(OrderByImpl.NO_ORDER)) {
                return ServiceOutcomeImpl.error("query", ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.board.error.subquery.orderby", new Object[0]);
            }
            return ServiceResultImpl.ok();
        }
        return ServiceResultImpl.ok();
    }
}

