/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.subquery;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.greenhopper.cache.CacheFactoryManager;
import com.atlassian.greenhopper.events.board.BoardEventPublisher;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.RapidViewDao;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryAO;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryAOMapper;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryDao;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryManager;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryServiceImpl;
import com.atlassian.greenhopper.service.subquery.Subquery;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubqueryManagerImpl
implements SubqueryManager {
    @Autowired
    private SubqueryDao subqueryDao;
    @Autowired
    private RapidViewDao rapidViewDao;
    @Autowired
    private SubqueryAOMapper subqueryAOMapper;
    @Autowired
    private CacheFactoryManager cacheFactoryManager;
    @Autowired
    private BoardEventPublisher boardEventPublisher;
    private Cache<Long, Subquery> subqueryCache;

    @PostConstruct
    public void init() {
        this.subqueryCache = this.cacheFactoryManager.create().getCache(SubqueryServiceImpl.class.getName() + ".subqueryCache", new SubqueryCacheLoader(), CacheFactoryManager.defaultCacheSettings());
    }

    @Override
    public void flushCache() {
        this.subqueryCache.removeAll();
    }

    @Override
    public Subquery getSubquery(RapidView rapidView) {
        return this.subqueryCache.get(rapidView.getId());
    }

    @Override
    public void invalidateCache(RapidView view) {
        this.subqueryCache.remove(view.getId());
    }

    @Override
    public ServiceOutcome<Subquery> updateSubquery(RapidView rapidView, Subquery subquery) {
        SubqueryAO subqueryAO = this.subqueryDao.findByRapidView(rapidView.getId());
        if (subqueryAO != null) {
            this.subqueryAOMapper.update(subquery, subqueryAO);
            this.subqueryDao.save(subqueryAO);
        } else {
            ServiceOutcome rapidViewAO = this.rapidViewDao.load(rapidView.getId());
            if (!rapidViewAO.isValid()) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "Unable to create subquery as the provided rapid view is invalid", new Object[0]);
            }
            subqueryAO = (SubqueryAO)this.subqueryDao.create(this.subqueryAOMapper.toAO((RapidViewAO)rapidViewAO.getValue(), subquery));
        }
        this.invalidateCache(rapidView);
        if (rapidView.getType() == RapidView.Type.KANBAN) {
            this.boardEventPublisher.publishBoardConfigurationChangedEvent(rapidView);
        }
        return ServiceOutcomeImpl.ok(this.subqueryAOMapper.toModel(subqueryAO));
    }

    private class SubqueryCacheLoader
    implements CacheLoader<Long, Subquery> {
        private SubqueryCacheLoader() {
        }

        @Override
        public Subquery load(@Nonnull Long rapidViewId) {
            SubqueryAO subqueryAO = SubqueryManagerImpl.this.subqueryDao.findByRapidView(rapidViewId);
            if (subqueryAO != null) {
                return SubqueryManagerImpl.this.subqueryAOMapper.toModel(subqueryAO);
            }
            return Subquery.builder().emptyQuery().build();
        }
    }
}

