/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.subquery;

import com.atlassian.greenhopper.manager.RelatedEntityDao;
import com.atlassian.greenhopper.service.rapid.view.AOUtil;
import com.atlassian.greenhopper.service.rapid.view.GenericActiveObjectsDao;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryAO;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryAOListMapper;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryAOMapper;
import com.atlassian.greenhopper.service.subquery.Subquery;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubqueryDao
extends GenericActiveObjectsDao<Long, SubqueryAO>
implements RelatedEntityDao<Long, RapidViewAO, SubqueryAO, Subquery> {
    @Autowired
    private SubqueryAOMapper subqueryAOMapper;

    public SubqueryAO[] getForParent(RapidViewAO rapidViewAO) {
        return this.getForParent(rapidViewAO.getId());
    }

    public SubqueryAO[] getForParent(Long rapidViewId) {
        return (SubqueryAO[])this.findBy("RAPID_VIEW_ID = ?", new Object[]{rapidViewId});
    }

    @Override
    public List<SubqueryAO> updateForParent(RapidViewAO rapidViewAO, List<Subquery> subqueries) {
        return AOUtil.setListValues(this.ao, new SubqueryAOListMapper(rapidViewAO, this.subqueryAOMapper), new ArrayList<Subquery>(subqueries));
    }

    public SubqueryAO findByRapidView(Long rapidViewId) {
        SubqueryAO[] subqueryAOs = (SubqueryAO[])this.findBy("RAPID_VIEW_ID = ? AND SECTION = ?", new Object[]{rapidViewId, "board.kanban.work"});
        if (subqueryAOs.length > 0) {
            return subqueryAOs[0];
        }
        return null;
    }

    @Override
    public void deleteForParent(RapidViewAO rapidViewAO) {
        this.delete(rapidViewAO.getSubqueries());
    }
}

