/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.service.rapid.view.subquery;

import com.atlassian.greenhopper.manager.RelatedAOMapper;
import com.atlassian.greenhopper.service.rapid.view.RapidViewAO;
import com.atlassian.greenhopper.service.rapid.view.subquery.SubqueryAO;
import com.atlassian.greenhopper.service.subquery.Subquery;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service
public class SubqueryAOMapper
implements RelatedAOMapper<RapidViewAO, SubqueryAO, Subquery> {
    public static final String SUBQUERY_SECTION = "board.kanban.work";

    @Override
    public Map<String, Object> toAO(RapidViewAO rapidViewAO, Subquery subquery) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(subquery));
        map.put("RAPID_VIEW_ID", rapidViewAO);
        return map;
    }

    @Override
    @Nonnull
    public Map<String, Object> toAO(Subquery subquery) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LONG_QUERY", subquery.getQuery());
        map.put("SECTION", SUBQUERY_SECTION);
        return map;
    }

    @Override
    @Nonnull
    public Subquery toModel(SubqueryAO subqueryAO) {
        String query = subqueryAO.getLongQuery();
        if (query == null) {
            query = subqueryAO.getQuery();
        }
        return Subquery.builder().id(subqueryAO.getId()).query(query).build();
    }

    @Override
    public void update(Subquery subquery, SubqueryAO subqueryAO) {
        subqueryAO.setLongQuery(subquery.getQuery());
        subqueryAO.setSection(SUBQUERY_SECTION);
        if (subqueryAO.getQuery() != null) {
            subqueryAO.setQuery(null);
        }
    }
}

